/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.document;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfigReader;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.LogReader;
import org.eclipse.wst.wsi.internal.core.log.LogWriter;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfig;
import org.eclipse.wst.wsi.internal.core.monitor.config.MonitorConfigReader;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertionsReader;
import org.eclipse.wst.wsi.internal.core.report.Report;
import org.eclipse.wst.wsi.internal.core.report.ReportWriter;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.util.WSIProperties;

public abstract class DocumentFactory {
    public static DocumentFactory newInstance() throws WSIException {
        return DocumentFactory.newInstance(DocumentFactory.getFactoryClassName());
    }

    public static DocumentFactory newInstance(String factoryClassName) throws WSIException {
        DocumentFactory documentFactory = null;
        if (factoryClassName != null) {
            try {
                Class<?> factoryClass = Class.forName(factoryClassName);
                documentFactory = (DocumentFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new WSIException("Could not instantiate document factory class: " + factoryClassName + ".", e);
            }
        } else {
            throw new WSIException("A WSIDocumentFactory implementation class was not found.");
        }
        return documentFactory;
    }

    public abstract Log newLog();

    public abstract MonitorConfig newMonitorConfig();

    public abstract AnalyzerConfig newAnalyzerConfig();

    public abstract ProfileAssertions newProfileAssertions();

    public abstract Report newReport();

    public abstract ProfileAssertionsReader newProfileAssertionsReader();

    public abstract MonitorConfigReader newMonitorConfigReader();

    public abstract AnalyzerConfigReader newAnalyzerConfigReader();

    public abstract LogReader newLogReader();

    public abstract ReportWriter newReportWriter();

    public abstract LogWriter newLogWriter();

    public abstract Reporter newReporter(Report var1, ReportWriter var2);

    private static String getFactoryClassName() {
        return WSIProperties.getProperty("wsi.document.factory", "org.eclipse.wst.wsi.internal.core.document.impl.DocumentFactoryImpl");
    }
}

