/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;

public class PublishServerJob
extends ChainedJob {
    protected int kind;
    protected boolean check;

    public PublishServerJob(IServer server, int kind, boolean check) {
        super(NLS.bind((String)Messages.publishing, (Object)server.getName()), server);
        this.kind = kind;
        this.check = check;
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule[] rules = new ISchedulingRule[]{ruleFactory.createRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), new ServerSchedulingRule(server)};
        this.setRule(MultiRule.combine((ISchedulingRule[])rules));
    }

    public PublishServerJob(IServer server) {
        this(server, 1, true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!(!this.check || ServerPreferences.getInstance().isAutoPublishing() && ((Server)this.getServer()).shouldPublish())) {
            return Status.OK_STATUS;
        }
        return this.getServer().publish(this.kind, monitor);
    }
}

