/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util.declaration;

import org.eclipse.wst.css.core.internal.contentmodel.PropCMProperty;
import org.eclipse.wst.css.core.internal.parserz.CSSTextParser;
import org.eclipse.wst.css.core.internal.parserz.CSSTextToken;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.declaration.CSSPropertyContext;
import org.eclipse.wst.css.core.internal.util.declaration.IShorthandAdapter;

public class BorderTopShorthandAdapter
implements IShorthandAdapter {
    public boolean expand(String source, CSSPropertyContext dest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return false;
        }
        String color = "";
        String style = "";
        String width = "";
        PropCMProperty propColor = PropCMProperty.getInstanceOf("border-top-color");
        PropCMProperty propStyle = PropCMProperty.getInstanceOf("border-top-style");
        PropCMProperty propWidth = PropCMProperty.getInstanceOf("border-top-width");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propStyle.canHave(tokens[i].image)) {
                    style = tokens[i].image;
                } else if (propWidth.canHave(tokens[i].image)) {
                    width = tokens[i].image;
                } else if (propColor.canHave(tokens[i].image)) {
                    color = tokens[i].image;
                }
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER") {
                width = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_HASH") {
                color = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_FUNCTION") {
                StringBuffer buf = new StringBuffer();
                while (i < tokens.length) {
                    if (tokens[i].kind == "COMMENT") {
                        ++i;
                        continue;
                    }
                    buf.append(tokens[i].image);
                    if (tokens[i++].kind == "DECLARATION_VALUE_PARENTHESIS_CLOSE") break;
                }
                --i;
                color = buf.toString();
            }
            ++i;
        }
        dest.set(propColor.getName(), color);
        dest.set(propStyle.getName(), style);
        dest.set(propWidth.getName(), width);
        return true;
    }

    public String extract(String source, PropCMProperty propDest) {
        CSSTextParser parser = new CSSTextParser(2, source);
        CSSTextToken[] tokens = parser.getTokens();
        if (tokens.length <= 0) {
            return null;
        }
        String color = null;
        String style = null;
        String width = null;
        PropCMProperty propColor = PropCMProperty.getInstanceOf("border-top-color");
        PropCMProperty propStyle = PropCMProperty.getInstanceOf("border-top-style");
        PropCMProperty propWidth = PropCMProperty.getInstanceOf("border-top-width");
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].kind == "DECLARATION_VALUE_IDENT") {
                if (propStyle.canHave(tokens[i].image)) {
                    style = tokens[i].image;
                } else if (propWidth.canHave(tokens[i].image)) {
                    width = tokens[i].image;
                } else if (propColor.canHave(tokens[i].image)) {
                    color = tokens[i].image;
                }
            } else if (CSSUtil.isLength(tokens[i]) || tokens[i].kind == "DECLARATION_VALUE_NUMBER") {
                width = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_HASH") {
                color = tokens[i].image;
            } else if (tokens[i].kind == "DECLARATION_VALUE_FUNCTION") {
                StringBuffer buf = new StringBuffer();
                while (i < tokens.length) {
                    if (tokens[i].kind == "COMMENT") {
                        ++i;
                        continue;
                    }
                    buf.append(tokens[i].image);
                    if (tokens[i++].kind == "DECLARATION_VALUE_PARENTHESIS_CLOSE") break;
                }
                --i;
                color = buf.toString();
            }
            ++i;
        }
        if (propColor == propDest) {
            return color;
        }
        if (propStyle == propDest) {
            return style;
        }
        if (propWidth == propDest) {
            return width;
        }
        return null;
    }
}

