/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private Label fControl;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private boolean fLeftIsLocal;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.binary_compare_view_context");
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fControl = new Label(parent, 64);
        this.fControl.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        this.fLeftIsLocal = Utilities.getBoolean(cc, "LEFT_IS_LOCAL", false);
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setInput(Object input) {
        block19: {
            String message;
            block20: {
                InputStream right;
                InputStream left;
                block18: {
                    if (this.fControl == null || !(input instanceof ICompareInput)) break block19;
                    this.fInput = (ICompareInput)input;
                    left = null;
                    right = null;
                    message = null;
                    try {
                        try {
                            left = this.getStream(this.fInput.getLeft());
                            right = this.getStream(this.fInput.getRight());
                            if (left != null && right != null) {
                                int pos = 0;
                                while (true) {
                                    int r;
                                    int l;
                                    if ((l = left.read()) != (r = right.read())) {
                                        String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                                        message = MessageFormat.format((String)format, (Object[])new String[]{Integer.toString(pos)});
                                    } else if (l != -1) {
                                        ++pos;
                                        continue;
                                    }
                                    break;
                                }
                            } else if (left == null && right == null) {
                                message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                            } else if (left == null) {
                                message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "deletedMessage") : Utilities.getString(this.fBundle, "addedMessage");
                            } else if (right == null) {
                                message = this.fLeftIsLocal ? Utilities.getString(this.fBundle, "addedMessage") : Utilities.getString(this.fBundle, "deletedMessage");
                            }
                        }
                        catch (CoreException coreException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                            break block18;
                        }
                        catch (IOException iOException) {
                            message = Utilities.getString(this.fBundle, "errorMessage");
                            break block18;
                        }
                    }
                    catch (Throwable throwable) {
                        Utilities.close(left);
                        Utilities.close(right);
                        throw throwable;
                    }
                    Utilities.close(left);
                    Utilities.close(right);
                    break block20;
                }
                Utilities.close(left);
                Utilities.close(right);
            }
            if (message != null) {
                this.fControl.setText(message);
            }
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

