/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class GenerateHashCodeEqualsDialog
extends SourceActionDialog {
    public GenerateHashCodeEqualsDialog(Shell shell, CompilationUnitEditor editor, IType type, IVariableBinding[] allFields, IVariableBinding[] selectedFields) throws JavaModelException {
        super(shell, (ILabelProvider)new BindingLabelProvider(), new GenerateHashCodeEqualsContentProvider(allFields), editor, type, false);
        this.setEmptyListMessage(JavaUIMessages.GenerateHashCodeEqualsDialog_no_entries);
        this.setInitialSelections(selectedFields);
        this.setTitle(JavaUIMessages.GenerateHashCodeEqualsDialog_dialog_title);
        this.setMessage(JavaUIMessages.GenerateHashCodeEqualsDialog_select_fields_to_include);
        this.setValidator(new GenerateHashCodeEqualsValidator(allFields.length));
        this.setSize(60, 18);
        this.setInput(new Object());
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.hash_code_equals_tree_selection_dialog_context");
    }

    private static class GenerateHashCodeEqualsContentProvider
    implements ITreeContentProvider {
        IVariableBinding[] fBindings;

        public GenerateHashCodeEqualsContentProvider(IVariableBinding[] allFields) {
            this.fBindings = allFields;
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.fBindings;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class GenerateHashCodeEqualsValidator
    implements ISelectionStatusValidator {
        private static int fNumFields;

        public GenerateHashCodeEqualsValidator(int entries) {
            fNumFields = entries;
        }

        public IStatus validate(Object[] selection) {
            int count = 0;
            int index = 0;
            while (index < selection.length) {
                if (selection[index] instanceof IVariableBinding) {
                    ++count;
                }
                ++index;
            }
            if (count == 0) {
                return new StatusInfo(4, JavaUIMessages.GenerateHashCodeEqualsDialog_select_at_least_one_field);
            }
            return new StatusInfo(1, Messages.format(JavaUIMessages.GenerateHashCodeEqualsDialog_selectioninfo_more, new String[]{String.valueOf(count), String.valueOf(fNumFields)}));
        }
    }
}

