/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ClassPathContainer
implements IAdaptable,
IWorkbenchAdapter {
    private IJavaProject fProject;
    private IClasspathEntry fClassPathEntry;
    private IClasspathContainer fContainer;

    public ClassPathContainer(IJavaProject parent, IClasspathEntry entry) {
        this.fProject = parent;
        this.fClassPathEntry = entry;
        try {
            this.fContainer = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)parent);
        }
        catch (JavaModelException javaModelException) {
            this.fContainer = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassPathContainer) {
            ClassPathContainer other = (ClassPathContainer)obj;
            if (this.fProject.equals(other.fProject) && this.fClassPathEntry.equals(other.fClassPathEntry)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fProject.hashCode() * 17 + this.fClassPathEntry.hashCode();
    }

    public Object[] getPackageFragmentRoots() {
        return this.fProject.findPackageFragmentRoots(this.fClassPathEntry);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IResource.class && this.fContainer instanceof IAdaptable) {
            return ((IAdaptable)this.fContainer).getAdapter(IResource.class);
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return ClassPathContainer.concatenate(this.getPackageFragmentRoots(), this.getRequiredProjects());
    }

    private Object[] getRequiredProjects() {
        ArrayList<RequiredProjectWrapper> list = new ArrayList<RequiredProjectWrapper>();
        if (this.fContainer != null) {
            IClasspathEntry[] classpathEntries = this.fContainer.getClasspathEntries();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < classpathEntries.length) {
                IResource resource;
                IClasspathEntry entry = classpathEntries[i];
                if (entry.getEntryKind() == 2 && (resource = root.findMember(entry.getPath())) instanceof IProject) {
                    list.add(new RequiredProjectWrapper(JavaCore.create((IResource)resource)));
                }
                ++i;
            }
        }
        return list.toArray();
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return JavaPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        if (this.fContainer != null) {
            return this.fContainer.getDescription();
        }
        IPath path = this.fClassPathEntry.getPath();
        String containerId = path.segment(0);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerId);
        if (initializer != null) {
            String description = initializer.getDescription(path, this.fProject);
            return Messages.format(PackagesMessages.ClassPathContainer_unbound_label, description);
        }
        return Messages.format(PackagesMessages.ClassPathContainer_unknown_label, path.toString());
    }

    public Object getParent(Object o) {
        return this.getJavaProject();
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public IClasspathEntry getClasspathEntry() {
        return this.fClassPathEntry;
    }

    static boolean contains(IJavaProject project, IClasspathEntry entry, IPackageFragmentRoot root) {
        IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entry);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].equals(root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class RequiredProjectWrapper
    implements IAdaptable,
    IWorkbenchAdapter {
        private final IJavaElement fProject;
        private static ImageDescriptor DESC_OBJ_PROJECT;

        public RequiredProjectWrapper(IJavaElement project) {
            ISharedImages images = JavaPlugin.getDefault().getWorkbench().getSharedImages();
            DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
            this.fProject = project;
        }

        public IJavaElement getProject() {
            return this.fProject;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return this;
            }
            return null;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return DESC_OBJ_PROJECT;
        }

        public String getLabel(Object o) {
            return this.fProject.getElementName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

