/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;

public class ASTResolving {
    private static final PrimitiveType.Code[] CODE_ORDER = new PrimitiveType.Code[]{PrimitiveType.CHAR, PrimitiveType.SHORT, PrimitiveType.INT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE};

    public static ITypeBinding guessBindingForReference(ASTNode node) {
        return Bindings.normalizeTypeBinding(ASTResolving.getPossibleReferenceBinding(node));
    }

    private static ITypeBinding getPossibleReferenceBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                if (node.equals((Object)assignment.getLeftHandSide())) {
                    return assignment.getRightHandSide().resolveTypeBinding();
                }
                return assignment.getLeftHandSide().resolveTypeBinding();
            }
            case 27: {
                InfixExpression infix = (InfixExpression)parent;
                InfixExpression.Operator op = infix.getOperator();
                if (op == InfixExpression.Operator.CONDITIONAL_AND || op == InfixExpression.Operator.CONDITIONAL_OR) {
                    return infix.getAST().resolveWellKnownType("boolean");
                }
                if (op == InfixExpression.Operator.LEFT_SHIFT || op == InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED || op == InfixExpression.Operator.RIGHT_SHIFT_SIGNED) {
                    return infix.getAST().resolveWellKnownType("int");
                }
                if (node.equals((Object)infix.getLeftOperand())) {
                    ITypeBinding rigthHandBinding = infix.getRightOperand().resolveTypeBinding();
                    if (rigthHandBinding != null) {
                        return rigthHandBinding;
                    }
                } else {
                    ITypeBinding leftHandBinding = infix.getLeftOperand().resolveTypeBinding();
                    if (leftHandBinding != null) {
                        return leftHandBinding;
                    }
                }
                if (op == InfixExpression.Operator.EQUALS || op == InfixExpression.Operator.NOT_EQUALS) break;
                return infix.getAST().resolveWellKnownType("int");
            }
            case 62: {
                InstanceofExpression instanceofExpression = (InstanceofExpression)parent;
                return instanceofExpression.getRightOperand().resolveBinding();
            }
            case 59: {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                if (!frag.getInitializer().equals((Object)node)) break;
                return frag.getName().resolveTypeBinding();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)parent;
                IMethodBinding superMethodBinding = ASTNodes.getMethodBinding((Name)superMethodInvocation.getName());
                if (superMethodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superMethodInvocation.arguments(), superMethodBinding);
            }
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)parent;
                IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                if (methodBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, methodInvocation.arguments(), methodBinding);
            }
            case 46: {
                SuperConstructorInvocation superInvocation = (SuperConstructorInvocation)parent;
                IMethodBinding superBinding = superInvocation.resolveConstructorBinding();
                if (superBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, superInvocation.arguments(), superBinding);
            }
            case 17: {
                ConstructorInvocation constrInvocation = (ConstructorInvocation)parent;
                IMethodBinding constrBinding = constrInvocation.resolveConstructorBinding();
                if (constrBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, constrInvocation.arguments(), constrBinding);
            }
            case 14: {
                ClassInstanceCreation creation = (ClassInstanceCreation)parent;
                IMethodBinding creationBinding = creation.resolveConstructorBinding();
                if (creationBinding == null) break;
                return ASTResolving.getParameterTypeBinding(node, creation.arguments(), creationBinding);
            }
            case 36: {
                return ASTResolving.guessBindingForReference(parent);
            }
            case 2: {
                if (((ArrayAccess)parent).getIndex().equals((Object)node)) {
                    return parent.getAST().resolveWellKnownType("int");
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 3: {
                if (!((ArrayCreation)parent).dimensions().contains(node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 4: {
                ASTNode initializerParent = parent.getParent();
                int dim = 1;
                while (initializerParent instanceof ArrayInitializer) {
                    initializerParent = initializerParent.getParent();
                    ++dim;
                }
                ArrayType creationType = null;
                if (initializerParent instanceof ArrayCreation) {
                    creationType = ((ArrayCreation)initializerParent).getType();
                } else if (initializerParent instanceof VariableDeclaration) {
                    VariableDeclaration varDecl = (VariableDeclaration)initializerParent;
                    creationType = ASTNodes.getType(varDecl);
                    dim -= ASTNodes.getExtraDimensions(varDecl);
                } else if (initializerParent instanceof MemberValuePair) {
                    String name = ((MemberValuePair)initializerParent).getName().getIdentifier();
                    IMethodBinding annotMember = ASTResolving.findAnnotationMember((Annotation)initializerParent.getParent(), name);
                    if (annotMember != null) {
                        return ASTResolving.getReducedDimensionBinding(annotMember.getReturnType(), dim, annotMember.getReturnType().getElementType());
                    }
                }
                if (creationType == null) break;
                while (creationType instanceof ArrayType && dim > 0) {
                    creationType = creationType.getComponentType();
                    --dim;
                }
                return creationType.resolveBinding();
            }
            case 16: {
                ConditionalExpression expression = (ConditionalExpression)parent;
                if (node.equals((Object)expression.getExpression())) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                if (node.equals((Object)expression.getElseExpression())) {
                    return expression.getThenExpression().resolveTypeBinding();
                }
                return expression.getElseExpression().resolveTypeBinding();
            }
            case 37: {
                return parent.getAST().resolveWellKnownType("int");
            }
            case 38: {
                if (((PrefixExpression)parent).getOperator() == PrefixExpression.Operator.NOT) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                return parent.getAST().resolveWellKnownType("int");
            }
            case 19: 
            case 25: 
            case 61: {
                if (!(node instanceof Expression)) break;
                return parent.getAST().resolveWellKnownType("boolean");
            }
            case 50: {
                if (!((SwitchStatement)parent).getExpression().equals((Object)node)) break;
                return parent.getAST().resolveWellKnownType("int");
            }
            case 41: {
                MethodDeclaration decl = ASTResolving.findParentMethodDeclaration(parent);
                if (decl == null || decl.isConstructor()) break;
                return decl.getReturnType2().resolveBinding();
            }
            case 11: {
                return ((CastExpression)parent).getType().resolveBinding();
            }
            case 12: 
            case 53: {
                return parent.getAST().resolveWellKnownType("java.lang.Exception");
            }
            case 22: {
                if (!node.equals((Object)((FieldAccess)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 47: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 40: {
                if (!node.equals((Object)((QualifiedName)parent).getName())) break;
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 49: {
                if (!node.equals((Object)((SwitchCase)parent).getExpression()) || !(parent.getParent() instanceof SwitchStatement)) break;
                return ((SwitchStatement)parent.getParent()).getExpression().resolveTypeBinding();
            }
            case 6: {
                if (node.getLocationInParent() == AssertStatement.EXPRESSION_PROPERTY) {
                    return parent.getAST().resolveWellKnownType("boolean");
                }
                return parent.getAST().resolveWellKnownType("java.lang.String");
            }
            case 79: {
                IMethodBinding annotMember = ASTResolving.findAnnotationMember((Annotation)parent, "value");
                if (annotMember == null) break;
                return annotMember.getReturnType();
            }
            case 80: {
                String name = ((MemberValuePair)parent).getName().getIdentifier();
                IMethodBinding annotMember = ASTResolving.findAnnotationMember((Annotation)parent.getParent(), name);
                if (annotMember == null) break;
                return annotMember.getReturnType();
            }
        }
        return null;
    }

    private static IMethodBinding findAnnotationMember(Annotation annotation, String name) {
        ITypeBinding annotBinding = annotation.resolveTypeBinding();
        if (annotBinding != null) {
            return Bindings.findMethodInType(annotBinding, name, null);
        }
        return null;
    }

    public static Type guessTypeForReference(AST ast, ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 59: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 44: {
                    if (((VariableDeclarationFragment)parent).getInitializer() == node) {
                        return ASTNodeFactory.newType(ast, (VariableDeclaration)parent);
                    }
                    return null;
                }
                case 2: {
                    Type type;
                    if (!((ArrayAccess)parent).getIndex().equals((Object)node) && (type = ASTResolving.guessTypeForReference(ast, parent)) != null) {
                        return ast.newArrayType(type);
                    }
                    return null;
                }
                case 22: {
                    if (node.equals((Object)((FieldAccess)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                case 36: 
                case 47: {
                    node = parent;
                    parent = parent.getParent();
                    break;
                }
                case 40: {
                    if (node.equals((Object)((QualifiedName)parent).getName())) {
                        node = parent;
                        parent = parent.getParent();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static ITypeBinding getReducedDimensionBinding(ITypeBinding arrayBinding, int dimsToReduce, ITypeBinding def) {
        if (dimsToReduce == 0) {
            return arrayBinding;
        }
        if (arrayBinding.getDimensions() == dimsToReduce) {
            return arrayBinding.getElementType();
        }
        return def;
    }

    private static ITypeBinding getParameterTypeBinding(ASTNode node, List args, IMethodBinding binding) {
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        int index = args.indexOf(node);
        if (index >= 0 && index < paramTypes.length) {
            return paramTypes[index];
        }
        return null;
    }

    public static ITypeBinding guessBindingForTypeReference(ASTNode node) {
        ITypeBinding binding;
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == QualifiedName.QUALIFIER_PROPERTY) {
            return null;
        }
        if (locationInParent == SimpleType.NAME_PROPERTY) {
            node = node.getParent();
        }
        if ((binding = Bindings.normalizeTypeBinding(ASTResolving.getPossibleTypeBinding(node))) != null && binding.isWildcardType()) {
            return ASTResolving.normalizeWildcardType(binding, true, node.getAST());
        }
        return binding;
    }

    private static ITypeBinding getPossibleTypeBinding(ASTNode node) {
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 5: {
                int dim = 1;
                while (parent.getParent() instanceof ArrayType) {
                    parent = parent.getParent();
                    ++dim;
                }
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding != null && parentBinding.getDimensions() == dim) {
                    return parentBinding.getElementType();
                }
                return null;
            }
            case 74: {
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding == null || !parentBinding.isParameterizedType()) {
                    return null;
                }
                if (node.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
                    return parentBinding;
                }
                ITypeBinding[] typeArguments = parentBinding.getTypeArguments();
                List argumentNodes = ((ParameterizedType)parent).typeArguments();
                int index = argumentNodes.indexOf(node);
                if (index != -1 && typeArguments.length == argumentNodes.size()) {
                    return typeArguments[index];
                }
                return null;
            }
            case 76: {
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding == null || !parentBinding.isWildcardType()) {
                    return null;
                }
                WildcardType wildcardType = (WildcardType)parent;
                if (parentBinding.isUpperbound() == wildcardType.isUpperBound()) {
                    return parentBinding.getBound();
                }
                return null;
            }
            case 75: {
                ITypeBinding parentBinding = ASTResolving.getPossibleTypeBinding(parent);
                if (parentBinding == null || !parentBinding.isMember()) {
                    return null;
                }
                if (node.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return parentBinding.getDeclaringClass();
                }
                return parentBinding;
            }
            case 60: {
                return ASTResolving.guessVariableType(((VariableDeclarationStatement)parent).fragments());
            }
            case 23: {
                return ASTResolving.guessVariableType(((FieldDeclaration)parent).fragments());
            }
            case 58: {
                return ASTResolving.guessVariableType(((VariableDeclarationExpression)parent).fragments());
            }
            case 44: {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)parent;
                if (varDecl.getInitializer() == null) break;
                return Bindings.normalizeTypeBinding(varDecl.getInitializer().resolveTypeBinding());
            }
            case 3: {
                ArrayCreation creation = (ArrayCreation)parent;
                if (creation.getInitializer() != null) {
                    return creation.getInitializer().resolveTypeBinding();
                }
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 57: {
                return ((TypeLiteral)parent).getType().resolveBinding();
            }
            case 14: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 11: {
                return ASTResolving.getPossibleReferenceBinding(parent);
            }
            case 65: {
                List thrownExcpetions;
                ASTNode methNode;
                TagElement tagElement = (TagElement)parent;
                if (!"@throws".equals(tagElement.getTagName()) && !"@exception".equals(tagElement.getTagName()) || !((methNode = tagElement.getParent().getParent()) instanceof MethodDeclaration) || (thrownExcpetions = ((MethodDeclaration)methNode).thrownExceptions()).size() != 1) break;
                return ((Name)thrownExcpetions.get(0)).resolveTypeBinding();
            }
        }
        return null;
    }

    private static ITypeBinding guessVariableType(List fragments) {
        for (VariableDeclarationFragment frag : fragments) {
            if (frag.getInitializer() == null) continue;
            return Bindings.normalizeTypeBinding(frag.getInitializer().resolveTypeBinding());
        }
        return null;
    }

    public static ITypeBinding[] getQualifierGuess(ASTNode searchRoot, final String selector, List arguments, final IBinding context) {
        final int nArgs = arguments.size();
        final ArrayList result = new ArrayList();
        ITypeBinding binding = searchRoot.getAST().resolveWellKnownType("java.lang.Object");
        IMethodBinding[] objectMethods = binding.getDeclaredMethods();
        int i = 0;
        while (i < objectMethods.length) {
            IMethodBinding meth = objectMethods[i];
            if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                return new ITypeBinding[]{binding};
            }
            ++i;
        }
        ASTResolving.visitAllBindings(searchRoot, new TypeBindingVisitor(){
            private HashSet fVisitedBindings = new HashSet(100);

            public boolean visit(ITypeBinding node) {
                if ((node = Bindings.normalizeTypeBinding(node)) == null) {
                    return true;
                }
                if (!this.fVisitedBindings.add(node.getKey())) {
                    return true;
                }
                if (node.isGenericType()) {
                    return true;
                }
                if (context != null && !ASTResolving.isUseableTypeInContext(node, context, false)) {
                    return true;
                }
                IMethodBinding[] methods = node.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    IMethodBinding meth = methods[i];
                    if (meth.getName().equals(selector) && meth.getParameterTypes().length == nArgs) {
                        result.add(node);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result.toArray(new ITypeBinding[result.size()]);
    }

    public static void visitAllBindings(ASTNode astRoot, TypeBindingVisitor visitor) {
        try {
            astRoot.accept((ASTVisitor)new AllBindingsVisitor(visitor));
        }
        catch (AllBindingsVisitor.VisitCancelledException visitCancelledException) {}
    }

    public static IBinding getParentMethodOrTypeBinding(ASTNode node) {
        do {
            if (node instanceof MethodDeclaration) {
                return ((MethodDeclaration)node).resolveBinding();
            }
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (!(node instanceof AnonymousClassDeclaration)) continue;
            return ((AnonymousClassDeclaration)node).resolveBinding();
        } while ((node = node.getParent()) != null);
        return null;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            node = node.getParent();
        }
        return (BodyDeclaration)node;
    }

    public static BodyDeclaration findParentBodyDeclaration(ASTNode node, boolean treatModifiersOutside) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof BodyDeclaration) {
                BodyDeclaration decl = (BodyDeclaration)node;
                if (!treatModifiersOutside || lastLocation != decl.getModifiersProperty()) {
                    return decl;
                }
                treatModifiersOutside = false;
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return (BodyDeclaration)node;
    }

    public static CompilationUnit findParentCompilationUnit(ASTNode node) {
        return (CompilationUnit)ASTResolving.findAncestor(node, 15);
    }

    public static ASTNode findParentType(ASTNode node, boolean treatModifiersOutside) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)node;
                if (!treatModifiersOutside || lastLocation != decl.getModifiersProperty()) {
                    return decl;
                }
            } else if (node instanceof AnonymousClassDeclaration) {
                return node;
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return null;
    }

    public static ASTNode findParentType(ASTNode node) {
        return ASTResolving.findParentType(node, false);
    }

    public static MethodDeclaration findParentMethodDeclaration(ASTNode node) {
        while (node != null) {
            if (node.getNodeType() == 31) {
                return (MethodDeclaration)node;
            }
            if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    public static ASTNode findAncestor(ASTNode node, int nodeType) {
        while (node != null && node.getNodeType() != nodeType) {
            node = node.getParent();
        }
        return node;
    }

    public static Statement findParentStatement(ASTNode node) {
        while (node != null && !(node instanceof Statement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (Statement)node;
    }

    public static TryStatement findParentTryStatement(ASTNode node) {
        while (node != null && !(node instanceof TryStatement)) {
            if (!((node = node.getParent()) instanceof BodyDeclaration)) continue;
            return null;
        }
        return (TryStatement)node;
    }

    public static boolean isInsideConstructorInvocation(MethodDeclaration methodDeclaration, ASTNode node) {
        Statement statement;
        return methodDeclaration.isConstructor() && ((statement = ASTResolving.findParentStatement(node)) instanceof ConstructorInvocation || statement instanceof SuperConstructorInvocation);
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node, boolean treatModifiersOutside) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)node;
                if (!treatModifiersOutside || lastLocation != decl.getModifiersProperty()) {
                    return decl.resolveBinding();
                }
            } else if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return null;
    }

    public static boolean isInsideModifiers(ASTNode node) {
        while (node != null && !(node instanceof BodyDeclaration)) {
            if (node instanceof Annotation) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    public static boolean isInStaticContext(ASTNode selectedNode) {
        BodyDeclaration decl = ASTResolving.findParentBodyDeclaration(selectedNode);
        if (decl instanceof MethodDeclaration) {
            if (ASTResolving.isInsideConstructorInvocation((MethodDeclaration)decl, selectedNode)) {
                return true;
            }
            return Modifier.isStatic((int)decl.getModifiers());
        }
        if (decl instanceof Initializer) {
            return Modifier.isStatic((int)((Initializer)decl).getModifiers());
        }
        if (decl instanceof FieldDeclaration) {
            return Modifier.isStatic((int)((FieldDeclaration)decl).getModifiers());
        }
        return false;
    }

    public static boolean isWriteAccess(Name selectedNode) {
        Name curr = selectedNode;
        ASTNode parent = curr.getParent();
        while (parent != null) {
            switch (parent.getNodeType()) {
                case 40: {
                    if (((QualifiedName)parent).getQualifier() != curr) break;
                    return false;
                }
                case 22: {
                    if (((FieldAccess)parent).getExpression() != curr) break;
                    return false;
                }
                case 47: {
                    break;
                }
                case 7: {
                    return ((Assignment)parent).getLeftHandSide() == curr;
                }
                case 44: 
                case 59: {
                    return ((VariableDeclaration)parent).getName() == curr;
                }
                case 37: 
                case 38: {
                    return true;
                }
                default: {
                    return false;
                }
            }
            curr = parent;
            parent = curr.getParent();
        }
        return false;
    }

    public static int getPossibleTypeKinds(ASTNode node, boolean is50OrHigher) {
        int kinds = ASTResolving.internalGetPossibleTypeKinds(node);
        if (!is50OrHigher) {
            kinds &= 6;
        }
        return kinds;
    }

    private static int internalGetPossibleTypeKinds(ASTNode node) {
        int kind = 126;
        int mask = 254;
        ASTNode parent = node.getParent();
        while (parent instanceof QualifiedName) {
            if (node.getLocationInParent() == QualifiedName.QUALIFIER_PROPERTY) {
                return 30;
            }
            node = parent;
            parent = parent.getParent();
            mask = 30;
        }
        while (parent instanceof Type) {
            if (parent instanceof QualifiedType) {
                if (node.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
                    return mask & 0x1E;
                }
                mask &= 0x1E;
            } else if (parent instanceof ParameterizedType) {
                if (node.getLocationInParent() == ParameterizedType.TYPE_ARGUMENTS_PROPERTY) {
                    return mask & 0x3E;
                }
                mask &= 6;
            } else if (parent instanceof WildcardType && node.getLocationInParent() == WildcardType.BOUND_PROPERTY) {
                return mask & 0x3E;
            }
            node = parent;
            parent = parent.getParent();
        }
        switch (parent.getNodeType()) {
            case 55: {
                if (node.getLocationInParent() == TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY) {
                    kind = 4;
                    break;
                }
                if (node.getLocationInParent() != TypeDeclaration.SUPERCLASS_TYPE_PROPERTY) break;
                kind = 2;
                break;
            }
            case 71: {
                kind = 4;
                break;
            }
            case 31: {
                if (node.getLocationInParent() == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                    kind = 2;
                    break;
                }
                if (node.getLocationInParent() != MethodDeclaration.RETURN_TYPE2_PROPERTY) break;
                kind = 254;
                break;
            }
            case 62: {
                kind = 30;
                break;
            }
            case 53: {
                kind = 2;
                break;
            }
            case 14: {
                if (((ClassInstanceCreation)parent).getAnonymousClassDeclaration() == null) {
                    kind = 2;
                    break;
                }
                kind = 6;
                break;
            }
            case 44: {
                int superParent = parent.getParent().getNodeType();
                if (superParent != 12) break;
                kind = 2;
                break;
            }
            case 65: {
                kind = 30;
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                kind = 8;
                break;
            }
            case 73: {
                if (((TypeParameter)parent).typeBounds().indexOf(node) > 0) {
                    kind = 4;
                    break;
                }
                kind = 62;
                break;
            }
            case 57: {
                kind = 30;
            }
        }
        return kind & mask;
    }

    public static String getFullName(Name name) {
        return name.getFullyQualifiedName();
    }

    public static ICompilationUnit findCompilationUnitForBinding(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding) throws JavaModelException {
        if (binding == null || !binding.isFromSource() || binding.isTypeVariable() || binding.isWildcardType()) {
            return null;
        }
        ASTNode node = astRoot.findDeclaringNode((IBinding)binding.getTypeDeclaration());
        if (node == null) {
            ICompilationUnit targetCU = Bindings.findCompilationUnit(binding, cu.getJavaProject());
            if (targetCU != null) {
                return targetCU;
            }
            return null;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            return cu;
        }
        return null;
    }

    public static ITypeBinding[] getRelaxingTypes(AST ast, ITypeBinding type) {
        ArrayList<ITypeBinding> res = new ArrayList<ITypeBinding>();
        res.add(type);
        if (type.isArray()) {
            res.add(ast.resolveWellKnownType("java.lang.Object"));
            res.add(ast.resolveWellKnownType("java.io.Serializable"));
            res.add(ast.resolveWellKnownType("java.lang.Cloneable"));
        } else if (type.isPrimitive()) {
            PrimitiveType.Code code = PrimitiveType.toCode((String)type.getName());
            boolean found = false;
            int i = 0;
            while (i < CODE_ORDER.length) {
                if (found) {
                    String typeName = CODE_ORDER[i].toString();
                    res.add(ast.resolveWellKnownType(typeName));
                }
                if (code == CODE_ORDER[i]) {
                    found = true;
                }
                ++i;
            }
        } else {
            ASTResolving.collectRelaxingTypes(res, type);
        }
        return res.toArray(new ITypeBinding[res.size()]);
    }

    private static void collectRelaxingTypes(Collection res, ITypeBinding type) {
        ITypeBinding[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            ITypeBinding curr = interfaces[i];
            if (!res.contains(curr)) {
                res.add(curr);
            }
            ASTResolving.collectRelaxingTypes(res, curr);
            ++i;
        }
        ITypeBinding binding = type.getSuperclass();
        if (binding != null) {
            if (!res.contains(binding)) {
                res.add(binding);
            }
            ASTResolving.collectRelaxingTypes(res, binding);
        }
    }

    public static String getBaseNameFromExpression(IJavaProject project, Expression assignedExpression) {
        String name = null;
        if (assignedExpression instanceof Name) {
            Name simpleNode = (Name)assignedExpression;
            IBinding binding = simpleNode.resolveBinding();
            String varName = ASTNodes.getSimpleNameIdentifier(simpleNode);
            if (binding instanceof IVariableBinding) {
                CompilationUnit astRoot;
                varName = ((IVariableBinding)binding).isField() ? NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)project, (String)varName, (int)binding.getModifiers()) : ((astRoot = (CompilationUnit)assignedExpression.getRoot()).findDeclaringNode(binding) instanceof SingleVariableDeclaration ? NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)project, (String)varName) : NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaProject)project, (String)varName));
            }
            return varName;
        }
        if (assignedExpression instanceof MethodInvocation) {
            name = ((MethodInvocation)assignedExpression).getName().getIdentifier();
        } else if (assignedExpression instanceof SuperMethodInvocation) {
            name = ((SuperMethodInvocation)assignedExpression).getName().getIdentifier();
        } else if (assignedExpression instanceof FieldAccess) {
            return ((FieldAccess)assignedExpression).getName().getIdentifier();
        }
        if (name != null && name.length() > 3 && name.startsWith("get")) {
            return name.substring(3);
        }
        return null;
    }

    public static String[] suggestLocalVariableNames(IJavaProject project, ITypeBinding binding, Expression expression, String[] excludedNames) {
        ArrayList<String> res = new ArrayList<String>();
        ITypeBinding base = binding.isArray() ? binding.getElementType() : binding;
        IPackageBinding packBinding = base.getPackage();
        String packName = packBinding != null ? packBinding.getName() : "";
        String name = ASTResolving.getBaseNameFromExpression(project, expression);
        if (name != null) {
            String[] argname = StubUtility.getLocalNameSuggestions(project, name, 0, excludedNames);
            int i = 0;
            while (i < argname.length) {
                String curr = argname[i];
                if (!res.contains(curr)) {
                    res.add(curr);
                }
                ++i;
            }
        }
        String typeName = base.getName();
        String[] names = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)packName, (String)typeName, (int)binding.getDimensions(), (String[])excludedNames);
        int i = 0;
        while (i < names.length) {
            String curr = names[i];
            if (!res.contains(curr)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] getUsedVariableNames(ASTNode node) {
        CompilationUnit root = (CompilationUnit)node.getRoot();
        IBinding[] varsBefore = new ScopeAnalyzer(root).getDeclarationsInScope(node.getStartPosition(), 2);
        IBinding[] varsAfter = new ScopeAnalyzer(root).getDeclarationsAfter(node.getStartPosition() + node.getLength(), 2);
        String[] names = new String[varsBefore.length + varsAfter.length];
        int i = 0;
        while (i < varsBefore.length) {
            names[i] = varsBefore[i].getName();
            ++i;
        }
        i = 0;
        while (i < varsAfter.length) {
            names[i + varsBefore.length] = varsAfter[i].getName();
            ++i;
        }
        return names;
    }

    private static boolean isVariableDefinedInContext(IBinding binding, ITypeBinding typeVariable) {
        IVariableBinding var;
        if (binding.getKind() == 3 && (binding = (var = (IVariableBinding)binding).getDeclaringMethod()) == null) {
            binding = var.getDeclaringClass();
        }
        if (binding instanceof IMethodBinding) {
            if (binding == typeVariable.getDeclaringMethod()) {
                return true;
            }
            binding = ((IMethodBinding)binding).getDeclaringClass();
        }
        while (binding instanceof ITypeBinding) {
            if (binding == typeVariable.getDeclaringClass()) {
                return true;
            }
            if (Modifier.isStatic((int)binding.getModifiers())) break;
            binding = ((ITypeBinding)binding).getDeclaringClass();
        }
        return false;
    }

    public static boolean isUseableTypeInContext(ITypeBinding[] binding, IBinding context, boolean noWildcards) {
        int i = 0;
        while (i < binding.length) {
            if (!ASTResolving.isUseableTypeInContext(binding[i], context, noWildcards)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUseableTypeInContext(ITypeBinding type, IBinding context, boolean noWildcards) {
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (type.isAnonymous()) {
            return false;
        }
        if (type.isRawType() || type.isPrimitive()) {
            return true;
        }
        if (type.isTypeVariable()) {
            return ASTResolving.isVariableDefinedInContext(context, type);
        }
        if (type.isGenericType()) {
            ITypeBinding[] typeParameters = type.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                if (!ASTResolving.isUseableTypeInContext(typeParameters[i], context, noWildcards)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type.isParameterizedType()) {
            ITypeBinding[] typeArguments = type.getTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                if (!ASTResolving.isUseableTypeInContext(typeArguments[i], context, noWildcards)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (type.isCapture()) {
            type = type.getWildcard();
        }
        if (type.isWildcardType()) {
            if (noWildcards) {
                return false;
            }
            if (type.getBound() != null) {
                return ASTResolving.isUseableTypeInContext(type.getBound(), context, noWildcards);
            }
        }
        return true;
    }

    public static ITypeBinding normalizeWildcardType(ITypeBinding wildcardType, boolean isBindingToAssign, AST ast) {
        ITypeBinding bound = wildcardType.getBound();
        if (isBindingToAssign) {
            if (bound == null || !wildcardType.isUpperbound()) {
                return ast.resolveWellKnownType("java.lang.Object");
            }
        } else if (bound == null || wildcardType.isUpperbound()) {
            return null;
        }
        return bound;
    }

    public static String getTypeSignature(ITypeBinding type) {
        return BindingLabelProvider.getBindingLabel((IBinding)type, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static String getMethodSignature(IMethodBinding binding, boolean inOtherCU) {
        StringBuffer buf = new StringBuffer();
        if (inOtherCU && !binding.isConstructor()) {
            buf.append(binding.getDeclaringClass().getTypeDeclaration().getName()).append('.');
        }
        return BindingLabelProvider.getBindingLabel((IBinding)binding, BindingLabelProvider.DEFAULT_TEXTFLAGS);
    }

    public static String getMethodSignature(String name, ITypeBinding[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append(name).append('(');
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                buf.append(JavaElementLabels.COMMA_STRING);
            }
            buf.append(ASTResolving.getTypeSignature(params[i]));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static CompilationUnit createQuickFixAST(ICompilationUnit compilationUnit, IProgressMonitor monitor) {
        ASTParser astParser = ASTParser.newParser((int)3);
        astParser.setSource(compilationUnit);
        astParser.setResolveBindings(true);
        astParser.setStatementsRecovery(true);
        return (CompilationUnit)astParser.createAST(monitor);
    }

    private static class AllBindingsVisitor
    extends GenericVisitor {
        private final TypeBindingVisitor fVisitor;

        public AllBindingsVisitor(TypeBindingVisitor visitor) {
            super(true);
            this.fVisitor = visitor;
        }

        public boolean visit(SimpleName node) {
            ITypeBinding binding = node.resolveTypeBinding();
            if (binding != null) {
                boolean res = this.fVisitor.visit(binding);
                if (res) {
                    res = Bindings.visitHierarchy(binding, this.fVisitor);
                }
                if (!res) {
                    throw new VisitCancelledException();
                }
            }
            return false;
        }

        private static class VisitCancelledException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            private VisitCancelledException() {
            }
        }
    }
}

