/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class FTP
extends Task {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int LIST_FILES = 3;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    protected static final int RM_DIR = 6;
    private static final int CODE_521 = 521;
    public static final int DEFAULT_FTP_PORT = 21;
    private String remotedir;
    private String server;
    private String userid;
    private String password;
    private File listing;
    private boolean binary = true;
    private boolean passive = false;
    private boolean verbose = false;
    private boolean newerOnly = false;
    private long timeDiffMillis = 0L;
    private boolean timeDiffAuto = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private int port = 21;
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private boolean preserveLastModified = false;
    private String chmod = null;
    private String umask = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    protected static final String[] ACTION_STRS = new String[]{"sending", "getting", "deleting", "listing", "making directory", "chmod", "removing"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"sent", "retrieved", "deleted", "listed", "created directory", "mode changed", "removed"};
    protected static final String[] ACTION_TARGET_STRS = new String[]{"files", "files", "files", "files", "directory", "files", "directories"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFunctioningAsDirectory(FTPClient ftp, String dir, FTPFile file) {
        boolean result = false;
        String currentWorkingDir = null;
        if (file.isDirectory()) {
            return true;
        }
        if (file.isFile()) {
            return false;
        }
        try {
            currentWorkingDir = ftp.printWorkingDirectory();
        }
        catch (IOException ioe) {
            this.getProject().log("could not find current working directory " + dir + " while checking a symlink", 4);
        }
        if (currentWorkingDir == null) return result;
        try {
            result = ftp.changeWorkingDirectory(file.getLink());
        }
        catch (IOException ioe) {
            this.getProject().log("could not cd to " + file.getLink() + " while checking a symlink", 4);
        }
        if (!result) return result;
        boolean comeback = false;
        try {
            try {
                comeback = ftp.changeWorkingDirectory(currentWorkingDir);
            }
            catch (IOException ioe) {
                this.getProject().log("could not cd back to " + dir + " while checking a symlink", 0);
                Object var9_11 = null;
                if (comeback) return result;
                throw new BuildException("could not cd back to " + dir + " while checking a symlink");
            }
            Object var9_10 = null;
            if (comeback) return result;
            throw new BuildException("could not cd back to " + dir + " while checking a symlink");
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (comeback) throw throwable;
            throw new BuildException("could not cd back to " + dir + " while checking a symlink");
        }
    }

    private boolean isFunctioningAsFile(FTPClient ftp, String dir, FTPFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isFile()) {
            return true;
        }
        return !this.isFunctioningAsDirectory(ftp, dir, file);
    }

    public void setRemotedir(String dir) {
        this.remotedir = dir;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setTimeDiffMillis(long timeDiffMillis) {
        this.timeDiffMillis = timeDiffMillis;
    }

    public void setTimeDiffAuto(boolean timeDiffAuto) {
        this.timeDiffAuto = timeDiffAuto;
    }

    public void setPreserveLastModified(boolean preserveLastModified) {
        this.preserveLastModified = preserveLastModified;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setSeparator(String separator) {
        this.remoteFileSep = separator;
    }

    public void setChmod(String theMode) {
        this.chmod = theMode;
    }

    public void setUmask(String theUmask) {
        this.umask = theUmask;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(String action) throws BuildException {
        this.log("DEPRECATED - The setAction(String) method has been deprecated. Use setAction(FTP.Action) instead.");
        Action a = new Action();
        a.setValue(action);
        this.action = a.getAction();
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setListing(File listing) {
        this.listing = listing;
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.server == null) {
            throw new BuildException("server attribute must be set!");
        }
        if (this.userid == null) {
            throw new BuildException("userid attribute must be set!");
        }
        if (this.password == null) {
            throw new BuildException("password attribute must be set!");
        }
        if (this.action == 3 && this.listing == null) {
            throw new BuildException("listing attribute must be set for list action!");
        }
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int transferFiles(FTPClient ftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(this.getProject());
        } else {
            if (fs.getSelectors(this.getProject()).length != 0) {
                this.getProject().log("selectors are not supported in remote filesets", 1);
            }
            ds = new FTPDirectoryScanner(ftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.getProject());
            ds.setFollowSymlinks(fs.isFollowSymlinks());
            ds.scan();
        }
        String[] dsfiles = null;
        dsfiles = this.action == 6 ? ds.getIncludedDirectories() : ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            if (this.action == 3) {
                File pd = this.fileUtils.getParentFile(this.listing);
                if (!pd.exists()) {
                    pd.mkdirs();
                }
                bw = new BufferedWriter(new FileWriter(this.listing));
            }
            if (this.action == 6) {
                int i = dsfiles.length - 1;
                while (i >= 0) {
                    this.rmDir(ftp, dsfiles[i]);
                    --i;
                }
            } else {
                int i = 0;
                while (i < dsfiles.length) {
                    switch (this.action) {
                        case 0: {
                            this.sendFile(ftp, dir, dsfiles[i]);
                            break;
                        }
                        case 1: {
                            this.getFile(ftp, dir, dsfiles[i]);
                            break;
                        }
                        case 2: {
                            this.delFile(ftp, dsfiles[i]);
                            break;
                        }
                        case 3: {
                            this.listFile(ftp, bw, dsfiles[i]);
                            break;
                        }
                        case 5: {
                            this.doSiteCommand(ftp, "chmod " + this.chmod + " " + this.resolveFile(dsfiles[i]));
                            ++this.transferred;
                            break;
                        }
                        default: {
                            throw new BuildException("unknown ftp action " + this.action);
                        }
                    }
                    ++i;
                }
            }
            Object var9_10 = null;
            if (bw == null) return dsfiles.length;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (bw == null) throw throwable;
            bw.close();
            throw throwable;
        }
        bw.close();
        return dsfiles.length;
    }

    protected void transferFiles(FTPClient ftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.transferFiles(ftp, fs);
            }
            ++i;
        }
        this.log(this.transferred + " " + ACTION_TARGET_STRS[this.action] + " " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(this.skipped + " " + ACTION_TARGET_STRS[this.action] + " were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    /*
     * Unable to fully structure code
     */
    protected void createParents(FTPClient ftp, String filename) throws IOException, BuildException {
        block6: {
            dir = new File(filename);
            if (this.dirCache.contains(dir)) {
                return;
            }
            parents = new Vector<File>();
            while ((dirname = dir.getParent()) != null) {
                checkDir = new File((String)var5_5);
                if (this.dirCache.contains(checkDir)) break;
                dir = checkDir;
                parents.addElement(dir);
            }
            i = parents.size() - 1;
            if (i < 0) break block6;
            cwd = ftp.printWorkingDirectory();
            parent = dir.getParent();
            if (parent == null || ftp.changeWorkingDirectory(this.resolveFile(parent))) ** GOTO lbl24
            throw new BuildException("could not change to directory: " + ftp.getReplyString());
lbl-1000:
            // 1 sources

            {
                if (!ftp.changeWorkingDirectory((dir = (File)parents.elementAt(i--)).getName())) {
                    this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                    if (!ftp.makeDirectory(dir.getName())) {
                        this.handleMkDirFailure(ftp);
                    }
                    if (!ftp.changeWorkingDirectory(dir.getName())) {
                        throw new BuildException("could not change to directory: " + ftp.getReplyString());
                    }
                }
                this.dirCache.addElement(dir);
lbl24:
                // 2 sources

                ** while (i >= 0)
            }
lbl25:
            // 1 sources

            ftp.changeWorkingDirectory(cwd);
        }
    }

    private long getTimeDiff(FTPClient ftp) {
        long returnValue = 0L;
        File tempFile = this.findFileName(ftp);
        try {
            this.fileUtils.createNewFile(tempFile);
            long localTimeStamp = tempFile.lastModified();
            BufferedInputStream instream = new BufferedInputStream(new FileInputStream(tempFile));
            ftp.storeFile(tempFile.getName(), (InputStream)instream);
            instream.close();
            boolean success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
            if (success) {
                FTPFile[] ftpFiles = ftp.listFiles(tempFile.getName());
                if (ftpFiles.length == 1) {
                    long remoteTimeStamp = ftpFiles[0].getTimestamp().getTime().getTime();
                    returnValue = localTimeStamp - remoteTimeStamp;
                }
                ftp.deleteFile(ftpFiles[0].getName());
            }
            Delete mydelete = (Delete)this.getProject().createTask("delete");
            mydelete.setFile(tempFile.getCanonicalFile());
            mydelete.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        return returnValue;
    }

    private File findFileName(FTPClient ftp) {
        FTPFile[] theFiles = null;
        int maxIterations = 1000;
        int counter = 1;
        while (counter < 1000) {
            File localFile = this.fileUtils.createTempFile("ant" + Integer.toString(counter), ".tmp", null);
            String fileName = localFile.getName();
            boolean found = false;
            try {
                if (counter == 1) {
                    theFiles = ftp.listFiles();
                }
                int counter2 = 0;
                while (counter2 < theFiles.length) {
                    if (theFiles[counter2].getName().equals(fileName)) {
                        found = true;
                        break;
                    }
                    ++counter2;
                }
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, this.getLocation());
            }
            if (!found) {
                localFile.deleteOnExit();
                return localFile;
            }
            ++counter;
        }
        return null;
    }

    protected boolean isUpToDate(FTPClient ftp, File localFile, String remoteFile) throws IOException, BuildException {
        this.log("checking date for " + remoteFile, 3);
        FTPFile[] files = ftp.listFiles(remoteFile);
        if (files == null || files.length == 0) {
            if (this.action == 0) {
                this.log("Could not date test remote file: " + remoteFile + "assuming out of date.", 3);
                return false;
            }
            throw new BuildException("could not date test remote file: " + ftp.getReplyString());
        }
        long remoteTimestamp = files[0].getTimestamp().getTime().getTime();
        long localTimestamp = localFile.lastModified();
        if (this.action == 0) {
            return remoteTimestamp + this.timeDiffMillis >= localTimestamp;
        }
        return localTimestamp >= remoteTimestamp + this.timeDiffMillis;
    }

    protected void doSiteCommand(FTPClient ftp, String theCMD) throws IOException, BuildException {
        String[] myReply = null;
        this.log("Doing Site Command: " + theCMD, 3);
        boolean rc = ftp.sendSiteCommand(theCMD);
        if (!rc) {
            this.log("Failed to issue Site Command: " + theCMD, 1);
        } else {
            myReply = ftp.getReplyStrings();
            int x = 0;
            while (x < myReply.length) {
                if (myReply[x].indexOf("200") == -1) {
                    this.log(myReply[x], 1);
                }
                ++x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void sendFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            instream = null;
            try {
                file = this.getProject().resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (instream == null) goto lbl-1000
            }
            catch (Throwable var8_14) {
                var9_8 = null;
                if (instream != null) {
                    try {
                        instream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    instream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + file.getAbsolutePath());
                }
                instream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(ftp, filename);
                ftp.storeFile(this.resolveFile(filename), instream);
                success = FTPReply.isPositiveCompletion((int)ftp.getReplyCode());
                if (!success) {
                    s = "could not put file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                if (this.chmod != null) {
                    this.doSiteCommand(ftp, "chmod " + this.chmod + " " + this.resolveFile(filename));
                }
                this.log("File " + file.getAbsolutePath() + " copied to " + this.server, 3);
                ++this.transferred;
            }
        }
        var9_7 = null;
        if (instream != null) {
            try {
                instream.close();
            }
            catch (IOException ex) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void delFile(FTPClient ftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        if (!ftp.deleteFile(this.resolveFile(filename))) {
            String s = "could not delete file: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("File " + filename + " deleted from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rmDir(FTPClient ftp, String dirname) throws IOException, BuildException {
        if (this.verbose) {
            this.log("removing " + dirname);
        }
        if (!ftp.removeDirectory(this.resolveFile(dirname))) {
            String s = "could not remove directory: " + ftp.getReplyString();
            if (!this.skipFailedTransfers) throw new BuildException(s);
            this.log(s, 1);
            ++this.skipped;
            return;
        } else {
            this.log("Directory " + dirname + " removed from " + this.server, 3);
            ++this.transferred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void getFile(FTPClient ftp, String dir, String filename) throws IOException, BuildException {
        block13: {
            outstream = null;
            try {
                file = this.getProject().resolveFile(new File(dir, filename).getPath());
                if (!this.newerOnly || !this.isUpToDate(ftp, file, this.resolveFile(filename))) break block14;
                var9_6 = null;
                ** if (outstream == null) goto lbl-1000
            }
            catch (Throwable var8_15) {
                var9_8 = null;
                if (outstream != null) {
                    try {
                        outstream.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var8_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    outstream.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
lbl-1000:
            // 3 sources

            {
                block14: {
                    return;
                }
                if (this.verbose) {
                    this.log("transferring " + filename + " to " + file.getAbsolutePath());
                }
                if (!(pdir = this.fileUtils.getParentFile(file)).exists()) {
                    pdir.mkdirs();
                }
                outstream = new BufferedOutputStream(new FileOutputStream(file));
                ftp.retrieveFile(this.resolveFile(filename), outstream);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    s = "could not get file: " + ftp.getReplyString();
                    if (this.skipFailedTransfers) {
                        this.log(s, 1);
                        ++this.skipped;
                        break block13;
                    }
                    throw new BuildException(s);
                }
                this.log("File " + file.getAbsolutePath() + " copied from " + this.server, 3);
                ++this.transferred;
                if (!this.preserveLastModified) break block13;
                outstream.close();
                outstream = null;
                remote = ftp.listFiles(this.resolveFile(filename));
                if (remote.length <= 0) break block13;
                this.fileUtils.setFileLastModified(file, remote[0].getTimestamp().getTime().getTime());
            }
        }
        var9_7 = null;
        if (outstream != null) {
            try {
                outstream.close();
            }
            catch (IOException ex) {}
        }
    }

    protected void listFile(FTPClient ftp, BufferedWriter bw, String filename) throws IOException, BuildException {
        FTPFile[] ftpfiles;
        if (this.verbose) {
            this.log("listing " + filename);
        }
        if ((ftpfiles = ftp.listFiles(this.resolveFile(filename))) != null && ftpfiles.length > 0) {
            bw.write(ftpfiles[0].toString());
            bw.newLine();
            ++this.transferred;
        }
    }

    protected void makeRemoteDir(FTPClient ftp, String dir) throws IOException, BuildException {
        String workingDirectory = ftp.printWorkingDirectory();
        if (this.verbose) {
            this.log("Creating directory: " + dir);
        }
        if (dir.indexOf("/") == 0) {
            ftp.changeWorkingDirectory("/");
        }
        String subdir = new String();
        StringTokenizer st = new StringTokenizer(dir, "/");
        while (st.hasMoreTokens()) {
            subdir = st.nextToken();
            this.log("Checking " + subdir, 4);
            if (ftp.changeWorkingDirectory(subdir)) continue;
            if (!ftp.makeDirectory(subdir)) {
                int rc = ftp.getReplyCode();
                if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
                    throw new BuildException("could not create directory: " + ftp.getReplyString());
                }
                if (!this.verbose) continue;
                this.log("Directory already exists");
                continue;
            }
            if (this.verbose) {
                this.log("Directory created OK");
            }
            ftp.changeWorkingDirectory(subdir);
        }
        if (workingDirectory != null) {
            ftp.changeWorkingDirectory(workingDirectory);
        }
    }

    private void handleMkDirFailure(FTPClient ftp) throws BuildException {
        int rc = ftp.getReplyCode();
        if (!this.ignoreNoncriticalErrors || rc != 550 && rc != 553 && rc != 521) {
            throw new BuildException("could not create directory: " + ftp.getReplyString());
        }
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        FTPClient ftp = null;
        try {
            this.log("Opening FTP connection to " + this.server, 3);
            ftp = new FTPClient();
            ftp.connect(this.server, this.port);
            if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                throw new BuildException("FTP connection failed: " + ftp.getReplyString());
            }
            this.log("connected", 3);
            this.log("logging in to FTP server", 3);
            if (!ftp.login(this.userid, this.password)) {
                throw new BuildException("Could not login to FTP server");
            }
            this.log("login succeeded", 3);
            if (this.binary) {
                ftp.setFileType(2);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                }
            } else {
                ftp.setFileType(0);
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not set transfer type: " + ftp.getReplyString());
                }
            }
            if (this.passive) {
                this.log("entering passive mode", 3);
                ftp.enterLocalPassiveMode();
                if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                    throw new BuildException("could not enter into passive mode: " + ftp.getReplyString());
                }
            }
            if (this.umask != null) {
                this.doSiteCommand(ftp, "umask " + this.umask);
            }
            if (this.action == 4) {
                this.makeRemoteDir(ftp, this.remotedir);
            } else {
                if (this.remotedir != null) {
                    this.log("changing the remote directory", 3);
                    ftp.changeWorkingDirectory(this.remotedir);
                    if (!FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                        throw new BuildException("could not change remote directory: " + ftp.getReplyString());
                    }
                }
                if (this.newerOnly && this.timeDiffAuto) {
                    this.timeDiffMillis = this.getTimeDiff(ftp);
                }
                this.log(ACTION_STRS[this.action] + " " + ACTION_TARGET_STRS[this.action]);
                this.transferFiles(ftp);
            }
        }
        catch (IOException ex) {
            throw new BuildException("error during FTP transfer: " + ex);
        }
        finally {
            if (ftp != null && ftp.isConnected()) {
                try {
                    this.log("disconnecting", 3);
                    ftp.logout();
                    ftp.disconnect();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] VALID_ACTIONS = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod", "rmdir"};

        public String[] getValues() {
            return VALID_ACTIONS;
        }

        public int getAction() {
            String actionL = this.getValue().toLowerCase(Locale.US);
            if (actionL.equals("send") || actionL.equals("put")) {
                return 0;
            }
            if (actionL.equals("recv") || actionL.equals("get")) {
                return 1;
            }
            if (actionL.equals("del") || actionL.equals("delete")) {
                return 2;
            }
            if (actionL.equals("list")) {
                return 3;
            }
            if (actionL.equals("chmod")) {
                return 5;
            }
            if (actionL.equals("mkdir")) {
                return 4;
            }
            if (actionL.equals("rmdir")) {
                return 6;
            }
            return 0;
        }
    }

    protected class FTPDirectoryScanner
    extends DirectoryScanner {
        protected FTPClient ftp = null;
        private String rootPath = null;
        private boolean remoteSystemCaseSensitive = false;
        private boolean remoteSensitivityChecked = false;
        private Map fileListMap = new HashMap();
        private Set scannedDirs = new HashSet();

        public FTPDirectoryScanner(FTPClient ftp) {
            this.ftp = ftp;
            this.setFollowSymlinks(false);
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            try {
                String cwd = this.ftp.printWorkingDirectory();
                this.checkIncludePatterns();
                this.clearCaches();
                this.ftp.changeWorkingDirectory(cwd);
            }
            catch (IOException e) {
                throw new BuildException("Unable to scan FTP server: ", (Throwable)e);
            }
        }

        private void checkIncludePatterns() {
            Hashtable<String, String> newroots = new Hashtable<String, String>();
            int icounter = 0;
            while (icounter < this.includes.length) {
                String newpattern = SelectorUtils.rtrimWildcardTokens((String)this.includes[icounter]);
                newroots.put(newpattern, this.includes[icounter]);
                ++icounter;
            }
            if (FTP.this.remotedir == null) {
                try {
                    FTP.this.remotedir = this.ftp.printWorkingDirectory();
                }
                catch (IOException e) {
                    throw new BuildException("could not read current ftp directory", FTP.this.getLocation());
                }
            }
            AntFTPRootFile baseFTPFile = new AntFTPRootFile(this.ftp, FTP.this.remotedir);
            this.rootPath = ((AntFTPFile)baseFTPFile).getAbsolutePath();
            if (newroots.containsKey("")) {
                this.scandir(this.rootPath, "", true);
            } else {
                Enumeration enum2 = newroots.keys();
                while (enum2.hasMoreElements()) {
                    String currentelement = (String)enum2.nextElement();
                    String originalpattern = (String)newroots.get(currentelement);
                    AntFTPFile myfile = new AntFTPFile(baseFTPFile, currentelement);
                    boolean isOK = true;
                    boolean traversesSymlinks = false;
                    String path = null;
                    if (myfile.exists()) {
                        if (this.remoteSensitivityChecked && this.remoteSystemCaseSensitive && this.isFollowSymlinks()) {
                            path = myfile.getFastRelativePath();
                        } else {
                            try {
                                path = myfile.getRelativePath();
                                traversesSymlinks = myfile.isTraverseSymlinks();
                            }
                            catch (IOException be) {
                                throw new BuildException((Throwable)be, FTP.this.getLocation());
                            }
                            catch (BuildException be) {
                                isOK = false;
                            }
                        }
                    } else {
                        isOK = false;
                    }
                    if (!isOK) continue;
                    currentelement = path.replace(FTP.this.remoteFileSep.charAt(0), File.separatorChar);
                    if (!this.isFollowSymlinks() && traversesSymlinks) continue;
                    if (myfile.isDirectory()) {
                        if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                            this.accountForIncludedDir(currentelement, myfile, true);
                            continue;
                        }
                        if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                            currentelement = currentelement + File.separatorChar;
                        }
                        this.scandir(myfile.getAbsolutePath(), currentelement, true);
                        continue;
                    }
                    if (this.isCaseSensitive && originalpattern.equals(currentelement)) {
                        this.accountForIncludedFile(currentelement);
                        continue;
                    }
                    if (this.isCaseSensitive || !originalpattern.equalsIgnoreCase(currentelement)) continue;
                    this.accountForIncludedFile(currentelement);
                }
            }
        }

        protected void scandir(String dir, String vpath, boolean fast) {
            if (fast && this.hasBeenScanned(vpath)) {
                return;
            }
            try {
                if (!this.ftp.changeWorkingDirectory(dir)) {
                    return;
                }
                String completePath = null;
                completePath = !vpath.equals("") ? this.rootPath + FTP.this.remoteFileSep + vpath.replace(File.separatorChar, FTP.this.remoteFileSep.charAt(0)) : this.rootPath;
                FTPFile[] newfiles = this.listFiles(completePath, false);
                if (newfiles == null) {
                    this.ftp.changeToParentDirectory();
                    return;
                }
                int i = 0;
                while (i < newfiles.length) {
                    FTPFile file = newfiles[i];
                    if (!file.getName().equals(".") && !file.getName().equals("..")) {
                        String name;
                        if (FTP.this.isFunctioningAsDirectory(this.ftp, dir, file)) {
                            name = vpath + file.getName();
                            boolean slowScanAllowed = true;
                            if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                                this.dirsExcluded.addElement(name);
                                slowScanAllowed = false;
                            } else if (this.isIncluded(name)) {
                                this.accountForIncludedDir(name, new AntFTPFile(this.ftp, file, completePath), fast);
                            } else {
                                this.dirsNotIncluded.addElement(name);
                                if (fast && this.couldHoldIncluded(name)) {
                                    this.scandir(file.getName(), name + File.separator, fast);
                                }
                            }
                            if (!fast && slowScanAllowed) {
                                this.scandir(file.getName(), name + File.separator, fast);
                            }
                        } else {
                            name = vpath + file.getName();
                            if (!this.isFollowSymlinks() && file.isSymbolicLink()) {
                                this.filesExcluded.addElement(name);
                            } else if (FTP.this.isFunctioningAsFile(this.ftp, dir, file)) {
                                this.accountForIncludedFile(name);
                            }
                        }
                    }
                    ++i;
                }
                this.ftp.changeToParentDirectory();
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with FTP server: ", (Throwable)e);
            }
        }

        private void accountForIncludedFile(String name) {
            if (!this.filesIncluded.contains(name) && !this.filesExcluded.contains(name)) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        this.filesIncluded.addElement(name);
                    } else {
                        this.filesExcluded.addElement(name);
                    }
                } else {
                    this.filesNotIncluded.addElement(name);
                }
            }
        }

        private void accountForIncludedDir(String name, AntFTPFile file, boolean fast) {
            if (!this.dirsIncluded.contains(name) && !this.dirsExcluded.contains(name)) {
                if (!this.isExcluded(name)) {
                    if (fast) {
                        if (file.isSymbolicLink()) {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getLink(), name + File.separator, fast);
                        } else {
                            try {
                                file.getClient().changeWorkingDirectory(file.curpwd);
                            }
                            catch (IOException ioe) {
                                throw new BuildException("could not change directory to curpwd");
                            }
                            this.scandir(file.getName(), name + File.separator, fast);
                        }
                    }
                    this.dirsIncluded.addElement(name);
                } else {
                    this.dirsExcluded.addElement(name);
                    if (fast && this.couldHoldIncluded(name)) {
                        try {
                            file.getClient().changeWorkingDirectory(file.curpwd);
                        }
                        catch (IOException ioe) {
                            throw new BuildException("could not change directory to curpwd");
                        }
                        this.scandir(file.getName(), name + File.separator, fast);
                    }
                }
            }
        }

        private boolean hasBeenScanned(String vpath) {
            return !this.scannedDirs.add(vpath);
        }

        private void clearCaches() {
            this.fileListMap.clear();
            this.scannedDirs.clear();
        }

        public FTPFile[] listFiles(String directory, boolean changedir) {
            String currentPath = directory;
            if (changedir) {
                try {
                    boolean result = this.ftp.changeWorkingDirectory(directory);
                    if (!result) {
                        return null;
                    }
                    currentPath = this.ftp.printWorkingDirectory();
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }
            if (this.fileListMap.containsKey(currentPath)) {
                FTP.this.getProject().log("filelist map used in listing files", 4);
                return (FTPFile[])this.fileListMap.get(currentPath);
            }
            FTPFile[] result = null;
            try {
                result = this.ftp.listFiles();
            }
            catch (IOException ioe) {
                throw new BuildException((Throwable)ioe, FTP.this.getLocation());
            }
            this.fileListMap.put(currentPath, result);
            if (!this.remoteSensitivityChecked) {
                this.checkRemoteSensitivity(result, directory);
            }
            return result;
        }

        public FTPFile[] listFiles(String directory) {
            return this.listFiles(directory, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkRemoteSensitivity(FTPFile[] array, String directory) {
            if (array == null) {
                return;
            }
            boolean candidateFound = false;
            String target = null;
            int icounter = 0;
            while (icounter < array.length) {
                if (array[icounter].isDirectory() && !array[icounter].getName().equals(".") && !array[icounter].getName().equals("..")) {
                    candidateFound = true;
                    target = this.fiddleName(array[icounter].getName());
                    FTP.this.getProject().log("will try to cd to " + target + " where a directory called " + array[icounter].getName() + " exists", 4);
                    int pcounter = 0;
                    while (pcounter < array.length) {
                        if (array[pcounter].getName().equals(target) && pcounter != icounter) {
                            candidateFound = false;
                        }
                        ++pcounter;
                    }
                    if (candidateFound) break;
                }
                ++icounter;
            }
            if (candidateFound) {
                try {
                    FTP.this.getProject().log("testing case sensitivity, attempting to cd to " + target, 4);
                    this.remoteSystemCaseSensitive = !this.ftp.changeWorkingDirectory(target);
                }
                catch (IOException ioe) {
                    this.remoteSystemCaseSensitive = true;
                }
                finally {
                    try {
                        this.ftp.changeWorkingDirectory(directory);
                    }
                    catch (IOException ioe) {
                        throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                    }
                }
                FTP.this.getProject().log("remote system is case sensitive : " + this.remoteSystemCaseSensitive, 3);
                this.remoteSensitivityChecked = true;
            }
        }

        private String fiddleName(String origin) {
            StringBuffer result = new StringBuffer();
            int icounter = 0;
            while (icounter < origin.length()) {
                if (Character.isLowerCase(origin.charAt(icounter))) {
                    result.append(Character.toUpperCase(origin.charAt(icounter)));
                } else if (Character.isUpperCase(origin.charAt(icounter))) {
                    result.append(Character.toLowerCase(origin.charAt(icounter)));
                } else {
                    result.append(origin.charAt(icounter));
                }
                ++icounter;
            }
            return result.toString();
        }

        protected class AntFTPRootFile
        extends AntFTPFile {
            private String remotedir;

            public AntFTPRootFile(FTPClient aclient, String remotedir) {
                super(aclient, null, remotedir);
                this.remotedir = remotedir;
                try {
                    this.getClient().changeWorkingDirectory(this.remotedir);
                    this.setCurpwd(this.getClient().printWorkingDirectory());
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe, FTP.this.getLocation());
                }
            }

            public String getAbsolutePath() {
                return this.getCurpwd();
            }

            public String getRelativePath() throws BuildException, IOException {
                return "";
            }
        }

        protected class AntFTPFile {
            private FTPClient client;
            private String curpwd;
            private FTPFile ftpFile;
            private AntFTPFile parent = null;
            private boolean relativePathCalculated = false;
            private boolean traversesSymlinks = false;
            private String relativePath = "";

            public AntFTPFile(FTPClient client, FTPFile ftpFile, String curpwd) {
                this.client = client;
                this.ftpFile = ftpFile;
                this.curpwd = curpwd;
            }

            public AntFTPFile(AntFTPFile parent, String path) {
                this.parent = parent;
                this.client = parent.client;
                Vector pathElements = SelectorUtils.tokenizePath((String)path);
                try {
                    boolean result = this.client.changeWorkingDirectory(parent.getAbsolutePath());
                    if (!result) {
                        return;
                    }
                    this.curpwd = parent.getAbsolutePath();
                }
                catch (IOException ioe) {
                    throw new BuildException("could not change working dir to " + parent.curpwd);
                }
                int fcount = 0;
                while (fcount < pathElements.size() - 1) {
                    String currentPathElement = (String)pathElements.elementAt(fcount);
                    try {
                        boolean result = this.client.changeWorkingDirectory(currentPathElement);
                        if (!result && !FTPDirectoryScanner.this.isCaseSensitive() && (FTPDirectoryScanner.this.remoteSystemCaseSensitive || !FTPDirectoryScanner.this.remoteSensitivityChecked) ? (currentPathElement = this.findPathElementCaseUnsensitive(this.curpwd, currentPathElement)) == null : !result) {
                            return;
                        }
                        this.curpwd = this.curpwd + FTP.this.remoteFileSep + currentPathElement;
                    }
                    catch (IOException ioe) {
                        throw new BuildException("could not change working dir to " + (String)pathElements.elementAt(fcount) + " from " + this.curpwd);
                    }
                    ++fcount;
                }
                String lastpathelement = (String)pathElements.elementAt(pathElements.size() - 1);
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(this.curpwd);
                this.ftpFile = this.getFile(theFiles, lastpathelement);
            }

            private String findPathElementCaseUnsensitive(String parentPath, String soughtPathElement) {
                FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(parentPath, false);
                if (theFiles == null) {
                    return null;
                }
                int icounter = 0;
                while (icounter < theFiles.length) {
                    if (theFiles[icounter].getName().equalsIgnoreCase(soughtPathElement)) {
                        return theFiles[icounter].getName();
                    }
                    ++icounter;
                }
                return null;
            }

            public boolean exists() {
                return this.ftpFile != null;
            }

            public String getLink() {
                return this.ftpFile.getLink();
            }

            public String getName() {
                return this.ftpFile.getName();
            }

            public String getAbsolutePath() {
                return this.curpwd + FTP.this.remoteFileSep + this.ftpFile.getName();
            }

            public String getFastRelativePath() {
                String absPath = this.getAbsolutePath();
                if (absPath.indexOf(FTPDirectoryScanner.this.rootPath + FTP.this.remoteFileSep) == 0) {
                    return absPath.substring(FTPDirectoryScanner.this.rootPath.length() + FTP.this.remoteFileSep.length());
                }
                return null;
            }

            public String getRelativePath() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    if (this.parent != null) {
                        this.traversesSymlinks = this.parent.isTraverseSymlinks();
                        this.relativePath = this.getRelativePath(this.parent.getAbsolutePath(), this.parent.getRelativePath());
                    } else {
                        this.relativePath = this.getRelativePath(FTPDirectoryScanner.this.rootPath, "");
                        this.relativePathCalculated = true;
                    }
                }
                return this.relativePath;
            }

            private String getRelativePath(String currentPath, String currentRelativePath) {
                Vector pathElements = SelectorUtils.tokenizePath((String)this.getAbsolutePath(), (String)FTP.this.remoteFileSep);
                Vector pathElements2 = SelectorUtils.tokenizePath((String)currentPath, (String)FTP.this.remoteFileSep);
                String relPath = currentRelativePath;
                int pcount = pathElements2.size();
                while (pcount < pathElements.size()) {
                    String currentElement = (String)pathElements.elementAt(pcount);
                    FTPFile[] theFiles = FTPDirectoryScanner.this.listFiles(currentPath);
                    FTPFile theFile = null;
                    if (theFiles != null) {
                        theFile = this.getFile(theFiles, currentElement);
                    }
                    if (theFile == null) {
                        throw new BuildException("could not find " + currentElement + " from " + currentPath);
                    }
                    boolean bl = this.traversesSymlinks = this.traversesSymlinks || theFile.isSymbolicLink();
                    if (!relPath.equals("")) {
                        relPath = relPath + FTP.this.remoteFileSep;
                    }
                    relPath = relPath + theFile.getName();
                    currentPath = currentPath + FTP.this.remoteFileSep + theFile.getName();
                    ++pcount;
                }
                return relPath;
            }

            public FTPFile getFile(FTPFile[] theFiles, String lastpathelement) {
                if (theFiles == null) {
                    return null;
                }
                int fcount = 0;
                while (fcount < theFiles.length) {
                    if (theFiles[fcount].getName().equals(lastpathelement)) {
                        return theFiles[fcount];
                    }
                    if (!FTPDirectoryScanner.this.isCaseSensitive() && theFiles[fcount].getName().equalsIgnoreCase(lastpathelement)) {
                        return theFiles[fcount];
                    }
                    ++fcount;
                }
                return null;
            }

            public boolean isDirectory() {
                return this.ftpFile.isDirectory();
            }

            public boolean isSymbolicLink() {
                return this.ftpFile.isSymbolicLink();
            }

            protected FTPClient getClient() {
                return this.client;
            }

            protected void setCurpwd(String curpwd) {
                this.curpwd = curpwd;
            }

            public String getCurpwd() {
                return this.curpwd;
            }

            public boolean isTraverseSymlinks() throws IOException, BuildException {
                if (!this.relativePathCalculated) {
                    String string = this.getRelativePath();
                }
                return this.traversesSymlinks;
            }
        }
    }
}

