/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphicsConfiguration;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;

class GdkScreenGraphicsDevice
extends GraphicsDevice {
    private final int native_state;
    private Window fullscreenWindow;
    private boolean oldWindowDecorationState;
    private Rectangle oldWindowBounds;
    private Rectangle bounds;
    private GdkGraphicsConfiguration[] configurations;
    GdkGraphicsEnvironment env;
    String idString;
    X11DisplayMode[] displayModes;
    DisplayMode fixedDisplayMode;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    static native void initStaticState();

    GdkScreenGraphicsDevice(GdkGraphicsEnvironment gdkGraphicsEnvironment) {
        this.finit$();
        this.env = gdkGraphicsEnvironment;
        this.configurations = new GdkGraphicsConfiguration[1];
        this.configurations[0] = new GdkGraphicsConfiguration(this);
    }

    void init() {
        this.fixedDisplayMode = this.nativeGetFixedDisplayMode(this.env);
    }

    native DisplayMode nativeGetFixedDisplayMode(GdkGraphicsEnvironment var1);

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        if (this.idString == null) {
            this.idString = this.nativeGetIDString();
        }
        return this.idString;
    }

    private native String nativeGetIDString();

    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configurations.clone();
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configurations[0];
    }

    public DisplayMode getDisplayMode() {
        if (this.fixedDisplayMode != null) {
            return this.fixedDisplayMode;
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            block4: {
                try {
                    if (this.displayModes != null) break block4;
                    this.displayModes = this.nativeGetDisplayModes(this.env);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
        int n = this.nativeGetDisplayModeIndex(this.env);
        int n2 = this.nativeGetDisplayModeRate(this.env);
        DisplayMode displayMode = new DisplayMode(this.displayModes[n].width, this.displayModes[n].height, -1, n2);
        return displayMode;
    }

    native int nativeGetDisplayModeIndex(GdkGraphicsEnvironment var1);

    native int nativeGetDisplayModeRate(GdkGraphicsEnvironment var1);

    public DisplayMode[] getDisplayModes() {
        ArrayList arrayList;
        if (this.fixedDisplayMode != null) {
            return new DisplayMode[]{this.fixedDisplayMode};
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            block6: {
                try {
                    if (this.displayModes != null) break block6;
                    this.displayModes = this.nativeGetDisplayModes(this.env);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            arrayList = null;
        }
        arrayList = new ArrayList();
        for (int i = 0; i < this.displayModes.length; ++i) {
            for (int j = 0; j < this.displayModes[i].rates.length; ++j) {
                arrayList.add(new DisplayMode(this.displayModes[i].width, this.displayModes[i].height, -1, this.displayModes[i].rates[j]));
            }
        }
        DisplayMode[] displayModeArray = (DisplayMode[])arrayList.toArray(new DisplayMode[arrayList.size()]);
        return displayModeArray;
    }

    native X11DisplayMode[] nativeGetDisplayModes(GdkGraphicsEnvironment var1);

    public boolean isFullScreenSupported() {
        return true;
    }

    public boolean isDisplayChangeSupported() {
        return this.fixedDisplayMode == null;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        if (this.fixedDisplayMode != null) {
            throw new UnsupportedOperationException("Cannnot change display mode.");
        }
        if (displayMode == null) {
            throw new IllegalArgumentException("DisplayMode must not be null.");
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            block10: {
                try {
                    if (this.displayModes != null) break block10;
                    this.displayModes = this.nativeGetDisplayModes(this.env);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
            Object var3_3 = null;
        }
        for (int i = 0; i < this.displayModes.length; ++i) {
            if (this.displayModes[i].width != displayMode.getWidth() || this.displayModes[i].height != displayMode.getHeight()) continue;
            GdkScreenGraphicsDevice gdkScreenGraphicsDevice2 = this;
            synchronized (gdkScreenGraphicsDevice2) {
                try {
                    this.nativeSetDisplayMode(this.env, i, (short)displayMode.getRefreshRate());
                    this.bounds = null;
                }
                finally {
                    Object var5_8 = null;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Mode not supported by this device.");
    }

    native void nativeSetDisplayMode(GdkGraphicsEnvironment var1, int var2, short var3);

    public void setFullScreenWindow(Window window) {
        Object object;
        if (this.fullscreenWindow != null && window != this.fullscreenWindow) {
            if (this.fullscreenWindow instanceof Frame && this.oldWindowDecorationState != ((Frame)(object = (Frame)this.fullscreenWindow)).isUndecorated()) {
                ((Window)object).dispose();
                ((Frame)object).setUndecorated(this.oldWindowDecorationState);
            }
            this.fullscreenWindow.setBounds(this.oldWindowBounds);
            if (!this.fullscreenWindow.isVisible()) {
                this.fullscreenWindow.setVisible(true);
            }
        }
        if (window != null) {
            if (window instanceof Frame) {
                object = (Frame)window;
                this.oldWindowDecorationState = ((Frame)object).isUndecorated();
                if (!this.oldWindowDecorationState) {
                    ((Window)object).dispose();
                    ((Frame)object).setUndecorated(true);
                }
            }
            this.oldWindowBounds = window.getBounds();
            object = this.getDisplayMode();
            window.setBounds(0, 0, ((DisplayMode)object).getWidth(), ((DisplayMode)object).getHeight());
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            window.requestFocus();
            window.toFront();
        }
        this.fullscreenWindow = window;
    }

    public Window getFullScreenWindow() {
        return this.fullscreenWindow;
    }

    Rectangle getBounds() {
        Rectangle rectangle;
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            block3: {
                try {
                    if (this.bounds != null) break block3;
                    this.bounds = this.nativeGetBounds();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            rectangle = null;
        }
        rectangle = this.bounds;
        return rectangle;
    }

    native Rectangle nativeGetBounds();

    static {
        System.loadLibrary("gtkpeer");
        GdkScreenGraphicsDevice.initStaticState();
    }

    static class X11DisplayMode {
        short[] rates;
        int width;
        int height;

        X11DisplayMode(int n, int n2, short[] sArray) {
            this.width = n;
            this.height = n2;
            this.rates = sArray;
        }
    }
}

