/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class X500DistinguishedName
implements Principal {
    public static final OID CN = new OID("2.5.4.3");
    public static final OID C = new OID("2.5.4.6");
    public static final OID L = new OID("2.5.4.7");
    public static final OID ST = new OID("2.5.4.8");
    public static final OID STREET = new OID("2.5.4.9");
    public static final OID O = new OID("2.5.4.10");
    public static final OID OU = new OID("2.5.4.11");
    public static final OID T = new OID("2.5.4.12");
    public static final OID DNQ = new OID("2.5.4.46");
    public static final OID NAME = new OID("2.5.4.41");
    public static final OID GIVENNAME = new OID("2.5.4.42");
    public static final OID INITIALS = new OID("2.5.4.43");
    public static final OID GENERATION = new OID("2.5.4.44");
    public static final OID EMAIL = new OID("1.2.840.113549.1.9.1");
    public static final OID DC = new OID("0.9.2342.19200300.100.1.25");
    public static final OID UID = new OID("0.9.2342.19200300.100.1.1");
    private List components = new LinkedList();
    private Map currentRdn = new LinkedHashMap();
    private boolean fixed;
    private String stringRep;
    private byte[] encoded;
    private int sep;

    public X500DistinguishedName() {
        this.components.add(this.currentRdn);
    }

    public X500DistinguishedName(String string) {
        this();
        try {
            this.parseString(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public X500DistinguishedName(byte[] byArray) throws IOException {
        this();
        this.parseDer(new DERReader(byArray));
    }

    public X500DistinguishedName(InputStream inputStream) throws IOException {
        this();
        this.parseDer(new DERReader(inputStream));
    }

    public String getName() {
        return this.toString();
    }

    public void newRelativeDistinguishedName() {
        if (this.fixed || this.currentRdn.isEmpty()) {
            return;
        }
        this.currentRdn = new LinkedHashMap();
        this.components.add(this.currentRdn);
    }

    public int size() {
        return this.components.size();
    }

    public int countComponents() {
        int n = 0;
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            n += ((Map)iterator.next()).size();
        }
        return n;
    }

    public boolean containsComponent(OID oID, String string) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String string2 = (String)map.get(oID);
            if (string2 == null || !X500DistinguishedName.compressWS(string).equalsIgnoreCase(X500DistinguishedName.compressWS(string2))) continue;
            return true;
        }
        return false;
    }

    public String getComponent(OID oID) {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            if (!map.containsKey(oID)) continue;
            return (String)map.get(oID);
        }
        return null;
    }

    public String getComponent(OID oID, int n) {
        if (n >= this.size()) {
            return null;
        }
        return (String)((Map)this.components.get(n)).get(oID);
    }

    public void putComponent(OID oID, String string) {
        this.currentRdn.put(oID, string);
    }

    public void putComponent(String string, String string2) {
        if ((string = string.trim().toLowerCase()).equals("cn")) {
            this.putComponent(CN, string2);
        } else if (string.equals("c")) {
            this.putComponent(C, string2);
        } else if (string.equals("l")) {
            this.putComponent(L, string2);
        } else if (string.equals("street")) {
            this.putComponent(STREET, string2);
        } else if (string.equals("st")) {
            this.putComponent(ST, string2);
        } else if (string.equals("t")) {
            this.putComponent(T, string2);
        } else if (string.equals("dnq")) {
            this.putComponent(DNQ, string2);
        } else if (string.equals("name")) {
            this.putComponent(NAME, string2);
        } else if (string.equals("givenname")) {
            this.putComponent(GIVENNAME, string2);
        } else if (string.equals("initials")) {
            this.putComponent(INITIALS, string2);
        } else if (string.equals("generation")) {
            this.putComponent(GENERATION, string2);
        } else if (string.equals("email")) {
            this.putComponent(EMAIL, string2);
        } else if (string.equals("dc")) {
            this.putComponent(DC, string2);
        } else if (string.equals("uid")) {
            this.putComponent(UID, string2);
        } else if (string.equals("o")) {
            this.putComponent(O, string2);
        } else if (string.equals("ou")) {
            this.putComponent(OU, string2);
        } else {
            this.putComponent(new OID(string), string2);
        }
    }

    public void setUnmodifiable() {
        if (this.fixed) {
            return;
        }
        this.fixed = true;
        ArrayList arrayList = new ArrayList(this.components.size());
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            map = Collections.unmodifiableMap(map);
            arrayList.add(map);
        }
        this.components = Collections.unmodifiableList(arrayList);
        this.currentRdn = Collections.EMPTY_MAP;
    }

    public int hashCode() {
        int n = 0;
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                n += entry.getKey().hashCode();
                n += entry.getValue().hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof X500DistinguishedName)) {
            return false;
        }
        if (this.size() != ((X500DistinguishedName)object).size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Map map = (Map)this.components.get(i);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                OID oID = (OID)entry.getKey();
                String string = (String)entry.getValue();
                String string2 = ((X500DistinguishedName)object).getComponent(oID, i);
                if (X500DistinguishedName.compressWS(string).equalsIgnoreCase(X500DistinguishedName.compressWS(string2))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (this.fixed && this.stringRep != null) {
            return this.stringRep;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                OID oID = (OID)entry.getKey();
                String string = (String)entry.getValue();
                if (oID.equals(CN)) {
                    stringBuffer.append("CN");
                } else if (oID.equals(C)) {
                    stringBuffer.append("C");
                } else if (oID.equals(L)) {
                    stringBuffer.append("L");
                } else if (oID.equals(ST)) {
                    stringBuffer.append("ST");
                } else if (oID.equals(STREET)) {
                    stringBuffer.append("STREET");
                } else if (oID.equals(O)) {
                    stringBuffer.append("O");
                } else if (oID.equals(OU)) {
                    stringBuffer.append("OU");
                } else if (oID.equals(T)) {
                    stringBuffer.append("T");
                } else if (oID.equals(DNQ)) {
                    stringBuffer.append("DNQ");
                } else if (oID.equals(NAME)) {
                    stringBuffer.append("NAME");
                } else {
                    stringBuffer.append(oID.toString());
                }
                stringBuffer.append('=');
                stringBuffer.append(string);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append("+");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        this.stringRep = stringBuffer.toString();
        return this.stringRep;
    }

    public byte[] getDer() {
        if (this.fixed && this.encoded != null) {
            return (byte[])this.encoded.clone();
        }
        ArrayList arrayList = new ArrayList(this.components.size());
        Object object = this.components.iterator();
        while (object.hasNext()) {
            Map map = (Map)object.next();
            if (map.isEmpty()) continue;
            HashSet hashSet = new HashSet();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ArrayList arrayList2 = new ArrayList(2);
                arrayList2.add(new DERValue(6, entry.getKey()));
                arrayList2.add(new DERValue(12, entry.getValue()));
                hashSet.add(new DERValue(48, arrayList2));
            }
            arrayList.add(new DERValue(49, hashSet));
        }
        object = new DERValue(48, arrayList);
        this.encoded = ((DERValue)object).getEncoded();
        return (byte[])this.encoded.clone();
    }

    private void parseString(String string) throws IOException {
        String string2;
        StringReader stringReader = new StringReader(string);
        while ((string2 = this.readAttributeType(stringReader)) != null) {
            String string3 = this.readAttributeValue(stringReader);
            this.putComponent(string2, string3);
            if (this.sep != 44) continue;
            this.newRelativeDistinguishedName();
        }
        this.setUnmodifiable();
    }

    private String readAttributeType(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != 61) {
            if (n == -1) {
                if (stringBuffer.length() > 0) {
                    throw new EOFException();
                }
                return null;
            }
            if (n > 127) {
                throw new IOException("Invalid char: " + (char)n);
            }
            if (Character.isLetterOrDigit((char)n) || n == 45 || n == 46) {
                stringBuffer.append((char)n);
                continue;
            }
            throw new IOException("Invalid char: " + (char)n);
        }
        return stringBuffer.toString();
    }

    private String readAttributeValue(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = reader.read();
        if (n == 35) {
            while (97 <= (n = reader.read()) && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                stringBuffer.append((char)n);
            }
            if (n == 43 || n == 44) {
                this.sep = n;
                String string = stringBuffer.toString();
                return new String(Util.toByteArray(string));
            }
            throw new IOException("illegal character: " + (char)n);
        }
        if (n == 34) {
            while ((n = reader.read()) != 34) {
                if (n == 92) {
                    n = reader.read();
                    if (n == -1) {
                        throw new EOFException();
                    }
                    if (97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                        int n2 = Character.digit((char)n, 16) << 4;
                        n = reader.read();
                        if (!(97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n))) {
                            throw new IOException("illegal hex char");
                        }
                        stringBuffer.append((char)(n2 |= Character.digit((char)n, 16)));
                        continue;
                    }
                    stringBuffer.append((char)n);
                    continue;
                }
                stringBuffer.append((char)n);
            }
            this.sep = reader.read();
            if (this.sep != 43 || this.sep != 44) {
                throw new IOException("illegal character: " + (char)n);
            }
            return stringBuffer.toString();
        }
        block8: while (true) {
            switch (n) {
                case 43: 
                case 44: {
                    this.sep = n;
                    return stringBuffer.toString();
                }
                case 92: {
                    n = reader.read();
                    if (n == -1) {
                        throw new EOFException();
                    }
                    if (97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n)) {
                        int n3 = Character.digit((char)n, 16) << 4;
                        n = reader.read();
                        if (!(97 <= n && n <= 102 || 65 <= n && n <= 70 || Character.isDigit((char)n))) {
                            throw new IOException("illegal hex char");
                        }
                        stringBuffer.append((char)(n3 |= Character.digit((char)n, 16)));
                        continue block8;
                    }
                    stringBuffer.append((char)n);
                    continue block8;
                }
                case 35: 
                case 59: 
                case 60: 
                case 61: 
                case 62: {
                    throw new IOException("illegal character: " + (char)n);
                }
                case -1: {
                    throw new EOFException();
                }
            }
            stringBuffer.append((char)n);
            n = reader.read();
            if (n == -1) break;
        }
        return stringBuffer.toString();
    }

    private void parseDer(DERReader dERReader) throws IOException {
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed Name");
        }
        this.encoded = dERValue.getEncoded();
        int n = 0;
        while (n < dERValue.getLength()) {
            DERValue dERValue2;
            DERValue dERValue3 = dERReader.read();
            if (!dERValue3.isConstructed()) {
                throw new IOException("badly formed RDNSequence");
            }
            for (int i = 0; i < dERValue3.getLength(); i += dERValue2.getEncodedLength()) {
                dERValue2 = dERReader.read();
                if (!dERValue2.isConstructed()) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                DERValue dERValue4 = dERReader.read();
                if (dERValue4.getTag() != 6) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                OID oID = (OID)dERValue4.getValue();
                dERValue4 = dERReader.read();
                if (!(dERValue4.getValue() instanceof String)) {
                    throw new IOException("badly formed AttributeTypeAndValue");
                }
                String string = (String)dERValue4.getValue();
                this.putComponent(oID, string);
            }
            if ((n += dERValue3.getEncodedLength()) >= dERValue.getLength()) continue;
            this.newRelativeDistinguishedName();
        }
        this.setUnmodifiable();
    }

    private static String compressWS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                if (!Character.isWhitespace(c)) {
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c2);
            }
            c = c2;
        }
        return stringBuffer.toString().trim();
    }
}

