/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class QNameType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    QNameType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "QName"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        Object object;
        super.checkValid(string, validationContext);
        int n = -1;
        try {
            object = UnicodeReader.toCodePointArray(string);
            if (((int[])object).length == 0) {
                throw new DatatypeException("invalid NCName value");
            }
            if (object[0] == 58 || !XMLParser.isNameStartCharacter(object[0], false)) {
                throw new DatatypeException(0, "invalid NCName value");
            }
            for (int i = 1; i < ((int[])object).length; ++i) {
                if (object[i] == 58) {
                    if (n != -1 || i + 1 == ((int[])object).length) {
                        throw new DatatypeException(i, "invalid NCName value");
                    }
                    n = i;
                    continue;
                }
                if (XMLParser.isNameCharacter(object[i], false)) continue;
                throw new DatatypeException(i, "invalid NCName value");
            }
        }
        catch (IOException iOException) {
            DatatypeException datatypeException = new DatatypeException("invalid NCName value");
            datatypeException.initCause(iOException);
            throw datatypeException;
        }
        if (n != -1 && validationContext.resolveNamespacePrefix((String)(object = (Object)string.substring(0, n))) == null) {
            throw new DatatypeException("invalid namespace prefix");
        }
    }

    public boolean isContextDependent() {
        return true;
    }
}

