/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import gnu.classpath.NotImplementedException;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Map;

public final class TextLayout
implements Cloneable {
    private GlyphVector[] runs;
    private Font font;
    private FontRenderContext frc;
    private String string;
    private Rectangle2D boundsCache;
    private LineMetrics lm;
    private int[][] runIndices;
    private int[][] charIndices;
    private boolean leftToRight;
    private boolean hasWhitespace;
    public static final CaretPolicy DEFAULT_CARET_POLICY = new CaretPolicy();

    private /* synthetic */ void finit$() {
        this.hasWhitespace = false;
    }

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        this.finit$();
        this.font = font;
        this.frc = fontRenderContext;
        this.string = string;
        this.lm = font.getLineMetrics(string, fontRenderContext);
        this.getStringProperties();
        if (Bidi.requiresBidi(string.toCharArray(), 0, string.length())) {
            int n;
            Bidi bidi = new Bidi(string, this.leftToRight ? 0 : 1);
            int n2 = bidi.getRunCount();
            byte[] byArray = new byte[n2];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = (byte)bidi.getRunLevel(n);
            }
            this.runs = new GlyphVector[n2];
            this.runIndices = new int[n2][2];
            for (n = 0; n < this.runs.length; ++n) {
                this.runIndices[n][0] = bidi.getRunStart(n);
                this.runIndices[n][1] = bidi.getRunLimit(n);
                if (this.runIndices[n][0] == this.runIndices[n][1]) continue;
                this.runs[n] = font.layoutGlyphVector(fontRenderContext, string.toCharArray(), this.runIndices[n][0], this.runIndices[n][1], (byArray[n] & 1) == 0 ? 0 : 1);
            }
            Bidi.reorderVisually(byArray, 0, this.runs, 0, this.runs.length);
        } else {
            this.runs = new GlyphVector[1];
            this.runIndices = new int[1][2];
            this.runIndices[0][0] = 0;
            this.runIndices[0][1] = string.length();
            this.runs[0] = font.layoutGlyphVector(fontRenderContext, string.toCharArray(), 0, string.length(), this.leftToRight ? 0 : 1);
        }
        this.setCharIndices();
    }

    public TextLayout(String string, Map map, FontRenderContext fontRenderContext) {
        this(string, new Font(map), fontRenderContext);
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this(TextLayout.getText(attributedCharacterIterator), TextLayout.getFont(attributedCharacterIterator), fontRenderContext);
    }

    TextLayout(TextLayout textLayout, int n, int n2) {
        this.finit$();
        this.font = textLayout.font;
        this.frc = textLayout.frc;
        this.boundsCache = null;
        this.lm = textLayout.lm;
        this.leftToRight = textLayout.leftToRight;
        if (n2 > textLayout.getCharacterCount()) {
            n2 = textLayout.getCharacterCount();
        }
        this.string = textLayout.string.substring(n, n2);
        int n3 = textLayout.charIndices[n][0];
        int n4 = 1 + textLayout.charIndices[n2 - 1][0] - n3;
        this.runIndices = new int[n4][2];
        this.runs = new GlyphVector[n4];
        for (int i = 0; i < n4; ++i) {
            GlyphVector glyphVector = textLayout.runs[i + n3];
            int n5 = i > 0 ? 0 : textLayout.charIndices[n][1];
            int n6 = i < n4 - 1 ? glyphVector.getNumGlyphs() : 1 + textLayout.charIndices[n2 - 1][1] - n5;
            int[] nArray = glyphVector.getGlyphCodes(n5, n6, null);
            this.runs[i] = this.font.createGlyphVector(this.frc, nArray);
            this.runIndices[i][0] = textLayout.runIndices[i + n3][0] - n;
            this.runIndices[i][1] = textLayout.runIndices[i + n3][1] - n;
        }
        this.runIndices[n4 - 1][1] = n2 - 1;
        this.setCharIndices();
        this.determineWhiteSpace();
    }

    private void setCharIndices() {
        this.charIndices = new int[this.getCharacterCount()][2];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.runs.length; ++i) {
            n2 = -1;
            for (int j = 0; j < this.runs[i].getNumGlyphs(); ++j) {
                if (this.runs[i].getGlyphCharIndex(j) == n2) continue;
                this.charIndices[n][0] = i;
                this.charIndices[n][1] = j;
                n2 = this.runs[i].getGlyphCharIndex(j);
                ++n;
            }
        }
    }

    private static String getText(AttributedCharacterIterator attributedCharacterIterator) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = attributedCharacterIterator.getIndex();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.setIndex(n);
        return stringBuffer.toString();
    }

    private static Font getFont(AttributedCharacterIterator attributedCharacterIterator) {
        Font font = (Font)attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        if (font == null) {
            Float f = (Float)attributedCharacterIterator.getAttribute(TextAttribute.SIZE);
            int n = f != null ? (int)f.floatValue() : 14;
            font = new Font("Dialog", 0, n);
        }
        return font;
    }

    private void getStringProperties() {
        boolean bl = false;
        int n = 0;
        this.leftToRight = true;
        while (n < this.string.length() && !bl) {
            switch (Character.getDirectionality(this.string.charAt(n++))) {
                case 0: 
                case 14: 
                case 15: {
                    bl = true;
                    break;
                }
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    this.leftToRight = false;
                    bl = true;
                }
            }
        }
        this.determineWhiteSpace();
    }

    private void determineWhiteSpace() {
        int n;
        this.hasWhitespace = false;
        for (n = this.string.length() - 1; n >= 0 && Character.isWhitespace(this.string.charAt(n)); --n) {
        }
        while (n >= 0) {
            if (!Character.isWhitespace(this.string.charAt(n--))) continue;
            this.hasWhitespace = true;
        }
    }

    protected Object clone() {
        return new TextLayout(this.string, this.font, this.frc);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        for (int i = 0; i < this.runs.length; ++i) {
            graphics2D.drawGlyphVector(this.runs[i], f, f2);
            Rectangle2D rectangle2D = this.runs[i].getLogicalBounds();
            f = (float)((double)f + rectangle2D.getWidth());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextLayout)) {
            return false;
        }
        return this.equals((TextLayout)object);
    }

    public boolean equals(TextLayout textLayout) {
        if (this.runs.length != textLayout.runs.length) {
            return false;
        }
        for (int i = 0; i < this.runs.length; ++i) {
            if (this.runs[i].equals(textLayout.runs[i])) continue;
            return false;
        }
        return true;
    }

    public float getAdvance() {
        float f = 0.0f;
        for (int i = 0; i < this.runs.length; ++i) {
            f = (float)((double)f + this.runs[i].getLogicalBounds().getWidth());
        }
        return f;
    }

    public float getAscent() {
        return this.lm.getAscent();
    }

    public byte getBaseline() {
        return (byte)this.lm.getBaselineIndex();
    }

    public float[] getBaselineOffsets() {
        return this.lm.getBaselineOffsets();
    }

    public Shape getBlackBoxBounds(int n, int n2) {
        int n3;
        if (n2 - n <= 0) {
            return new Rectangle2D.Float();
        }
        if (n < 0 || n2 > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        GeneralPath generalPath = new GeneralPath();
        int n4 = this.charIndices[n][0];
        int n5 = this.charIndices[n][1];
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d += this.runs[n3].getLogicalBounds().getWidth();
        }
        for (n3 = n4; n3 <= this.charIndices[n2 - 1][0]; ++n3) {
            int n6 = n3 == this.charIndices[n2 - 1][0] ? this.charIndices[n2 - 1][1] : this.runs[n3].getNumGlyphs() - 1;
            for (int i = 0; i <= n6; ++i) {
                Rectangle2D rectangle2D = this.runs[n3].getGlyphVisualBounds(i).getBounds2D();
                Point2D point2D = this.runs[n3].getGlyphPosition(i);
                rectangle2D.setRect(d + rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                generalPath.append(rectangle2D, false);
            }
            d += this.runs[n3].getLogicalBounds().getWidth();
        }
        return generalPath;
    }

    public Rectangle2D getBounds() {
        if (this.boundsCache == null) {
            this.boundsCache = this.getOutline(new AffineTransform()).getBounds();
        }
        return this.boundsCache;
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo) {
        return this.getCaretInfo(textHitInfo, this.getBounds());
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public Shape getCaretShape(TextHitInfo textHitInfo) {
        return this.getCaretShape(textHitInfo, this.getBounds());
    }

    public Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public Shape[] getCaretShapes(int n) {
        return this.getCaretShapes(n, this.getBounds());
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public int getCharacterCount() {
        return this.string.length();
    }

    public byte getCharacterLevel(int n) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public float getDescent() {
        return this.lm.getDescent();
    }

    public TextLayout getJustifiedLayout(float f) {
        TextLayout textLayout = (TextLayout)this.clone();
        if (this.hasWhitespace) {
            textLayout.handleJustify(f);
        }
        return textLayout;
    }

    public float getLeading() {
        return this.lm.getLeading();
    }

    public Shape getLogicalHighlightShape(int n, int n2) {
        return this.getLogicalHighlightShape(n, n2, this.getBounds());
    }

    public Shape getLogicalHighlightShape(int n, int n2, Rectangle2D rectangle2D) {
        int n3;
        if (n2 - n <= 0) {
            return new Rectangle2D.Float();
        }
        if (n < 0 || n2 > this.getCharacterCount()) {
            return new Rectangle2D.Float();
        }
        Rectangle2D rectangle2D2 = null;
        int n4 = this.charIndices[n][0];
        int n5 = this.charIndices[n][1];
        double d = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d += this.runs[n3].getLogicalBounds().getWidth();
        }
        for (n3 = n4; n3 <= this.charIndices[n2 - 1][0]; ++n3) {
            int n6 = n3 == this.charIndices[n2 - 1][0] ? this.charIndices[n2 - 1][1] : this.runs[n3].getNumGlyphs() - 1;
            while (n5 <= n6) {
                Rectangle2D rectangle2D3 = this.runs[n3].getGlyphLogicalBounds(n5).getBounds2D();
                rectangle2D2 = rectangle2D2 == null ? rectangle2D3 : rectangle2D2.createUnion(rectangle2D3);
                ++n5;
            }
            n5 = 0;
            d += this.runs[n3].getLogicalBounds().getWidth();
        }
        return rectangle2D2;
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(int n) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(int n) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public TextHitInfo getNextRightHit(TextHitInfo textHitInfo) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public Shape getOutline(AffineTransform affineTransform) {
        float f = 0.0f;
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.runs.length; ++i) {
            generalPath.append(this.runs[i].getOutline(f, 0.0f), false);
            Rectangle2D rectangle2D = this.runs[i].getLogicalBounds();
            f = (float)((double)f + rectangle2D.getWidth());
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public float getVisibleAdvance() {
        int n;
        int n2;
        float f = 0.0f;
        if (this.runs.length <= 0) {
            return 0.0f;
        }
        if (!Character.isWhitespace(this.string.charAt(this.string.length() - 1))) {
            return this.getAdvance();
        }
        for (n2 = 0; n2 < this.runs.length - 1; ++n2) {
            f = (float)((double)f + this.runs[n2].getLogicalBounds().getWidth());
        }
        n2 = this.runIndices[this.runs.length - 1][0];
        for (n = this.string.length() - 1; n >= n2 && Character.isWhitespace(this.string.charAt(n)); --n) {
        }
        if (n < n2) {
            return f;
        }
        int n3 = n - n2;
        n = 0;
        while (this.runs[this.runs.length - 1].getGlyphCharIndex(n) <= n3) {
            f = (float)((double)f + this.runs[this.runs.length - 1].getGlyphLogicalBounds(n).getBounds2D().getWidth());
            ++n;
        }
        return f;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return this.getVisualHighlightShape(textHitInfo, textHitInfo2, this.getBounds());
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) throws NotImplementedException {
        throw new Error("not implemented");
    }

    protected void handleJustify(float f) {
        int n;
        double d = f - this.getVisibleAdvance();
        int n2 = 0;
        int n3 = this.string.length() - 1;
        while (Character.isWhitespace(this.string.charAt(n3))) {
            --n3;
        }
        int[] nArray = new int[this.string.length() * 10];
        for (int i = 0; i < this.runs.length; ++i) {
            for (int j = 0; j < this.runs[i].getNumGlyphs(); ++j) {
                n = this.runIndices[i][0] + this.runs[i].getGlyphCharIndex(j);
                if (!Character.isWhitespace(this.string.charAt(n))) continue;
                nArray[n2 * 2] = i;
                nArray[n2 * 2 + 1] = j;
                ++n2;
            }
        }
        d /= (double)n2;
        double d2 = 0.0;
        n = 0;
        for (int i = 0; i < this.runs.length; ++i) {
            for (int j = 0; j < this.runs[i].getNumGlyphs(); ++j) {
                if (nArray[n * 2] == i && nArray[n * 2 + 1] == j) {
                    ++n;
                    d2 += d;
                }
                Point2D point2D = this.runs[i].getGlyphPosition(j);
                point2D.setLocation(point2D.getX() + d2, point2D.getY());
                this.runs[i].setGlyphPosition(j, point2D);
            }
        }
    }

    public TextHitInfo hitTestChar(float f, float f2) {
        return this.hitTestChar(f, f2, this.getBounds());
    }

    public TextHitInfo hitTestChar(float f, float f2, Rectangle2D rectangle2D) throws NotImplementedException {
        throw new Error("not implemented");
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public boolean isVertical() {
        return false;
    }

    public int hashCode() throws NotImplementedException {
        throw new Error("not implemented");
    }

    public String toString() {
        return "TextLayout [string:" + this.string + ", Font:" + this.font + " Rendercontext:" + this.frc + "]";
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) throws NotImplementedException {
            throw new Error("not implemented");
        }
    }
}

