/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.gcj.Core;
import gnu.gcj.runtime.SharedLibHelper;
import gnu.java.net.protocol.core.CoreInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class URLClassLoader
extends SecureClassLoader {
    private static HashMap urlloaders = new HashMap();
    private static HashMap factoryCache = new HashMap(5);
    private final Vector urls;
    private final Vector urlinfos;
    private final URLStreamHandlerFactory factory;
    private final AccessControlContext securityContext;
    private String thisString;

    private /* synthetic */ void finit$() {
        this.urls = new Vector();
        this.urlinfos = new Vector();
    }

    public URLClassLoader(URL[] uRLArray) throws SecurityException {
        this.finit$();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader) throws SecurityException {
        super(classLoader);
        this.finit$();
        this.factory = null;
        this.securityContext = null;
        this.addURLs(uRLArray);
    }

    URLClassLoader(ClassLoader classLoader, AccessControlContext accessControlContext) {
        super(classLoader);
        this.finit$();
        this.factory = null;
        this.securityContext = accessControlContext;
    }

    public URLClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws SecurityException {
        super(classLoader);
        this.finit$();
        this.securityContext = null;
        this.factory = uRLStreamHandlerFactory;
        this.addURLs(uRLArray);
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            block3: {
                try {
                    if (uRLStreamHandlerFactory == null || factoryCache.get(uRLStreamHandlerFactory) != null) break block3;
                    factoryCache.put(uRLStreamHandlerFactory, new HashMap(5));
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            Object var5_5 = null;
        }
    }

    protected void addURL(URL uRL) {
        this.urls.add(uRL);
        this.addURLImpl(uRL);
    }

    private void addURLImpl(URL uRL) {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            URLLoader uRLLoader;
            block13: {
                try {
                    URL uRL2;
                    Object object;
                    Object object2;
                    Object object3;
                    if (uRL == null) {
                        Object var3_3 = null;
                        return;
                    }
                    this.thisString = null;
                    uRLLoader = (URLLoader)urlloaders.get(uRL);
                    if (uRLLoader == null) {
                        object3 = uRL.getFile();
                        object2 = uRL.getProtocol();
                        if ("file".equals(object2)) {
                            object = new File((String)object3);
                            try {
                                uRL2 = ((File)object).getCanonicalFile().toURL();
                            }
                            catch (IOException iOException) {
                                try {
                                    uRL2 = ((File)object).getAbsoluteFile().toURL();
                                }
                                catch (MalformedURLException malformedURLException) {
                                    uRL2 = uRL;
                                }
                            }
                        } else {
                            uRL2 = uRL;
                        }
                        uRLLoader = "gcjlib".equals(object2) ? new SoURLLoader(this, uRL) : (!((String)object3).endsWith("/") && !((String)object3).endsWith(File.separator) ? new JarURLLoader(this, uRL, uRL2) : ("file".equals(object2) ? new FileURLLoader(this, uRL, uRL2) : ("core".equals(object2) ? new CoreURLLoader(this, uRL) : new RemoteURLLoader(this, uRL))));
                        urlloaders.put(uRL, uRLLoader);
                    }
                    this.urlinfos.add(uRLLoader);
                    object3 = uRLLoader.getClassPath();
                    if (object3 == null) break block13;
                    object2 = ((AbstractList)object3).iterator();
                    while (object2.hasNext()) {
                        uRL2 = (URL)object2.next();
                        object = (URLLoader)urlloaders.get(uRL2);
                        if (this.urlinfos.contains(object)) continue;
                        this.addURLImpl(uRL2);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    throw throwable;
                }
            }
            uRLLoader = null;
        }
    }

    private void addURLs(URL[] uRLArray) {
        for (int i = 0; i < uRLArray.length; ++i) {
            this.urls.add(uRLArray[i]);
            this.addURLImpl(uRLArray[i]);
        }
    }

    private String getAttributeValue(Attributes.Name name, Attributes attributes, Attributes attributes2) {
        String string = null;
        if (attributes != null) {
            string = attributes.getValue(name);
        }
        if (string == null) {
            string = attributes2.getValue(name);
        }
        return string;
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) != '.') continue;
            stringBuffer.setCharAt(i, '/');
        }
        stringBuffer.append('/');
        String string2 = stringBuffer.toString();
        Attributes attributes = manifest.getAttributes(string2);
        Attributes attributes2 = manifest.getMainAttributes();
        String string3 = this.getAttributeValue(Attributes.Name.SPECIFICATION_TITLE, attributes, attributes2);
        String string4 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VERSION, attributes, attributes2);
        String string5 = this.getAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, attributes, attributes2);
        String string6 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_TITLE, attributes, attributes2);
        String string7 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, attributes, attributes2);
        String string8 = this.getAttributeValue(Attributes.Name.IMPLEMENTATION_VENDOR, attributes, attributes2);
        String string9 = attributes2.getValue(Attributes.Name.SEALED);
        if ("false".equals(string9)) {
            uRL = null;
        }
        return this.definePackage(string, string3, string5, string4, string6, string8, string7, uRL);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz;
        Object object;
        String string2 = string.replace('.', '/') + ".class";
        int n = this.urlinfos.size();
        Resource resource = null;
        for (int i = 0; i < n && resource == null; ++i) {
            object = (URLLoader)this.urlinfos.elementAt(i);
            if (object == null) continue;
            clazz = ((URLLoader)object).getClass(string);
            if (clazz != null) {
                return clazz;
            }
            resource = ((URLLoader)object).getResource(string2);
        }
        if (resource == null) {
            String string3 = string + " not found";
            if (URLClassLoader.runtimeInitialized()) {
                string3 = string3 + new StringBuffer(" in ").append(this);
            }
            throw new ClassNotFoundException(string3);
        }
        try {
            Object object2;
            int n2;
            InputStream inputStream;
            block17: {
                inputStream = resource.getInputStream();
                try {
                    int n3 = resource.getLength();
                    if (n3 != -1) {
                        object = new byte[n3];
                        int n4 = 0;
                        while (n3 - n4 > 0) {
                            int n5 = inputStream.read((byte[])object, n4, n3 - n4);
                            if (n5 == -1) {
                                throw new EOFException("Not enough data reading from: " + inputStream);
                            }
                            n4 += n5;
                        }
                        break block17;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                    byte[] byArray = new byte[4096];
                    n2 = 0;
                    while (n2 != -1) {
                        n2 = inputStream.read(byArray);
                        if (n2 == -1) continue;
                        byteArrayOutputStream.write(byArray, 0, n2);
                    }
                    object = byteArrayOutputStream.toByteArray();
                }
                catch (Throwable throwable) {
                    clazz = null;
                    inputStream.close();
                    throw throwable;
                }
            }
            Object object3 = null;
            inputStream.close();
            object3 = object;
            CodeSource codeSource = resource.getCodeSource();
            String string4 = null;
            n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string4 = string.substring(0, n2);
            }
            if (string4 != null && this.getPackage(string4) == null) {
                object2 = resource.loader.getManifest();
                if (object2 == null) {
                    this.definePackage(string4, null, null, null, null, null, null, null);
                } else {
                    this.definePackage(string4, (Manifest)object2, resource.loader.baseURL);
                }
            }
            object2 = System.getSecurityManager();
            Class clazz2 = null;
            clazz2 = object2 != null && this.securityContext != null ? (Class)AccessController.doPrivileged(new PrivilegedAction(this, codeSource, (byte[])object3, string){
                private /* synthetic */ URLClassLoader this$0;
                private /* synthetic */ CodeSource val$source;
                private /* synthetic */ byte[] val$classData;
                private /* synthetic */ String val$className;
                {
                    this.this$0 = uRLClassLoader;
                    this.finit$(codeSource, byArray, string);
                }

                private /* synthetic */ void finit$(CodeSource codeSource, byte[] byArray, String string) {
                    this.val$className = string;
                    this.val$classData = byArray;
                    this.val$source = codeSource;
                }

                public Object run() {
                    return this.this$0.defineClass(this.val$className, this.val$classData, 0, this.val$classData.length, this.val$source);
                }
            }, this.securityContext) : this.defineClass(string, (byte[])object3, 0, ((Object)object3).length, codeSource);
            Object[] objectArray = resource.getCertificates();
            if (objectArray != null) {
                super.setSigners(clazz2, objectArray);
            }
            Class clazz3 = clazz2;
            return clazz3;
        }
        catch (IOException iOException) {
            ClassNotFoundException classNotFoundException = new ClassNotFoundException(string + " not found in " + this);
            classNotFoundException.initCause(iOException);
            throw classNotFoundException;
        }
    }

    public String toString() {
        URLClassLoader uRLClassLoader = this;
        synchronized (uRLClassLoader) {
            try {
                URL[] uRLArray;
                CharSequence charSequence;
                if (this.thisString == null) {
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append(this.getClass().getName());
                    ((StringBuffer)charSequence).append("{urls=[");
                    uRLArray = this.getURLs();
                    for (int i = 0; i < uRLArray.length; ++i) {
                        ((StringBuffer)charSequence).append(uRLArray[i]);
                        if (i >= uRLArray.length - 1) continue;
                        ((StringBuffer)charSequence).append(',');
                    }
                    ((StringBuffer)charSequence).append(']');
                    ((StringBuffer)charSequence).append(", parent=");
                    ((StringBuffer)charSequence).append(this.getParent());
                    ((StringBuffer)charSequence).append('}');
                    this.thisString = ((StringBuffer)charSequence).toString();
                }
                charSequence = this.thisString;
                uRLArray = null;
                return charSequence;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    private Resource findURLResource(String string) {
        int n = this.urlinfos.size();
        for (int i = 0; i < n; ++i) {
            Resource resource;
            URLLoader uRLLoader = (URLLoader)this.urlinfos.elementAt(i);
            if (uRLLoader == null || (resource = uRLLoader.getResource(string)) == null) continue;
            return resource;
        }
        return null;
    }

    public URL findResource(String string) {
        Resource resource = this.findURLResource(string);
        if (resource != null) {
            return resource.getURL();
        }
        return null;
    }

    URLStreamHandler getURLStreamHandler(String string) {
        URLStreamHandler uRLStreamHandler;
        Object object;
        if (this.factory == null) {
            return null;
        }
        HashMap hashMap = factoryCache;
        synchronized (hashMap) {
            block4: {
                try {
                    object = (HashMap)factoryCache.get(this.factory);
                    uRLStreamHandler = (URLStreamHandler)((HashMap)object).get(string);
                    if (uRLStreamHandler != null) break block4;
                    uRLStreamHandler = this.factory.createURLStreamHandler(string);
                    ((HashMap)object).put(string, uRLStreamHandler);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    throw throwable;
                }
            }
            object = null;
        }
        object = uRLStreamHandler;
        return object;
    }

    public Enumeration findResources(String string) throws IOException {
        Vector vector = new Vector();
        int n = this.urlinfos.size();
        for (int i = 0; i < n; ++i) {
            URLLoader uRLLoader = (URLLoader)this.urlinfos.elementAt(i);
            Resource resource = uRLLoader.getResource(string);
            if (resource == null) continue;
            vector.add(resource.getURL());
        }
        return vector.elements();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            String string2 = uRL.getFile();
            if (string2.endsWith("/") || string2.endsWith(File.separator)) {
                permissionCollection.add(new FilePermission(string2 + "-", "read"));
            } else {
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        } else {
            String string3 = uRL.getHost();
            if (string3 != null) {
                permissionCollection.add(new SocketPermission(string3, "connect,accept"));
            }
        }
        return permissionCollection;
    }

    public URL[] getURLs() {
        return (URL[])this.urls.toArray(new URL[this.urls.size()]);
    }

    public static URLClassLoader newInstance(URL[] uRLArray) throws SecurityException {
        return URLClassLoader.newInstance(uRLArray, null);
    }

    public static URLClassLoader newInstance(URL[] uRLArray, ClassLoader classLoader) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return new URLClassLoader(uRLArray, classLoader);
        }
        Object object = securityManager.getSecurityContext();
        if (!(object instanceof AccessControlContext)) {
            throw new SecurityException("securityContext must be AccessControlContext: " + object);
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(null, object, classLoader){
            private /* synthetic */ URLClassLoader this$0;
            private /* synthetic */ Object val$securityContext;
            private /* synthetic */ ClassLoader val$parent;
            {
                this.this$0 = uRLClassLoader;
                this.finit$(object, classLoader);
            }

            private /* synthetic */ void finit$(Object object, ClassLoader classLoader) {
                this.val$parent = classLoader;
                this.val$securityContext = object;
            }

            public Object run() {
                return new URLClassLoader(this.val$parent, (AccessControlContext)this.val$securityContext);
            }
        });
        uRLClassLoader.addURLs(uRLArray);
        return uRLClassLoader;
    }

    private static native boolean runtimeInitialized();

    static final class CoreResource
    extends Resource {
        private final Core core;
        private final String name;

        CoreResource(CoreURLLoader coreURLLoader, String string, Core core) {
            super(coreURLLoader);
            this.core = core;
            this.name = string;
        }

        InputStream getInputStream() throws IOException {
            return new CoreInputStream(this.core);
        }

        public int getLength() {
            return this.core.length;
        }

        public URL getURL() {
            try {
                return new URL(this.loader.baseURL, this.name, this.loader.classloader.getURLStreamHandler("core"));
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
        }
    }

    static final class CoreURLLoader
    extends URLLoader {
        private String dir;

        CoreURLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            super(uRLClassLoader, uRL);
            this.dir = this.baseURL.getFile();
        }

        Resource getResource(String string) {
            Core core = Core.find(this.dir + string);
            if (core != null) {
                return new CoreResource(this, string, core);
            }
            return null;
        }
    }

    static final class FileResource
    extends Resource {
        final File file;

        FileResource(FileURLLoader fileURLLoader, File file) {
            super(fileURLLoader);
            this.file = file;
        }

        InputStream getInputStream() throws IOException {
            if (this.file.isDirectory()) {
                URL uRL = this.getURL();
                return uRL.openStream();
            }
            return new FileInputStream(this.file);
        }

        public int getLength() {
            if (this.file.isDirectory()) {
                URL uRL = this.getURL();
                try {
                    URLConnection uRLConnection = uRL.openConnection();
                    return uRLConnection.getContentLength();
                }
                catch (IOException iOException) {
                    return -1;
                }
            }
            return (int)this.file.length();
        }

        public URL getURL() {
            try {
                return this.file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
        }
    }

    static final class FileURLLoader
    extends URLLoader {
        File dir;

        FileURLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            super(uRLClassLoader, uRL, uRL2);
            this.dir = new File(uRL2.getFile());
        }

        Resource getResource(String string) {
            try {
                File file = new File(this.dir, string).getCanonicalFile();
                if (file.exists() && !file.isDirectory()) {
                    return new FileResource(this, file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    static final class SoResource
    extends Resource {
        final URL url;

        SoResource(SoURLLoader soURLLoader, URL uRL) {
            super(soURLLoader);
            this.url = uRL;
        }

        InputStream getInputStream() throws IOException {
            URLConnection uRLConnection = this.url.openConnection();
            return uRLConnection.getInputStream();
        }

        public int getLength() {
            return -1;
        }

        public URL getURL() {
            return this.url;
        }
    }

    static final class SoURLLoader
    extends URLLoader {
        SharedLibHelper helper;

        SoURLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            this(uRLClassLoader, uRL, uRL);
        }

        SoURLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            super(uRLClassLoader, uRL, uRL2);
            this.helper = SharedLibHelper.findHelper(uRLClassLoader, uRL.getFile(), this.noCertCodeSource, true);
        }

        Class getClass(String string) {
            return this.helper.findClass(string);
        }

        Resource getResource(String string) {
            URL uRL = this.helper.findResource(string);
            if (uRL == null) {
                return null;
            }
            return new SoResource(this, uRL);
        }
    }

    static final class RemoteResource
    extends Resource {
        private final URL url;
        private final InputStream stream;
        private final int length;

        RemoteResource(RemoteURLLoader remoteURLLoader, String string, URL uRL, InputStream inputStream, int n) {
            super(remoteURLLoader);
            this.url = uRL;
            this.stream = inputStream;
            this.length = n;
        }

        InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public int getLength() {
            return this.length;
        }

        public URL getURL() {
            return this.url;
        }
    }

    static final class RemoteURLLoader
    extends URLLoader {
        private final String protocol;

        RemoteURLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            super(uRLClassLoader, uRL);
            this.protocol = uRL.getProtocol();
        }

        Resource getResource(String string) {
            try {
                int n;
                URL uRL = new URL(this.baseURL, string, this.classloader.getURLStreamHandler(this.protocol));
                URLConnection uRLConnection = uRL.openConnection();
                int n2 = uRLConnection.getContentLength();
                InputStream inputStream = uRLConnection.getInputStream();
                if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) / 100 != 2) {
                    return null;
                }
                if (inputStream != null) {
                    return new RemoteResource(this, string, uRL, inputStream, n2);
                }
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    static final class JarURLResource
    extends Resource {
        private final JarEntry entry;
        private final String name;

        JarURLResource(JarURLLoader jarURLLoader, String string, JarEntry jarEntry) {
            super(jarURLLoader);
            this.entry = jarEntry;
            this.name = string;
        }

        InputStream getInputStream() throws IOException {
            return ((JarURLLoader)this.loader).jarfile.getInputStream(this.entry);
        }

        int getLength() {
            return (int)this.entry.getSize();
        }

        Certificate[] getCertificates() {
            return ((JarEntry)((JarURLLoader)this.loader).jarfile.getEntry(this.name)).getCertificates();
        }

        URL getURL() {
            try {
                return new URL(((JarURLLoader)this.loader).baseJarURL, this.name, this.loader.classloader.getURLStreamHandler("jar"));
            }
            catch (MalformedURLException malformedURLException) {
                InternalError internalError = new InternalError();
                internalError.initCause(malformedURLException);
                throw internalError;
            }
        }
    }

    static final class JarURLLoader
    extends URLLoader {
        final JarFile jarfile;
        final URL baseJarURL;
        Vector classPath;

        public JarURLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            super(uRLClassLoader, uRL, uRL2);
            String string = uRL.toExternalForm();
            StringBuffer stringBuffer = new StringBuffer(string.length() + 6);
            stringBuffer.append("jar:");
            stringBuffer.append(string);
            stringBuffer.append("!/");
            String string2 = stringBuffer.toString();
            this.classPath = null;
            URL uRL3 = null;
            JarFile jarFile = null;
            try {
                String string3;
                Attributes attributes;
                uRL3 = new URL(null, string2, uRLClassLoader.getURLStreamHandler("jar"));
                jarFile = ((JarURLConnection)uRL3.openConnection()).getJarFile();
                Manifest manifest = jarFile.getManifest();
                if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (string3 = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    this.classPath = new Vector();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreElements()) {
                        String string4 = stringTokenizer.nextToken();
                        try {
                            URL uRL4 = new URL(uRL, string4);
                            this.classPath.add(uRL4);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.baseJarURL = uRL3;
            this.jarfile = jarFile;
        }

        Resource getResource(String string) {
            JarEntry jarEntry;
            if (this.jarfile == null) {
                return null;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((jarEntry = this.jarfile.getJarEntry(string)) != null) {
                return new JarURLResource(this, string, jarEntry);
            }
            return null;
        }

        Manifest getManifest() {
            try {
                if (this.jarfile == null) {
                    return null;
                }
                return this.jarfile.getManifest();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        Vector getClassPath() {
            return this.classPath;
        }
    }

    static abstract class Resource {
        final URLLoader loader;

        Resource(URLLoader uRLLoader) {
            this.loader = uRLLoader;
        }

        CodeSource getCodeSource() {
            Certificate[] certificateArray = this.getCertificates();
            if (certificateArray == null) {
                return this.loader.noCertCodeSource;
            }
            return new CodeSource(this.loader.baseURL, certificateArray);
        }

        Certificate[] getCertificates() {
            return null;
        }

        abstract URL getURL();

        abstract int getLength();

        abstract InputStream getInputStream() throws IOException;
    }

    static abstract class URLLoader {
        final URLClassLoader classloader;
        final URL baseURL;
        final CodeSource noCertCodeSource;

        URLLoader(URLClassLoader uRLClassLoader, URL uRL) {
            this(uRLClassLoader, uRL, uRL);
        }

        URLLoader(URLClassLoader uRLClassLoader, URL uRL, URL uRL2) {
            this.classloader = uRLClassLoader;
            this.baseURL = uRL;
            this.noCertCodeSource = new CodeSource(uRL2, null);
        }

        Class getClass(String string) {
            return null;
        }

        abstract Resource getResource(String var1);

        Manifest getManifest() {
            return null;
        }

        Vector getClassPath() {
            return null;
        }
    }
}

