/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.bsd;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.bsd.BsdDebugger;
import sun.jvm.hotspot.debugger.bsd.BsdThreadContextFactory;

class BsdThread
implements ThreadProxy {
    private BsdDebugger debugger;
    private int lwp_id;

    BsdThread(BsdDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.lwp_id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    BsdThread(BsdDebugger debugger, long id) {
        this.debugger = debugger;
        this.lwp_id = (int)id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BsdThread)) {
            return false;
        }
        return ((BsdThread)obj).lwp_id == this.lwp_id;
    }

    public int hashCode() {
        return this.lwp_id;
    }

    public String toString() {
        return Integer.toString(this.lwp_id);
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.lwp_id);
        ThreadContext context = BsdThreadContextFactory.createThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }
}

