/*
 * Decompiled with CFR 0.152.
 */
package javax.management.event;

import com.sun.jmx.event.EventBuffer;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.util.List;
import javax.management.Notification;
import javax.management.event.EventForwarder;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;

public class FetchingEventForwarder
implements EventForwarder {
    private EventBuffer buffer;
    private int bufferSize;
    private String clientId;
    private static final ClassLogger logger = new ClassLogger("javax.management.event", "FetchingEventForwarder");

    public FetchingEventForwarder(int n) {
        if (logger.traceOn()) {
            logger.trace("Constructor", "buffer size is " + n);
        }
        this.buffer = new EventBuffer(n);
        this.bufferSize = n;
    }

    public NotificationResult fetchNotifications(long l, int n, long l2) {
        if (logger.traceOn()) {
            logger.trace("fetchNotifications", l + " " + n + " " + l2);
        }
        return this.buffer.fetchNotifications(l, l2, n);
    }

    @Override
    public void forward(Notification notification, Integer n) throws IOException {
        if (logger.traceOn()) {
            logger.trace("forward", notification + " " + n);
        }
        this.buffer.add(new TargetedNotification(notification, n));
    }

    @Override
    public void close() throws IOException {
        if (logger.traceOn()) {
            logger.trace("close", "");
        }
        this.buffer.close();
    }

    @Override
    public void setClientId(String string) throws IOException {
        if (logger.traceOn()) {
            logger.trace("setClientId", string);
        }
        this.clientId = string;
    }

    protected void setList(List<TargetedNotification> list) {
        if (logger.traceOn()) {
            logger.trace("setList", "");
        }
        if (this.clientId != null) {
            throw new IllegalStateException();
        }
        this.buffer = new EventBuffer(this.bufferSize, list);
    }
}

