/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.management.ClientContext;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.event.EventClientDelegate;
import javax.management.remote.IdentityMBeanServerForwarder;
import javax.management.remote.JMXAddressable;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;

public abstract class JMXConnectorServer
extends NotificationBroadcasterSupport
implements JMXConnectorServerMBean,
MBeanRegistration,
JMXAddressable {
    public static final String AUTHENTICATOR = "jmx.remote.authenticator";
    public static final String DELEGATE_TO_EVENT_SERVICE = "jmx.remote.delegate.event.service";
    public static final String CONTEXT_FORWARDER = "jmx.remote.context.forwarder";
    public static final String LOCALIZE_MBEAN_INFO_FORWARDER = "jmx.remote.localize.mbean.info";
    public static final String EVENT_CLIENT_DELEGATE_FORWARDER = "jmx.remote.event.client.delegate.forwarder";
    private MBeanServer userMBeanServer;
    private final MBeanServerForwarder systemMBeanServerForwarder = new IdentityMBeanServerForwarder();
    private ObjectName myName;
    private List<String> connectionIds = new ArrayList<String>();
    private static final int[] sequenceNumberLock = new int[0];
    private static long sequenceNumber;

    public JMXConnectorServer() {
        this((MBeanServer)null);
    }

    public JMXConnectorServer(MBeanServer mBeanServer) {
        this.insertUserMBeanServer(mBeanServer);
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.userMBeanServer;
    }

    @Override
    public synchronized void setMBeanServerForwarder(MBeanServerForwarder mBeanServerForwarder) {
        if (mBeanServerForwarder == null) {
            throw new IllegalArgumentException("Invalid null argument: mbsf");
        }
        if (this.userMBeanServer != null) {
            mBeanServerForwarder.setMBeanServer(this.userMBeanServer);
        }
        this.insertUserMBeanServer(mBeanServerForwarder);
    }

    public synchronized void removeMBeanServerForwarder(MBeanServerForwarder mBeanServerForwarder) {
        MBeanServer mBeanServer;
        if (mBeanServerForwarder == null) {
            throw new IllegalArgumentException("Invalid null argument: mbsf");
        }
        if (this.systemMBeanServerForwarder.equals(mBeanServerForwarder)) {
            throw new IllegalArgumentException("Cannot remove system forwarder");
        }
        MBeanServerForwarder mBeanServerForwarder2 = this.systemMBeanServerForwarder;
        while (!mBeanServerForwarder.equals(mBeanServer = mBeanServerForwarder2.getMBeanServer())) {
            if (mBeanServer instanceof MBeanServerForwarder) {
                mBeanServerForwarder2 = (MBeanServerForwarder)mBeanServer;
                continue;
            }
            throw new NoSuchElementException("MBeanServerForwarder not in chain");
        }
        MBeanServer mBeanServer2 = mBeanServerForwarder.getMBeanServer();
        mBeanServerForwarder2.setMBeanServer(mBeanServer2);
        if (this.userMBeanServer == mBeanServerForwarder) {
            this.userMBeanServer = mBeanServer2;
        }
    }

    private void insertUserMBeanServer(MBeanServer mBeanServer) {
        MBeanServer mBeanServer2;
        MBeanServerForwarder mBeanServerForwarder = this.systemMBeanServerForwarder;
        while ((mBeanServer2 = mBeanServerForwarder.getMBeanServer()) != this.userMBeanServer) {
            mBeanServerForwarder = (MBeanServerForwarder)mBeanServer2;
        }
        this.userMBeanServer = mBeanServer;
        mBeanServerForwarder.setMBeanServer(mBeanServer);
    }

    public MBeanServerForwarder getSystemMBeanServerForwarder() {
        if (!this.supportsSystemMBeanServerForwarder()) {
            throw new UnsupportedOperationException("System MBeanServerForwarder not supported by this connector server");
        }
        return this.systemMBeanServerForwarder;
    }

    public boolean supportsSystemMBeanServerForwarder() {
        return false;
    }

    public void closeConnection(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void installStandardForwarders(Map<String, ?> map) {
        MBeanServerForwarder mBeanServerForwarder;
        MBeanServerForwarder mBeanServerForwarder2 = this.getSystemMBeanServerForwarder();
        boolean bl = EnvHelp.computeBooleanFromString(map, EVENT_CLIENT_DELEGATE_FORWARDER, false, true);
        boolean bl2 = EnvHelp.computeBooleanFromString(map, LOCALIZE_MBEAN_INFO_FORWARDER, false, false);
        boolean bl3 = EnvHelp.computeBooleanFromString(map, CONTEXT_FORWARDER, false, true);
        if (bl2 && !bl3) {
            throw new IllegalArgumentException("Inconsistent environment parameters: jmx.remote.localize.mbean.info=\"true\" requires jmx.remote.context.forwarder=\"true\"");
        }
        if (bl) {
            mBeanServerForwarder = EventClientDelegate.newForwarder(mBeanServerForwarder2.getMBeanServer(), mBeanServerForwarder2);
            mBeanServerForwarder2.setMBeanServer(mBeanServerForwarder);
        }
        if (bl2) {
            mBeanServerForwarder = ClientContext.newLocalizeMBeanInfoForwarder(mBeanServerForwarder2.getMBeanServer());
            mBeanServerForwarder2.setMBeanServer(mBeanServerForwarder);
        }
        if (bl3) {
            mBeanServerForwarder = ClientContext.newContextForwarder(mBeanServerForwarder2.getMBeanServer(), mBeanServerForwarder2);
            mBeanServerForwarder2.setMBeanServer(mBeanServerForwarder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionIds() {
        List<String> list = this.connectionIds;
        synchronized (list) {
            return this.connectionIds.toArray(new String[this.connectionIds.size()]);
        }
    }

    @Override
    public JMXConnector toJMXConnector(Map<String, ?> map) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        JMXServiceURL jMXServiceURL = this.getAddress();
        return JMXConnectorFactory.newJMXConnector(jMXServiceURL, map);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed"};
        String string = JMXConnectionNotification.class.getName();
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, string, "A client connection has been opened or closed")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List<String> list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.add(string);
        }
        this.sendNotification("jmx.remote.connection.opened", string, string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List<String> list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(string);
        }
        this.sendNotification("jmx.remote.connection.closed", string, string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionFailed(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List<String> list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(string);
        }
        this.sendNotification("jmx.remote.connection.failed", string, string2, object);
    }

    private void sendNotification(String string, String string2, String string3, Object object) {
        JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification(string, this.getNotificationSource(), string2, JMXConnectorServer.nextSequenceNumber(), string3, object);
        this.sendNotification(jMXConnectionNotification);
    }

    private synchronized Object getNotificationSource() {
        if (this.myName != null) {
            return this.myName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextSequenceNumber() {
        int[] nArray = sequenceNumberLock;
        synchronized (sequenceNumberLock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sequenceNumber++;
        }
    }

    @Override
    public synchronized ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        if (mBeanServer == null || objectName == null) {
            throw new NullPointerException("Null MBeanServer or ObjectName");
        }
        if (this.userMBeanServer == null) {
            this.insertUserMBeanServer(mBeanServer);
            this.myName = objectName;
        }
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public synchronized void preDeregister() throws Exception {
        if (this.myName != null && this.isActive()) {
            this.stop();
            this.myName = null;
        }
    }

    @Override
    public void postDeregister() {
        this.myName = null;
    }
}

