/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerBackreferenceReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations..."), "downloadreferrers", I18n.tr("Download primitives referring to one of the selected primitives"), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...")), 68, 15), true);
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, Collection<OsmPrimitive> children) throws IllegalArgumentException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(targetLayer, children));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, Map<Long, OsmPrimitiveType> children) throws IllegalArgumentException {
        if (children == null || children.isEmpty()) {
            return;
        }
        Main.worker.submit(new DownloadReferrersTask(targetLayer, children));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, long id, OsmPrimitiveType type) throws IllegalArgumentException {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Id > 0 required, got {0}", id));
        }
        if (type == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "type"));
        }
        Main.worker.submit(new DownloadReferrersTask(targetLayer, id, type));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || Main.map == null || Main.map.mapView == null) {
            return;
        }
        OsmDataLayer layer = Main.map.mapView.getEditLayer();
        if (layer == null) {
            return;
        }
        Collection<OsmPrimitive> primitives = layer.data.getSelected();
        DownloadReferrersAction.downloadReferrers(layer, primitives);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadReferrersTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private Exception lastException;
        private OsmServerBackreferenceReader reader;
        private OsmDataLayer targetLayer;
        private Map<Long, OsmPrimitiveType> children;
        private DataSet parents;

        public DownloadReferrersTask(OsmDataLayer targetLayer, Collection<OsmPrimitive> children) {
            super("Download referrers", false);
            if (targetLayer == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "targetLayer"));
            }
            this.cancelled = false;
            this.children = new HashMap<Long, OsmPrimitiveType>();
            if (children != null) {
                for (OsmPrimitive p : children) {
                    if (p.isNew()) continue;
                    this.children.put(p.getId(), OsmPrimitiveType.from(p));
                }
            }
            this.targetLayer = targetLayer;
            this.parents = new DataSet();
        }

        public DownloadReferrersTask(OsmDataLayer targetLayer, Map<Long, OsmPrimitiveType> children) {
            super("Download referrers", false);
            if (targetLayer == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "targetLayer"));
            }
            this.cancelled = false;
            this.children = new HashMap<Long, OsmPrimitiveType>();
            if (children != null) {
                for (Map.Entry<Long, OsmPrimitiveType> entry : children.entrySet()) {
                    if (entry.getKey() <= 0L || entry.getValue() == null) continue;
                    children.put(entry.getKey(), entry.getValue());
                }
            }
            this.targetLayer = targetLayer;
            this.parents = new DataSet();
        }

        public DownloadReferrersTask(OsmDataLayer targetLayer, long id, OsmPrimitiveType type) throws IllegalArgumentException {
            super("Download referrers", false);
            if (targetLayer == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "targetLayer"));
            }
            if (id <= 0L) {
                throw new IllegalArgumentException(I18n.tr("Id > 0 required, got {0}", id));
            }
            if (type == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "type"));
            }
            this.cancelled = false;
            this.children = new HashMap<Long, OsmPrimitiveType>();
            this.children.put(id, type);
            this.targetLayer = targetLayer;
            this.parents = new DataSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            this.cancelled = true;
            DownloadReferrersTask downloadReferrersTask = this;
            synchronized (downloadReferrersTask) {
                if (this.reader != null) {
                    this.reader.cancel();
                }
            }
        }

        @Override
        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionUtil.explainException(this.lastException);
                return;
            }
            MergeVisitor visitor = new MergeVisitor(this.targetLayer.data, this.parents);
            visitor.merge();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DownloadReferrersTask.this.targetLayer.fireDataChange();
                    Main.map.mapView.repaint();
                }
            });
            if (visitor.getConflicts().isEmpty()) {
                return;
            }
            this.targetLayer.getConflicts().add(visitor.getConflicts());
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", visitor.getConflicts().size()), I18n.tr("Conflicts during download"), 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void downloadParents(long id, OsmPrimitiveType type, ProgressMonitor progressMonitor) throws OsmTransferException {
            this.reader = new OsmServerBackreferenceReader(id, type);
            DataSet ds = this.reader.parseOsm(progressMonitor);
            DownloadReferrersTask downloadReferrersTask = this;
            synchronized (downloadReferrersTask) {
                this.reader = null;
            }
            MergeVisitor visitor = new MergeVisitor(this.parents, ds);
            visitor.merge();
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.progressMonitor.setTicksCount(this.children.size());
                int i = 1;
                for (Map.Entry<Long, OsmPrimitiveType> entry : this.children.entrySet()) {
                    if (this.cancelled) {
                        return;
                    }
                    String msg = "";
                    switch (entry.getValue()) {
                        case NODE: {
                            msg = I18n.tr("({0}/{1}) Loading parents of node {2}", i + 1, this.children.size(), entry.getKey());
                            break;
                        }
                        case WAY: {
                            msg = I18n.tr("({0}/{1}) Loading parents of way {2}", i + 1, this.children.size(), entry.getKey());
                            break;
                        }
                        case RELATION: {
                            msg = I18n.tr("({0}/{1}) Loading parents of relation {2}", i + 1, this.children.size(), entry.getKey());
                        }
                    }
                    this.progressMonitor.subTask(msg);
                    this.downloadParents(entry.getKey(), entry.getValue(), this.progressMonitor.createSubTaskMonitor(1, false));
                    ++i;
                }
            }
            catch (Exception e) {
                if (this.cancelled) {
                    return;
                }
                this.lastException = e;
            }
        }
    }
}

