/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer"), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer"), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge")), 77, 2), true);
    }

    public void merge(Layer sourceLayer) {
        if (sourceLayer == null) {
            return;
        }
        List<Layer> targetLayers = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(sourceLayer);
        if (targetLayers.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(sourceLayer);
            return;
        }
        Layer targetLayer = this.askTargetLayer(targetLayers);
        if (targetLayer == null) {
            return;
        }
        targetLayer.mergeFrom(sourceLayer);
        Main.map.mapView.removeLayer(sourceLayer);
        Main.map.mapView.setActiveLayer(targetLayer);
    }

    public void actionPerformed(ActionEvent e) {
        OsmDataLayer sourceLayer = Main.main.getEditLayer();
        if (sourceLayer == null) {
            return;
        }
        this.merge(sourceLayer);
    }

    protected void updateEnabledState() {
        if (this.getEditLayer() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(this.getEditLayer()).isEmpty());
    }
}

