/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes"), "mergenodes", I18n.tr("Merge nodes into the oldest one."), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes")), 77, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        Set<Node> selectedNodes = OsmPrimitive.getFilteredSet(selection, Node.class);
        if (selectedNodes.size() < 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two nodes to merge."), I18n.tr("Warning"), 2);
            return;
        }
        Node targetNode = MergeNodesAction.selectTargetNode(selectedNodes);
        Command cmd = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), selectedNodes, targetNode);
        if (cmd != null) {
            Main.main.undoRedo.add(cmd);
            Main.main.getEditLayer().data.setSelected(targetNode);
        }
    }

    public static Node selectTargetNode(Collection<Node> candidates) {
        Node targetNode = null;
        for (Node n : candidates) {
            if (n.isNew()) continue;
            targetNode = n;
            break;
        }
        if (targetNode == null) {
            targetNode = candidates.iterator().next();
        }
        return targetNode;
    }

    public static Command mergeNodes(OsmDataLayer layer, Collection<Node> nodes, Node targetNode) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "nodes"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "targetNode"));
        }
        if (nodes == null) {
            return null;
        }
        nodes.remove(null);
        BackreferencedDataSet backreferences = new BackreferencedDataSet(layer.data);
        backreferences.build();
        return MergeNodesAction.mergeNodes(layer, backreferences, nodes, targetNode);
    }

    protected static List<Command> fixParentWays(BackreferencedDataSet backreferences, Collection<OsmPrimitive> nodesToDelete, Node targetNode) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        HashSet<Way> waysToDelete = new HashSet<Way>();
        for (Way w : OsmPrimitive.getFilteredList(backreferences.getParents(nodesToDelete), Way.class)) {
            ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
            for (Node n : w.getNodes()) {
                if (!nodesToDelete.contains(n) && n != targetNode) {
                    newNodes.add(n);
                    continue;
                }
                if (newNodes.isEmpty()) {
                    newNodes.add(targetNode);
                    continue;
                }
                if (newNodes.get(newNodes.size() - 1) == targetNode) continue;
                newNodes.add(targetNode);
            }
            if (newNodes.size() < 2) {
                if (backreferences.getParents(w).isEmpty()) {
                    waysToDelete.add(w);
                    continue;
                }
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot merge nodes: Would have to delete a way that is still used."), I18n.tr("Warning"), 2);
                return null;
            }
            if (newNodes.size() < 2 && backreferences.getParents(w).isEmpty()) {
                waysToDelete.add(w);
                continue;
            }
            Way newWay = new Way(w);
            newWay.setNodes(newNodes);
            cmds.add(new ChangeCommand(w, newWay));
        }
        return cmds;
    }

    public static Command mergeNodes(OsmDataLayer layer, BackreferencedDataSet backreferences, Collection<Node> nodes, Node targetNode) {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "nodes"));
        }
        if (targetNode == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "targetNode"));
        }
        if (nodes == null) {
            return null;
        }
        if (backreferences == null) {
            backreferences = new BackreferencedDataSet(layer.data);
            backreferences.build();
        }
        Set<BackreferencedDataSet.RelationToChildReference> relationToNodeReferences = backreferences.getRelationToChildReferences(nodes);
        TagCollection nodeTags = TagCollection.unionOfAllPrimitives(nodes);
        TagConflictResolutionUtil.combineTigerTags(nodeTags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(nodeTags, nodes);
        TagCollection nodeTagsToEdit = new TagCollection(nodeTags);
        TagConflictResolutionUtil.completeTagCollectionForEditing(nodeTagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(nodeTagsToEdit, nodeTags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate(relationToNodeReferences);
        dialog.setTargetPrimitive(targetNode);
        dialog.prepareDefaultDecisions();
        if (!nodeTags.isApplicableToPrimitive() || relationToNodeReferences.size() > 1) {
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return null;
            }
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        HashSet<OsmPrimitive> nodesToDelete = new HashSet<OsmPrimitive>(nodes);
        nodesToDelete.remove(targetNode);
        HashSet waysToDelete = new HashSet();
        List<Command> wayFixCommands = MergeNodesAction.fixParentWays(backreferences, nodesToDelete, targetNode);
        if (wayFixCommands == null) {
            return null;
        }
        cmds.addAll(wayFixCommands);
        if (!nodesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(nodesToDelete));
        }
        if (!waysToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(waysToDelete));
        }
        cmds.addAll(dialog.buildResolutionCommands());
        SequenceCommand cmd = new SequenceCommand(I18n.tr("Merge {0} nodes", nodes.size()), cmds);
        return cmd;
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        if (selection == null || selection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean ok = true;
        if (selection.size() < 2) {
            this.setEnabled(false);
            return;
        }
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) continue;
            ok = false;
            break;
        }
        this.setEnabled(ok);
    }
}

