/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthogonalizeAction
extends JosmAction {
    String USAGE = "<h3>When one or more ways are selected, the shape is adjusted, such that all angles are 90 or 180 degrees.<h3>You can add two nodes to the selection. Then the direction is fixed by these two reference nodes.<h3>(Afterwards, you can undo the movement for certain nodes:<br>Select them and press the shortcut for Orthogonalize / Undo. The default is Shift-Q.)";
    private static final double TOLERANCE1 = Math.toRadians(35.0);
    private static final double TOLERANCE2 = Math.toRadians(35.0);
    private static final HashMap<Node, EastNorth> rememberMovements = new HashMap();

    public OrthogonalizeAction() {
        super(I18n.tr("Orthogonalize Shape"), "ortho", I18n.tr("Move nodes so all angles are 90 or 270 degree"), Shortcut.registerShortcut("tools:orthogonalize", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape")), 81, 3), true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block11: {
            String msg;
            if (!this.isEnabled()) {
                return;
            }
            if ("EPSG:4326".equals(Main.proj.toString()) && !ConditionalOptionPaneUtil.showConfirmationDialog("align_rectangular_4326", Main.parent, msg = I18n.tr("<html>You are using the EPSG:4326 projection which might lead<br>to undesirable results when doing rectangular alignments.<br>Change your projection to get rid of this warning.<br>Do you want to continue?</html>"), I18n.tr("Warning"), 0, 3, 0)) {
                return;
            }
            ArrayList<Node> nodeList = new ArrayList<Node>();
            ArrayList<WayData> wayDataList = new ArrayList<WayData>();
            Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
            try {
                for (OsmPrimitive p : sel) {
                    if (p instanceof Node) {
                        nodeList.add((Node)p);
                        continue;
                    }
                    if (p instanceof Way) {
                        wayDataList.add(new WayData((Way)p));
                        continue;
                    }
                    throw new InvalidUserInputException("Selection must consist only of ways and nodes.");
                }
                if (wayDataList.isEmpty()) {
                    throw new InvalidUserInputException("usage");
                }
                if (nodeList.size() == 2) {
                    OrthogonalizeAction.orthogonalize(wayDataList, nodeList);
                    break block11;
                }
                if (nodeList.isEmpty()) {
                    OrthogonalizeAction.orthogonalize(wayDataList, nodeList);
                    break block11;
                }
                throw new InvalidUserInputException("usage");
            }
            catch (InvalidUserInputException ex) {
                if (ex.getMessage().equals("usage")) {
                    JOptionPane.showMessageDialog(Main.parent, "<html><h2>" + I18n.tr("Usage") + I18n.tr(this.USAGE), I18n.tr("Orthogonalize Shape"), 1);
                }
                JOptionPane.showMessageDialog(Main.parent, "<html><h3>" + I18n.tr(ex.getMessage()) + "<br><hr><h3>" + I18n.tr("Usage") + I18n.tr(this.USAGE), I18n.tr("Selected Elements cannot be orthogonalized"), 1);
            }
        }
    }

    private static void orthogonalize(ArrayList<WayData> wayDataList, ArrayList<Node> headingNodes) throws InvalidUserInputException {
        Direction[][] ORIENTATIONS;
        double headingAll;
        try {
            if (headingNodes.isEmpty()) {
                wayDataList.get(0).calcDirections(Direction.RIGHT);
                double refHeading = wayDataList.get((int)0).heading;
                for (WayData w : wayDataList) {
                    w.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(w.heading - refHeading, TOLERANCE2);
                    w.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                    if (OrthogonalizeAction.angleToDirectionChange(refHeading - w.heading, TOLERANCE2) == 0) continue;
                    throw new RuntimeException();
                }
                EastNorth totSum = new EastNorth(0.0, 0.0);
                for (WayData w : wayDataList) {
                    totSum = EN.sum(totSum, w.segSum);
                }
                headingAll = EN.polar(new EastNorth(0.0, 0.0), totSum);
            } else {
                headingAll = EN.polar(headingNodes.get(0).getEastNorth(), headingNodes.get(1).getEastNorth());
                for (WayData w : wayDataList) {
                    w.calcDirections(Direction.RIGHT);
                    int directionOffset = OrthogonalizeAction.angleToDirectionChange(w.heading - headingAll, TOLERANCE2);
                    w.calcDirections(Direction.RIGHT.changeBy(directionOffset));
                }
            }
        }
        catch (RejectedAngleException ex) {
            throw new InvalidUserInputException("<html>Please make sure all selected ways head in a similar direction<br>or orthogonalize them one by one.");
        }
        HashSet<Node> allNodes = new HashSet<Node>();
        for (WayData w : wayDataList) {
            for (Node n : w.way.getNodes()) {
                allNodes.add(n);
            }
        }
        HashMap<Node, Double> nX = new HashMap<Node, Double>();
        HashMap<Node, Double> nY = new HashMap<Node, Double>();
        EastNorth pivot = new EastNorth(0.0, 0.0);
        for (Node n : allNodes) {
            pivot = EN.sum(pivot, n.getEastNorth());
        }
        pivot = new EastNorth(pivot.east() / (double)allNodes.size(), pivot.north() / (double)allNodes.size());
        for (Node n : allNodes) {
            EastNorth tmp = EN.rotate_cc(pivot, n.getEastNorth(), -headingAll);
            nX.put(n, tmp.east());
            nY.put(n, tmp.north());
        }
        Direction[] HORIZONTAL = new Direction[]{Direction.RIGHT, Direction.LEFT};
        Direction[] VERTICAL = new Direction[]{Direction.UP, Direction.DOWN};
        for (Direction[] orientation : ORIENTATIONS = new Direction[][]{HORIZONTAL, VERTICAL}) {
            HashSet s = new HashSet(allNodes);
            int s_size = s.size();
            for (int dummy = 0; dummy < s_size && !s.isEmpty(); ++dummy) {
                Node dummy_n = (Node)s.iterator().next();
                HashSet<Node> cs = new HashSet<Node>();
                cs.add(dummy_n);
                boolean somethingHappened = true;
                while (somethingHappened) {
                    somethingHappened = false;
                    for (WayData w : wayDataList) {
                        for (int i = 0; i < w.nSeg; ++i) {
                            Node n1 = w.way.getNodes().get(i);
                            Node n2 = w.way.getNodes().get(i + 1);
                            if (!Arrays.asList(orientation).contains((Object)w.segDirections[i])) continue;
                            if (cs.contains(n1) && !cs.contains(n2)) {
                                cs.add(n2);
                                somethingHappened = true;
                            }
                            if (!cs.contains(n2) || cs.contains(n1)) continue;
                            cs.add(n1);
                            somethingHappened = true;
                        }
                    }
                }
                HashMap<Node, Double> nC = orientation == HORIZONTAL ? nY : nX;
                double average = 0.0;
                for (Node n : cs) {
                    average += ((Double)nC.get(n)).doubleValue();
                }
                average /= (double)cs.size();
                for (Node fn : headingNodes) {
                    if (!cs.contains(fn)) continue;
                    average = (Double)nC.get(fn);
                }
                for (Node n : cs) {
                    nC.put(n, average);
                }
                for (Node n : cs) {
                    s.remove(n);
                }
            }
            if (s.isEmpty()) continue;
            throw new RuntimeException();
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        rememberMovements.clear();
        for (Node n : allNodes) {
            EastNorth tmp = new EastNorth((Double)nX.get(n), (Double)nY.get(n));
            tmp = EN.rotate_cc(pivot, tmp, headingAll);
            double dx = tmp.east() - n.getEastNorth().east();
            double dy = tmp.north() - n.getEastNorth().north();
            if (headingNodes.contains(n)) {
                double EPSILON = 1.0E-6;
                if (Math.abs(dx) > Math.abs(1.0E-6 * tmp.east()) || Math.abs(dy) > Math.abs(1.0E-6 * tmp.east())) {
                    throw new AssertionError();
                }
                continue;
            }
            rememberMovements.put(n, new EastNorth(dx, dy));
            commands.add(new MoveCommand(n, dx, dy));
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize"), commands));
        Main.map.repaint();
    }

    private static double standard_angle_0_to_2PI(double a) {
        while (a >= Math.PI * 2) {
            a -= Math.PI * 2;
        }
        while (a < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static double standard_angle_mPI_to_PI(double a) {
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    private static int angleToDirectionChange(double a, double deltaMax) throws RejectedAngleException {
        int dirChange;
        a = OrthogonalizeAction.standard_angle_mPI_to_PI(a);
        double d0 = Math.abs(a);
        double d90 = Math.abs(a - 1.5707963267948966);
        double d_m90 = Math.abs(a + 1.5707963267948966);
        if (d0 < deltaMax) {
            dirChange = 0;
        } else if (d90 < deltaMax) {
            dirChange = 1;
        } else if (d_m90 < deltaMax) {
            dirChange = -1;
        } else {
            double d180 = Math.abs((a = OrthogonalizeAction.standard_angle_0_to_2PI(a)) - Math.PI);
            if (d180 < deltaMax) {
                dirChange = 2;
            } else {
                throw new RejectedAngleException();
            }
        }
        return dirChange;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null);
    }

    private static class RejectedAngleException
    extends Exception {
        RejectedAngleException() {
        }
    }

    private static class InvalidUserInputException
    extends Exception {
        InvalidUserInputException(String message) {
            super(message);
        }

        InvalidUserInputException() {
        }
    }

    private static class EN {
        private EN() {
        }

        public static EastNorth rotate_cc(EastNorth pivot, EastNorth en, double angle) {
            double cosPhi = Math.cos(angle);
            double sinPhi = Math.sin(angle);
            double x = en.east() - pivot.east();
            double y = en.north() - pivot.north();
            double nx = cosPhi * x - sinPhi * y + pivot.east();
            double ny = sinPhi * x + cosPhi * y + pivot.north();
            return new EastNorth(nx, ny);
        }

        public static EastNorth sum(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() + en2.east(), en1.north() + en2.north());
        }

        public static EastNorth diff(EastNorth en1, EastNorth en2) {
            return new EastNorth(en1.east() - en2.east(), en1.north() - en2.north());
        }

        public static double abs(EastNorth en) {
            return Math.sqrt(en.east() * en.east() + en.north() * en.north());
        }

        public static String toString(EastNorth en) {
            return "[" + EN.u(en.east()) + "," + EN.u(en.north()) + "]";
        }

        public static long u(double d) {
            return Math.round(d * 1000000.0);
        }

        public static double polar(EastNorth en1, EastNorth en2) {
            return Math.atan2(en2.north() - en1.north(), en2.east() - en1.east());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        RIGHT,
        UP,
        LEFT,
        DOWN;


        public Direction changeBy(int directionChange) {
            int tmp = (this.ordinal() + directionChange) % 4;
            if (tmp < 0) {
                tmp += 4;
            }
            return Direction.values()[tmp];
        }
    }

    private static class WayData {
        public final Way way;
        public final int nSeg;
        public final int nNode;
        public Direction[] segDirections;
        public EastNorth segSum;
        public double heading;

        public WayData(Way pWay) {
            this.way = pWay;
            this.nNode = this.way.getNodes().size();
            this.nSeg = this.nNode - 1;
        }

        public void calcDirections(Direction pInitialDirection) throws InvalidUserInputException {
            Direction direction;
            EastNorth[] en = new EastNorth[this.nNode];
            for (int i = 0; i < this.nNode; ++i) {
                en[i] = new EastNorth(this.way.getNodes().get(i).getEastNorth().east(), this.way.getNodes().get(i).getEastNorth().north());
            }
            this.segDirections = new Direction[this.nSeg];
            this.segDirections[0] = direction = pInitialDirection;
            for (int i = 0; i < this.nSeg - 1; ++i) {
                double h1 = EN.polar(en[i], en[i + 1]);
                double h2 = EN.polar(en[i + 1], en[i + 2]);
                try {
                    direction = direction.changeBy(OrthogonalizeAction.angleToDirectionChange(h2 - h1, TOLERANCE1));
                }
                catch (RejectedAngleException ex) {
                    throw new InvalidUserInputException("Please select ways with angles of approximately 90 or 180 degrees.");
                }
                this.segDirections[i + 1] = direction;
            }
            EastNorth h = new EastNorth(0.0, 0.0);
            double lh = EN.abs(h);
            EastNorth v = new EastNorth(0.0, 0.0);
            double lv = EN.abs(v);
            for (int i = 0; i < this.nSeg; ++i) {
                EastNorth segment = EN.diff(en[i + 1], en[i]);
                if (this.segDirections[i] == Direction.RIGHT) {
                    h = EN.sum(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.UP) {
                    v = EN.sum(v, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.LEFT) {
                    h = EN.diff(h, segment);
                    continue;
                }
                if (this.segDirections[i] == Direction.DOWN) {
                    v = EN.diff(v, segment);
                    continue;
                }
                throw new IllegalStateException();
            }
            this.segSum = EN.sum(h, new EastNorth(v.north(), -v.east()));
            this.heading = EN.polar(new EastNorth(0.0, 0.0), this.segSum);
        }
    }

    public class Undo
    extends JosmAction {
        public Undo() {
            super(I18n.tr("Orthogonalize Shape / Undo"), "ortho", I18n.tr("Undo orthogonalization for certain nodes"), Shortcut.registerShortcut("tools:orthogonalizeUndo", I18n.tr("Tool: {0}", I18n.tr("Orthogonalize Shape / Undo")), 81, 3, 1), true);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            LinkedList<Command> commands = new LinkedList<Command>();
            Collection<OsmPrimitive> sel = this.getCurrentDataSet().getSelected();
            try {
                for (OsmPrimitive p : sel) {
                    if (!(p instanceof Node)) {
                        throw new InvalidUserInputException();
                    }
                    Node n = (Node)p;
                    if (!rememberMovements.containsKey(n)) continue;
                    EastNorth tmp = (EastNorth)rememberMovements.get(n);
                    commands.add(new MoveCommand(n, -tmp.east(), -tmp.north()));
                    rememberMovements.remove(n);
                }
                if (commands.size() <= 0) {
                    throw new InvalidUserInputException();
                }
                Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Orthogonalize / Undo"), commands));
                Main.map.repaint();
            }
            catch (InvalidUserInputException ex) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Orthogonalize Shape / Undo\nPlease select nodes that were moved by the previous Orthogonalize Shape action!"), I18n.tr("Undo Orthogonalize Shape"), 1);
            }
        }
    }
}

