/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteAction
extends JosmAction {
    public PasteAction() {
        super(I18n.tr("Paste"), "paste", I18n.tr("Paste contents of paste buffer."), Shortcut.registerShortcut("system:paste", I18n.tr("Edit: {0}", I18n.tr("Paste")), 86, 2), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.pasteData(Main.pasteBuffer, Main.pasteSource, e);
    }

    public void pasteData(PrimitiveDeepCopy pasteBuffer, Layer source, ActionEvent e) {
        double maxEast = -1.0E100;
        double minEast = 1.0E100;
        double maxNorth = -1.0E100;
        double minNorth = 1.0E100;
        for (PrimitiveData data : pasteBuffer.getAll()) {
            if (!(data instanceof NodeData)) continue;
            NodeData n = (NodeData)data;
            double east = n.getEastNorth().east();
            double north = n.getEastNorth().north();
            if (east > maxEast) {
                maxEast = east;
            }
            if (east < minEast) {
                minEast = east;
            }
            if (north > maxNorth) {
                maxNorth = north;
            }
            if (!(north < minNorth)) continue;
            minNorth = north;
        }
        EastNorth mPosition = (e.getModifiers() & 2) == 0 ? Main.map.mapView.getCenter() : (Main.map.mapView.lastMEvent != null ? Main.map.mapView.getEastNorth(Main.map.mapView.lastMEvent.getX(), Main.map.mapView.lastMEvent.getY()) : Main.map.mapView.getCenter());
        double offsetEast = mPosition.east() - (maxEast + minEast) / 2.0;
        double offsetNorth = mPosition.north() - (maxNorth + minNorth) / 2.0;
        ArrayList<PrimitiveData> bufferCopy = new ArrayList<PrimitiveData>();
        HashMap<Long, Long> newIds = new HashMap<Long, Long>();
        for (PrimitiveData data : pasteBuffer.getAll()) {
            PrimitiveData copy = data.makeCopy();
            copy.clearOsmId();
            newIds.put(data.getId(), copy.getId());
            bufferCopy.add(copy);
        }
        for (PrimitiveData data : bufferCopy) {
            ListIterator<Object> it;
            if (data instanceof NodeData) {
                NodeData nodeData = (NodeData)data;
                if (Main.map.mapView.getEditLayer() != source) continue;
                nodeData.setEastNorth(nodeData.getEastNorth().add(offsetEast, offsetNorth));
                continue;
            }
            if (data instanceof WayData) {
                it = ((WayData)data).getNodes().listIterator();
                while (it.hasNext()) {
                    it.set(newIds.get(it.next()));
                }
                continue;
            }
            if (!(data instanceof RelationData)) continue;
            it = ((RelationData)data).getMembers().listIterator();
            while (it.hasNext()) {
                RelationMemberData member = (RelationMemberData)it.next();
                it.set(new RelationMemberData(member.getRole(), member.getMemberType(), (Long)newIds.get(member.getMemberId())));
            }
        }
        Main.main.undoRedo.add(new AddPrimitivesCommand(bufferCopy));
        Main.map.mapView.repaint();
    }

    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!Main.pasteBuffer.isEmpty());
    }
}

