/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasteTagsAction
extends JosmAction {
    public PasteTagsAction(JosmAction copyAction) {
        super(I18n.tr("Paste Tags"), "pastetags", I18n.tr("Apply tags of contents of paste buffer to all selected items."), Shortcut.registerShortcut("system:pastestyle", I18n.tr("Edit: {0}", I18n.tr("Paste Tags")), 86, 2, 1), true);
        copyAction.addListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getCurrentDataSet().getSelected().isEmpty()) {
            return;
        }
        TagPaster tagPaster = new TagPaster(Main.pasteBuffer.getDirectlyAdded(), this.getCurrentDataSet().getSelected());
        for (Command c : tagPaster.execute()) {
            Main.main.undoRedo.add(c);
        }
    }

    @Override
    public void pasteBufferChanged(PrimitiveDeepCopy newPasteBuffer) {
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!this.getCurrentDataSet().getSelected().isEmpty() && !TagCollection.unionOfAllPrimitives(Main.pasteBuffer.getDirectlyAdded()).isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty() && !TagCollection.unionOfAllPrimitives(Main.pasteBuffer.getDirectlyAdded()).isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagPaster {
        private final Collection<PrimitiveData> source;
        private final Collection<OsmPrimitive> target;
        private final List<Command> commands = new ArrayList<Command>();

        public TagPaster(Collection<PrimitiveData> source, Collection<OsmPrimitive> target) {
            this.source = source;
            this.target = target;
        }

        protected boolean isHeteogeneousSource() {
            int count = 0;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.NODE).isEmpty() ? count + 1 : count;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.WAY).isEmpty() ? count + 1 : count;
            count = !this.getSourcePrimitivesByType(OsmPrimitiveType.RELATION).isEmpty() ? count + 1 : count;
            return count > 1;
        }

        protected <T extends PrimitiveData> Collection<? extends PrimitiveData> getSourcePrimitivesByType(OsmPrimitiveType type) {
            return PrimitiveData.getFilteredList(this.source, type);
        }

        protected <T extends OsmPrimitive> TagCollection getSourceTagsByType(OsmPrimitiveType type) {
            return TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(type));
        }

        protected <T extends OsmPrimitive> boolean hasSourceTagsByType(OsmPrimitiveType type) {
            return !this.getSourceTagsByType(type).isEmpty();
        }

        protected Command buildChangeCommand(Collection<? extends OsmPrimitive> selection, TagCollection tc) {
            ArrayList<Command> commands = new ArrayList<Command>();
            for (String key : tc.getKeys()) {
                String value = tc.getValues(key).iterator().next();
                value = value.equals("") ? null : value;
                commands.add(new ChangePropertyCommand(selection, key, value));
            }
            if (!commands.isEmpty()) {
                String title1 = I18n.trn("Pasting {0} tag", "Pasting {0} tags", tc.getKeys().size(), tc.getKeys().size());
                String title2 = I18n.trn("to {0} primitive", "to {0} primtives", selection.size(), selection.size());
                return new SequenceCommand(title1 + " " + title2, commands);
            }
            return null;
        }

        protected Map<OsmPrimitiveType, Integer> getSourceStatistics() {
            HashMap<OsmPrimitiveType, Integer> ret = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                if (this.getSourceTagsByType(type).isEmpty()) continue;
                ret.put(type, this.getSourcePrimitivesByType(type).size());
            }
            return ret;
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            HashMap<OsmPrimitiveType, Integer> ret = new HashMap<OsmPrimitiveType, Integer>();
            for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                int count = OsmPrimitive.getFilteredList(this.target, type.getOsmClass()).size();
                if (count <= 0) continue;
                ret.put(type, count);
            }
            return ret;
        }

        protected void pasteFromHomogeneousSource() {
            TagCollection tc = null;
            for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                TagCollection tc1 = this.getSourceTagsByType(type);
                if (tc1.isEmpty()) continue;
                tc = tc1;
            }
            if (tc == null) {
                return;
            }
            if (!tc.isApplicableToPrimitive()) {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog(Main.parent);
                dialog.populate(tc, this.getSourceStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                Command cmd = this.buildChangeCommand(this.target, dialog.getResolution());
                this.commands.add(cmd);
            } else {
                Command cmd = this.buildChangeCommand(this.target, tc);
                this.commands.add(cmd);
            }
        }

        protected <T extends OsmPrimitive> boolean hasTargetPrimitives(Class<T> type) {
            return !OsmPrimitive.getFilteredList(this.target, type).isEmpty();
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict(Collection<OsmPrimitive> targets) {
            for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                TagCollection tc;
                if (!this.hasTargetPrimitives(type.getOsmClass()) || (tc = TagCollection.unionOfAllPrimitives(this.getSourcePrimitivesByType(type))).isEmpty() || tc.isApplicableToPrimitive()) continue;
                return false;
            }
            return true;
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict(this.target)) {
                for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                    if (!this.hasSourceTagsByType(type) || !this.hasTargetPrimitives(type.getOsmClass())) continue;
                    Command cmd = this.buildChangeCommand(this.target, this.getSourceTagsByType(type));
                    this.commands.add(cmd);
                }
            } else {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog(Main.parent);
                dialog.populate(this.getSourceTagsByType(OsmPrimitiveType.NODE), this.getSourceTagsByType(OsmPrimitiveType.WAY), this.getSourceTagsByType(OsmPrimitiveType.RELATION), this.getSourceStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType type : OsmPrimitiveType.values()) {
                    if (!this.hasSourceTagsByType(type) || !this.hasTargetPrimitives(type.getOsmClass())) continue;
                    Command cmd = this.buildChangeCommand(OsmPrimitive.getFilteredList(this.target, type.getOsmClass()), dialog.getResolution(type));
                    this.commands.add(cmd);
                }
            }
        }

        public List<Command> execute() {
            this.commands.clear();
            if (this.isHeteogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.commands;
        }
    }
}

