/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class PreferencesAction
extends JosmAction
implements Runnable {
    public PreferencesAction() {
        super(I18n.tr("Preferences..."), "preference", I18n.tr("Open a preferences page for global settings."), Shortcut.registerShortcut("system:preferences", I18n.tr("Preferences"), 123, 5), true);
    }

    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    public void run() {
        int targetHeight;
        int targetWidth;
        PreferenceDialog prefDlg = new PreferenceDialog();
        prefDlg.setMinimumSize(new Dimension(400, 300));
        JPanel prefPanel = new JPanel(new GridBagLayout());
        prefPanel.add((Component)prefDlg, GBC.eol().fill(1));
        JOptionPane pane = new JOptionPane(prefPanel, -1, 2);
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr("Preferences"));
        dlg.setResizable(true);
        dlg.setMinimumSize(new Dimension(500, 400));
        int JOSMWidth = Main.parent.getWidth();
        int JOSMHeight = Main.parent.getHeight();
        if (JOSMWidth > 2000 && JOSMWidth > JOSMHeight * 2) {
            JOSMWidth /= 2;
        }
        if ((targetWidth = JOSMWidth / 2) < 600) {
            targetWidth = 600;
        }
        if (targetWidth > 1200) {
            targetWidth = 1200;
        }
        if ((targetHeight = JOSMHeight * 3 / 4) < 600) {
            targetHeight = 600;
        }
        if (targetHeight > 1200) {
            targetHeight = 1200;
        }
        int targetX = Main.parent.getX() + JOSMWidth / 2 - targetWidth / 2;
        int targetY = Main.parent.getY() + JOSMHeight / 2 - targetHeight / 2;
        dlg.setBounds(targetX, targetY, targetWidth, targetHeight);
        dlg.setModal(true);
        dlg.setVisible(true);
        if (pane.getValue() instanceof Integer && (Integer)pane.getValue() == 0) {
            prefDlg.ok();
        }
        dlg.dispose();
    }
}

