/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSelectionAction
extends JosmAction {
    protected void handlePrimitiveGoneException(long id, OsmPrimitiveType type) {
        MultiFetchServerObjectReader reader = new MultiFetchServerObjectReader();
        reader.append(this.getCurrentDataSet(), id, type);
        DataSet ds = null;
        try {
            ds = reader.parseOsm(NullProgressMonitor.INSTANCE);
        }
        catch (Exception e) {
            ExceptionDialogUtil.explainException(e);
        }
        Main.map.mapView.getEditLayer().mergeFrom(ds);
    }

    public void updatePrimitives(Collection<OsmPrimitive> selection) {
        UpdatePrimitivesTask task = new UpdatePrimitivesTask(selection);
        Main.worker.submit(task);
    }

    public void updatePrimitive(OsmPrimitiveType type, long id) throws IllegalStateException {
        if (this.getEditLayer() == null) {
            throw new IllegalStateException(I18n.tr("No current dataset found"));
        }
        OsmPrimitive primitive = this.getEditLayer().data.getPrimitiveById(id, type);
        if (primitive == null) {
            throw new IllegalStateException(I18n.tr("Didn''t find an object with id {0} in the current dataset", id));
        }
        this.updatePrimitives(Collections.singleton(primitive));
    }

    public UpdateSelectionAction() {
        super(I18n.tr("Update selections"), "updateselection", I18n.tr("Updates the currently selected objects from the server (re-downloads data)"), Shortcut.registerShortcut("file:updateselection", I18n.tr("Update Selection"), 85, 15), true);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
        if (selection.size() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("There are no selected primitives to update."), I18n.tr("Selection empty"), 1);
            return;
        }
        this.updatePrimitives(selection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdatePrimitivesTask
    extends PleaseWaitRunnable {
        private DataSet ds;
        private boolean canceled = false;
        private Exception lastException;
        private Collection<? extends OsmPrimitive> toUpdate;
        private MultiFetchServerObjectReader reader;

        public UpdatePrimitivesTask(Collection<? extends OsmPrimitive> toUpdate) {
            super("Update primitives", false);
            this.toUpdate = toUpdate;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.ds != null) {
                Main.map.mapView.getEditLayer().mergeFrom(this.ds);
            }
        }

        protected void initMultiFetchReaderWithNodes(MultiFetchServerObjectReader reader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (osmPrimitive instanceof Node && !osmPrimitive.isNew()) {
                    reader.append((Node)osmPrimitive);
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                Way way = (Way)osmPrimitive;
                for (Node node : way.getNodes()) {
                    if (node.isNew()) continue;
                    reader.append(node);
                }
            }
        }

        protected void initMultiFetchReaderWithWays(MultiFetchServerObjectReader reader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (!(osmPrimitive instanceof Way) || osmPrimitive.isNew()) continue;
                reader.append((Way)osmPrimitive);
            }
        }

        protected void initMultiFetchReaderWithRelations(MultiFetchServerObjectReader reader) {
            for (OsmPrimitive osmPrimitive : this.toUpdate) {
                if (!(osmPrimitive instanceof Relation) || osmPrimitive.isNew()) continue;
                reader.append((Relation)osmPrimitive);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            this.progressMonitor.indeterminateSubTask("");
            this.ds = new DataSet();
            try {
                this.reader = new MultiFetchServerObjectReader();
                this.initMultiFetchReaderWithNodes(this.reader);
                this.initMultiFetchReaderWithWays(this.reader);
                this.initMultiFetchReaderWithRelations(this.reader);
                DataSet theirDataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                MergeVisitor merger = new MergeVisitor(this.ds, theirDataSet);
                merger.merge();
                for (Way w : this.ds.ways) {
                    if (!w.incomplete) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(w.getId(), OsmPrimitiveType.WAY, true);
                    theirDataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    merger = new MergeVisitor(this.ds, theirDataSet);
                    merger.merge();
                }
            }
            catch (Exception e) {
                if (this.canceled) {
                    return;
                }
                this.lastException = e;
            }
        }
    }
}

