/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.EventQueue;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTaskList
implements Runnable {
    private List<DownloadDialog.DownloadTask> osmTasks = new LinkedList<DownloadDialog.DownloadTask>();
    private ProgressMonitor progressMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(boolean newLayer, List<Rectangle2D> rects, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (newLayer) {
            OsmDataLayer l = new OsmDataLayer(new DataSet(), OsmDataLayer.createNewName(), null);
            Main.main.addLayer(l);
            Main.map.mapView.setActiveLayer(l);
        }
        progressMonitor.beginTask(null, rects.size());
        try {
            int i = 0;
            for (Rectangle2D td : rects) {
                DownloadOsmTask dt = new DownloadOsmTask();
                ProgressMonitor childProgress = progressMonitor.createSubTaskMonitor(1, false);
                childProgress.setSilent(true);
                childProgress.setCustomText(I18n.tr("Download {0} of {1} ({2} left)", ++i, rects.size(), rects.size() - i));
                dt.download(null, td.getMinY(), td.getMinX(), td.getMaxY(), td.getMaxX(), childProgress);
                this.osmTasks.add(dt);
            }
        }
        finally {
            Main.worker.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(boolean newLayer, Collection<Area> areas, ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Updating data"));
        try {
            LinkedList<Rectangle2D> rects = new LinkedList<Rectangle2D>();
            for (Area a : areas) {
                rects.add(a.getBounds2D());
            }
            this.download(newLayer, (List<Rectangle2D>)rects, progressMonitor.createSubTaskMonitor(-1, false));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public void run() {
        this.progressMonitor.finishTask();
        String errors = "";
        LinkedList<Integer> shown = new LinkedList<Integer>();
        for (DownloadDialog.DownloadTask dt : this.osmTasks) {
            String err = dt.getErrorMessage();
            if (err.equals("") || shown.contains(err.hashCode())) continue;
            shown.add(err.hashCode());
            errors = errors + "<br>* " + err;
        }
        if (!errors.equals("")) {
            JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("The following errors occurred during mass download:{0}", errors) + "</html>", I18n.tr("Errors during Download"), 0);
            return;
        }
        for (DownloadDialog.DownloadTask task : this.osmTasks) {
            DownloadOsmTask osmTask;
            if (!(task instanceof DownloadOsmTask) || !(osmTask = (DownloadOsmTask)task).isCanceled() && !osmTask.isFailed()) continue;
            return;
        }
        OsmDataLayer editLayer = Main.map.mapView.getEditLayer();
        if (editLayer != null) {
            Set<OsmPrimitive> myPrimitives = this.getCompletePrimitives(editLayer.data);
            for (DownloadDialog.DownloadTask task : this.osmTasks) {
                DataSet ds;
                if (!(task instanceof DownloadOsmTask) || (ds = ((DownloadOsmTask)task).getDownloadedData()) == null) continue;
                myPrimitives.removeAll(ds.nodes);
                myPrimitives.removeAll(ds.ways);
                myPrimitives.removeAll(ds.relations);
            }
            if (!myPrimitives.isEmpty()) {
                this.handlePotentiallyDeletedPrimitives(myPrimitives);
            }
        }
    }

    protected Set<OsmPrimitive> getCompletePrimitives(DataSet ds) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : ds.nodes) {
            if (osmPrimitive.incomplete || !osmPrimitive.isNew()) continue;
            ret.add(osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : ds.ways) {
            if (osmPrimitive.incomplete || !osmPrimitive.isNew()) continue;
            ret.add(osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : ds.relations) {
            if (osmPrimitive.incomplete || !osmPrimitive.isNew()) continue;
            ret.add(osmPrimitive);
        }
        return ret;
    }

    protected void updatePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        final ArrayList<OsmPrimitive> toSelect = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive primitive : potentiallyDeleted) {
            if (primitive == null) continue;
            toSelect.add(primitive);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new UpdateSelectionAction().updatePrimitives(toSelect);
            }
        });
    }

    protected void handlePotentiallyDeletedPrimitives(Set<OsmPrimitive> potentiallyDeleted) {
        Object[] options = new String[]{"Check on the server", "Ignore"};
        String message = I18n.tr("<html>There are {0} primitives in your local dataset which<br>might be deleted on the server. If you later try to delete or<br>update them the server is likely to report a<br>conflict.<br><br>Click <strong>{1}</strong> to check the state of these primitives<br>on the server.<br>Click <strong>{2}</strong> to ignore.<br></html>", potentiallyDeleted.size(), options[0], options[1]);
        int ret = JOptionPane.showOptionDialog(Main.parent, message, I18n.tr("Deleted or moved primitives"), 0, 2, null, options, options[0]);
        switch (ret) {
            case -1: {
                return;
            }
            case 1: {
                return;
            }
            case 0: {
                this.updatePotentiallyDeletedPrimitives(potentiallyDeleted);
            }
        }
    }

    public Set<OsmPrimitive> getDownloadedPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (DownloadDialog.DownloadTask task : this.osmTasks) {
            DataSet ds;
            if (!(task instanceof DownloadOsmTask) || (ds = ((DownloadOsmTask)task).getDownloadedData()) == null) continue;
            ret.addAll(ds.nodes);
            ret.addAll(ds.ways);
            ret.addAll(ds.relations);
        }
        return ret;
    }
}

