/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ExtrudeAction
extends MapMode
implements MapViewPaintable {
    private Mode mode = null;
    private long mouseDownTime = 0L;
    private WaySegment selectedSegment = null;
    private Color selectedColor;
    double xoff;
    double yoff;
    double distance;
    private Cursor oldCursor;
    private Point mousePos;
    private Point initialMousePos;
    private int initialMoveDelay = 200;

    public ExtrudeAction(MapFrame mapFrame) {
        super(I18n.tr("Extrude"), "extrude/extrude", I18n.tr("Create areas"), Shortcut.registerShortcut("mapmode:extrude", I18n.tr("Mode: {0}", I18n.tr("Extrude")), 88, 3), mapFrame, ExtrudeAction.getCursor("normal", "rectangle", 0));
        this.putValue("help", "Action/Extrude/Extrude");
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.selectedColor = Main.pref.getColor(I18n.marktr("selected"), Color.red);
    }

    private static Cursor getCursor(String name, String mod, int def) {
        try {
            return ImageProvider.getCursor(name, mod);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(def);
        }
    }

    private void setCursor(Cursor c) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(c);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
    }

    public void mouseDragged(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.EXTRUDE && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if ((e.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.EXTRUDE) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.mousePos == null) {
            this.mousePos = e.getPoint();
            return;
        }
        Main.map.mapView.repaint();
        this.mousePos = e.getPoint();
    }

    public void paint(Graphics g, MapView mv) {
        if (this.selectedSegment != null) {
            Node n1 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
            Node n2 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
            EastNorth en1 = n1.getEastNorth();
            EastNorth en2 = n2.getEastNorth();
            EastNorth en3 = mv.getEastNorth(this.mousePos.x, this.mousePos.y);
            double u = ((en3.east() - en1.east()) * (en2.east() - en1.east()) + (en3.north() - en1.north()) * (en2.north() - en1.north())) / en2.distanceSq(en1);
            EastNorth base = new EastNorth(en1.east() + u * (en2.east() - en1.east()), en1.north() + u * (en2.north() - en1.north()));
            this.distance = Main.proj.eastNorth2latlon(base).greatCircleDistance(Main.proj.eastNorth2latlon(en3));
            Main.map.statusLine.setDist(this.distance);
            this.updateStatusLine();
            this.xoff = en3.east() - base.east();
            this.yoff = en3.north() - base.north();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.selectedColor);
            g2.setStroke(new BasicStroke(3.0f, 1, 1));
            GeneralPath b = new GeneralPath();
            Point p1 = mv.getPoint(en1);
            Point p2 = mv.getPoint(en2);
            Point p3 = mv.getPoint(en1.add(this.xoff, this.yoff));
            Point p4 = mv.getPoint(en2.add(this.xoff, this.yoff));
            b.moveTo(p1.x, p1.y);
            b.lineTo(p3.x, p3.y);
            b.lineTo(p4.x, p4.y);
            b.lineTo(p2.x, p2.y);
            b.lineTo(p1.x, p1.y);
            g2.draw(b);
            g2.setStroke(new BasicStroke(1.0f));
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.mouseDownTime = System.currentTimeMillis();
        this.selectedSegment = Main.map.mapView.getNearestWaySegment(e.getPoint());
        this.mode = this.selectedSegment == null ? Mode.select : Mode.EXTRUDE;
        this.oldCursor = Main.map.mapView.getCursor();
        this.updateStatusLine();
        Main.map.mapView.addTemporaryLayer(this);
        Main.map.mapView.repaint();
        this.mousePos = e.getPoint();
        this.initialMousePos = e.getPoint();
        if (this.selectedSegment != null) {
            this.getCurrentDataSet().setSelected(this.selectedSegment.way);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        this.restoreCursor();
        if (this.selectedSegment == null) {
            return;
        }
        if (this.mousePos.distance(this.initialMousePos) > 10.0) {
            Node n1 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex);
            Node n2 = this.selectedSegment.way.getNode(this.selectedSegment.lowerIndex + 1);
            EastNorth en3 = n2.getEastNorth().add(this.xoff, this.yoff);
            Node n3 = new Node(Main.proj.eastNorth2latlon(en3));
            EastNorth en4 = n1.getEastNorth().add(this.xoff, this.yoff);
            Node n4 = new Node(Main.proj.eastNorth2latlon(en4));
            Way wnew = new Way(this.selectedSegment.way);
            wnew.addNode(this.selectedSegment.lowerIndex + 1, n3);
            wnew.addNode(this.selectedSegment.lowerIndex + 1, n4);
            if (wnew.getNodesCount() == 4) {
                wnew.addNode(n1);
            }
            LinkedList<Command> cmds = new LinkedList<Command>();
            cmds.add(new AddCommand(n4));
            cmds.add(new AddCommand(n3));
            cmds.add(new ChangeCommand(this.selectedSegment.way, wnew));
            SequenceCommand c = new SequenceCommand(I18n.tr("Extrude Way"), cmds);
            Main.main.undoRedo.add(c);
        }
        Main.map.mapView.removeTemporaryLayer(this);
        this.selectedSegment = null;
        this.mode = null;
        this.updateStatusLine();
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.");
        }
        if (this.mode == Mode.EXTRUDE) {
            return I18n.tr("Draw a rectangle of the desired size, then release the mouse button.");
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.");
        }
        return I18n.tr("Drag a way segment to make a rectangle.");
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTRUDE,
        rotate,
        select;

    }
}

