/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.LinkedList;

public class PushbackTokenizer {
    private PushbackReader search;
    private LinkedList<String> pushBackBuf = new LinkedList();

    public PushbackTokenizer(PushbackReader search) {
        this.search = search;
    }

    public String nextToken() {
        if (!this.pushBackBuf.isEmpty()) {
            return this.pushBackBuf.removeLast();
        }
        try {
            int next;
            char c = ' ';
            while (c == ' ' || c == '\t' || c == '\n') {
                next = this.search.read();
                if (next == -1) {
                    return null;
                }
                c = (char)next;
            }
            switch (c) {
                case ':': 
                case '=': {
                    next = this.search.read();
                    if (next == -1 || next == 32 || next == 9) {
                        this.pushBack(" ");
                    } else {
                        this.search.unread(next);
                    }
                    return String.valueOf(c);
                }
                case '-': {
                    return "-";
                }
                case '(': {
                    return "(";
                }
                case ')': {
                    return ")";
                }
                case '|': {
                    return "|";
                }
                case '\"': {
                    StringBuilder s = new StringBuilder(" ");
                    int nc = this.search.read();
                    while (nc != -1 && nc != 34) {
                        s.append((char)nc);
                        nc = this.search.read();
                    }
                    return s.toString();
                }
            }
            StringBuilder s = new StringBuilder();
            do {
                s.append(c);
                next = this.search.read();
                if (next != -1) continue;
                if (s.toString().equals("OR")) {
                    return "|";
                }
                return " " + s.toString();
            } while ((c = (char)next) != ' ' && c != '\t' && c != '\"' && c != ':' && c != '(' && c != ')' && c != '|' && c != 61);
            this.search.unread(next);
            if (s.toString().equals("OR")) {
                return "|";
            }
            return " " + s.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean readIfEqual(String tok) {
        String nextTok = this.nextToken();
        if (nextTok == null ? tok == null : nextTok.equals(tok)) {
            return true;
        }
        this.pushBack(nextTok);
        return false;
    }

    public String readText() {
        String nextTok = this.nextToken();
        if (nextTok != null && nextTok.startsWith(" ")) {
            return nextTok.substring(1);
        }
        this.pushBack(nextTok);
        return null;
    }

    public void pushBack(String tok) {
        this.pushBackBuf.addLast(tok);
    }
}

