/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.io.PushbackReader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

public class SearchCompiler {
    private boolean caseSensitive = false;
    private boolean regexSearch = false;
    private String rxErrorMsg = I18n.marktr("The regex \"{0}\" had a parse error at offset {1}, full error:\n\n{2}");
    private PushbackTokenizer tokenizer;
    private CollectBackReferencesVisitor childBackRefs;

    public SearchCompiler(boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) {
        this.caseSensitive = caseSensitive;
        this.regexSearch = regexSearch;
        this.tokenizer = tokenizer;
        this.childBackRefs = new CollectBackReferencesVisitor(Main.main.getCurrentDataSet());
    }

    public static Match compile(String searchStr, boolean caseSensitive, boolean regexSearch) throws ParseError {
        return new SearchCompiler(caseSensitive, regexSearch, new PushbackTokenizer(new PushbackReader(new StringReader(searchStr)))).parse();
    }

    public Match parse() throws ParseError {
        Match m = this.parseJuxta();
        if (!this.tokenizer.readIfEqual(null)) {
            throw new ParseError(I18n.tr("Unexpected token: {0}", this.tokenizer.nextToken()));
        }
        return m;
    }

    private Match parseJuxta() throws ParseError {
        Match m;
        Match juxta = new Always();
        while ((m = this.parseOr()) != null) {
            juxta = new And(m, juxta);
        }
        return juxta;
    }

    private Match parseOr() throws ParseError {
        Match a = this.parseNot();
        if (this.tokenizer.readIfEqual("|")) {
            Match b = this.parseNot();
            if (a == null || b == null) {
                throw new ParseError(I18n.tr("Missing arguments for or."));
            }
            return new Or(a, b);
        }
        return a;
    }

    private Match parseNot() throws ParseError {
        if (this.tokenizer.readIfEqual("-")) {
            Match m = this.parseParens();
            if (m == null) {
                throw new ParseError(I18n.tr("Missing argument for not."));
            }
            return new Not(m);
        }
        return this.parseParens();
    }

    private Match parseParens() throws ParseError {
        if (this.tokenizer.readIfEqual("(")) {
            Match m = this.parseJuxta();
            if (!this.tokenizer.readIfEqual(")")) {
                throw new ParseError(I18n.tr("Expected closing parenthesis."));
            }
            return m;
        }
        return this.parsePat();
    }

    private Match parsePat() throws ParseError {
        String tok = this.tokenizer.readText();
        if (this.tokenizer.readIfEqual(":")) {
            String tok2 = this.tokenizer.readText();
            if (tok == null) {
                tok = "";
            }
            if (tok2 == null) {
                tok2 = "";
            }
            return this.parseKV(tok, tok2);
        }
        if (this.tokenizer.readIfEqual("=")) {
            String tok2 = this.tokenizer.readText();
            if (tok == null) {
                tok = "";
            }
            if (tok2 == null) {
                tok2 = "";
            }
            return new ExactKeyValue(this.regexSearch, tok, tok2);
        }
        if (tok == null) {
            return null;
        }
        if (tok.equals("modified")) {
            return new Modified();
        }
        if (tok.equals("incomplete")) {
            return new Incomplete();
        }
        if (tok.equals("untagged")) {
            return new Untagged();
        }
        if (tok.equals("selected")) {
            return new Selected();
        }
        if (tok.equals("child")) {
            return new Child(this.parseParens(), this.childBackRefs);
        }
        if (tok.equals("parent")) {
            return new Parent(this.parseParens());
        }
        return new Any(tok);
    }

    private Match parseKV(String key, String value) throws ParseError {
        if (key.equals("type")) {
            return new ExactType(value);
        }
        if (key.equals("user")) {
            return new UserMatch(value);
        }
        if (key.equals("nodes")) {
            try {
                String[] range = value.split("-");
                if (range.length == 1) {
                    return new NodeCount(Integer.parseInt(value));
                }
                if (range.length == 2) {
                    return new NodeCountRange(Integer.parseInt(range[0]), Integer.parseInt(range[1]));
                }
                throw new ParseError(I18n.tr("Wrong number of parameters for nodes operator."));
            }
            catch (NumberFormatException e) {
                throw new ParseError(I18n.tr("Incorrect value of nodes operator: {0}. Nodes operator expects number of nodes or range, for example nodes:10-20", value));
            }
        }
        if (key.equals("id")) {
            try {
                return new Id(Long.parseLong(value));
            }
            catch (NumberFormatException x) {
                throw new ParseError(I18n.tr("Incorrect value of id operator: {0}. Number is expected.", value));
            }
        }
        return new KeyValue(key, value);
    }

    private int regexFlags() {
        int searchFlags = 0;
        searchFlags |= 0x80;
        searchFlags |= 0x20;
        if (!this.caseSensitive) {
            searchFlags |= 0x42;
        }
        return searchFlags;
    }

    public static class ParseError
    extends Exception {
        public ParseError(String msg) {
            super(msg);
        }
    }

    private static class Child
    extends Match {
        private final Match parent;
        private final CollectBackReferencesVisitor childBackRefs;

        public Child(Match m, CollectBackReferencesVisitor childBackRefs) {
            this.parent = m == null ? new Always() : m;
            this.childBackRefs = childBackRefs;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            boolean isChild = false;
            this.childBackRefs.initialize();
            osm.visit(this.childBackRefs);
            for (OsmPrimitive p : this.childBackRefs.getData()) {
                isChild |= this.parent.match(p);
            }
            return isChild;
        }

        public String toString() {
            return "child(" + this.parent + ")";
        }
    }

    private static class Parent
    extends Match {
        private Match child;

        public Parent(Match m) {
            this.child = m;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            boolean isParent;
            block4: {
                block3: {
                    isParent = false;
                    if (this.child == null) {
                        this.child = new Always();
                    }
                    if (!(osm instanceof Way)) break block3;
                    for (Node n : ((Way)osm).getNodes()) {
                        isParent |= this.child.match(n);
                    }
                    break block4;
                }
                if (!(osm instanceof Relation)) break block4;
                for (RelationMember member : ((Relation)osm).getMembers()) {
                    if (member.getMember() == null) continue;
                    isParent |= this.child.match(member.getMember());
                }
            }
            return isParent;
        }

        public String toString() {
            return "parent(" + this.child + ")";
        }
    }

    private static class Untagged
    extends Match {
        private Untagged() {
        }

        public boolean match(OsmPrimitive osm) {
            return !osm.isTagged();
        }

        public String toString() {
            return "untagged";
        }
    }

    private static class Incomplete
    extends Match {
        private Incomplete() {
        }

        public boolean match(OsmPrimitive osm) {
            return osm.incomplete;
        }

        public String toString() {
            return "incomplete";
        }
    }

    private static class Selected
    extends Match {
        private Selected() {
        }

        public boolean match(OsmPrimitive osm) {
            return Main.main.getCurrentDataSet().isSelected(osm);
        }

        public String toString() {
            return "selected";
        }
    }

    private static class Modified
    extends Match {
        private Modified() {
        }

        public boolean match(OsmPrimitive osm) {
            return osm.isModified() || osm.isNew();
        }

        public String toString() {
            return "modified";
        }
    }

    private static class NodeCountRange
    extends Match {
        private int minCount;
        private int maxCount;

        public NodeCountRange(int minCount, int maxCount) {
            if (maxCount < minCount) {
                this.minCount = maxCount;
                this.maxCount = minCount;
            } else {
                this.minCount = minCount;
                this.maxCount = maxCount;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (!(osm instanceof Way)) {
                return false;
            }
            int size = ((Way)osm).getNodesCount();
            return size >= this.minCount && size <= this.maxCount;
        }

        public String toString() {
            return "nodes=" + this.minCount + "-" + this.maxCount;
        }
    }

    private static class NodeCount
    extends Match {
        private int count;

        public NodeCount(int count) {
            this.count = count;
        }

        public boolean match(OsmPrimitive osm) {
            return osm instanceof Way && ((Way)osm).getNodesCount() == this.count;
        }

        public String toString() {
            return "nodes=" + this.count;
        }
    }

    private static class UserMatch
    extends Match {
        private User user;

        public UserMatch(String user) {
            List<User> users = User.getByName(user);
            if (!users.isEmpty()) {
                this.user = users.get(0);
            } else {
                user = null;
            }
        }

        public boolean match(OsmPrimitive osm) {
            if (osm.getUser() == null && this.user == null) {
                return true;
            }
            if (osm.getUser() == null) {
                return false;
            }
            return osm.getUser().equals(this.user);
        }

        public String toString() {
            return "user=" + this.user == null ? "" : this.user.getName();
        }
    }

    private static class ExactType
    extends Match {
        private final Class<?> type;

        public ExactType(String type) throws ParseError {
            if ("node".equals(type)) {
                this.type = Node.class;
            } else if ("way".equals(type)) {
                this.type = Way.class;
            } else if ("relation".equals(type)) {
                this.type = Relation.class;
            } else {
                throw new ParseError(I18n.tr("Unknown primitive type: {0}. Allowed values are node, way or relation", type));
            }
        }

        public boolean match(OsmPrimitive osm) {
            return osm.getClass() == this.type;
        }

        public String toString() {
            return "type=" + this.type;
        }
    }

    private class Any
    extends Match {
        private String s;

        public Any(String s) {
            this.s = s;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            String search;
            if (!osm.hasKeys()) {
                return this.s.equals("");
            }
            Pattern searchRegex = null;
            if (SearchCompiler.this.regexSearch) {
                search = this.s;
                int searchFlags = SearchCompiler.this.regexFlags();
                try {
                    searchRegex = Pattern.compile(search, searchFlags);
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
            } else {
                search = SearchCompiler.this.caseSensitive ? this.s : this.s.toLowerCase();
            }
            for (Map.Entry<String, String> e : osm.entrySet()) {
                String value;
                String key;
                if (SearchCompiler.this.regexSearch) {
                    key = e.getKey();
                    value = e.getValue();
                    Matcher keyMatcher = searchRegex.matcher(key);
                    Matcher valMatcher = searchRegex.matcher(value);
                    boolean keyMatchFound = keyMatcher.find();
                    boolean valMatchFound = valMatcher.find();
                    if (!keyMatchFound && !valMatchFound) continue;
                    return true;
                }
                key = SearchCompiler.this.caseSensitive ? e.getKey() : e.getKey().toLowerCase();
                String string = value = SearchCompiler.this.caseSensitive ? e.getValue() : e.getValue().toLowerCase();
                if (key.indexOf(search) == -1 && value.indexOf(search) == -1) continue;
                return true;
            }
            if (osm.getUser() != null) {
                String name = osm.getUser().getName();
                if (!SearchCompiler.this.caseSensitive) {
                    name = name.toLowerCase();
                }
                if (name.indexOf(search) != -1) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.s;
        }
    }

    private static class ExactKeyValue
    extends Match {
        private final String key;
        private final String value;
        private final Pattern keyPattern;
        private final Pattern valuePattern;
        private final Mode mode;

        public ExactKeyValue(boolean regexp, String key, String value) throws ParseError {
            if (key == "") {
                throw new ParseError(I18n.tr("Key cannot be empty when tag operator is used. Sample use: key=value"));
            }
            this.key = key;
            this.value = value;
            this.mode = "".equals(value) && "*".equals(key) ? Mode.NONE : ("".equals(value) ? (regexp ? Mode.MISSING_KEY_REGEXP : Mode.MISSING_KEY) : ("*".equals(key) && "*".equals(value) ? Mode.ANY : ("*".equals(key) ? (regexp ? Mode.ANY_KEY_REGEXP : Mode.ANY_KEY) : ("*".equals(value) ? (regexp ? Mode.ANY_VALUE_REGEXP : Mode.ANY_VALUE) : (regexp ? Mode.EXACT_REGEXP : Mode.EXACT)))));
            this.keyPattern = regexp && key.length() > 0 && !key.equals("*") ? Pattern.compile(key) : null;
            if (regexp && value.length() > 0 && !value.equals("*")) {
                try {
                    this.valuePattern = Pattern.compile(value);
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr("Pattern Syntax Error: Pattern {0} in {1} is illegal!", e.getPattern(), value));
                }
            } else {
                this.valuePattern = null;
            }
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            if (!osm.hasKeys()) {
                return this.mode == Mode.NONE;
            }
            switch (this.mode) {
                case NONE: {
                    return false;
                }
                case MISSING_KEY: {
                    return osm.get(this.key) == null;
                }
                case ANY: {
                    return true;
                }
                case ANY_VALUE: {
                    return osm.get(this.key) != null;
                }
                case ANY_KEY: {
                    for (String v : osm.getKeys().values()) {
                        if (!v.equals(this.value)) continue;
                        return true;
                    }
                    return false;
                }
                case EXACT: {
                    return this.value.equals(osm.get(this.key));
                }
                case ANY_KEY_REGEXP: {
                    for (String v : osm.getKeys().values()) {
                        if (!this.valuePattern.matcher(v).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case ANY_VALUE_REGEXP: 
                case EXACT_REGEXP: {
                    for (Map.Entry<String, String> entry : osm.entrySet()) {
                        if (!this.keyPattern.matcher(entry.getKey()).matches() || this.mode != Mode.ANY_VALUE_REGEXP && !this.valuePattern.matcher(entry.getValue()).matches()) continue;
                        return true;
                    }
                    return false;
                }
                case MISSING_KEY_REGEXP: {
                    for (String k : osm.keySet()) {
                        if (!this.keyPattern.matcher(k).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            throw new AssertionError((Object)"Missed state");
        }

        public String toString() {
            return this.key + '=' + this.value;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            ANY,
            ANY_KEY,
            ANY_VALUE,
            EXACT,
            NONE,
            MISSING_KEY,
            ANY_KEY_REGEXP,
            ANY_VALUE_REGEXP,
            EXACT_REGEXP,
            MISSING_KEY_REGEXP;

        }
    }

    private class KeyValue
    extends Match {
        private String key;
        private String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            if (SearchCompiler.this.regexSearch) {
                if (!osm.hasKeys()) {
                    return false;
                }
                Pattern searchKey = null;
                Pattern searchValue = null;
                int searchFlags = SearchCompiler.this.regexFlags();
                try {
                    searchKey = Pattern.compile(this.key, searchFlags);
                    searchValue = Pattern.compile(this.value, searchFlags);
                }
                catch (PatternSyntaxException e) {
                    throw new ParseError(I18n.tr(SearchCompiler.this.rxErrorMsg, e.getPattern(), e.getIndex(), e.getMessage()));
                }
                for (Map.Entry<String, String> e : osm.entrySet()) {
                    Matcher matcherValue;
                    boolean matchedValue;
                    String k = e.getKey();
                    String v = e.getValue();
                    Matcher matcherKey = searchKey.matcher(k);
                    boolean matchedKey = matcherKey.find();
                    if (!matchedKey || !(matchedValue = (matcherValue = searchValue.matcher(v)).find())) continue;
                    return true;
                }
            } else {
                String value = null;
                value = this.key.equals("timestamp") ? DateUtils.fromDate(osm.getTimestamp()) : osm.get(this.key);
                if (value == null) {
                    return false;
                }
                String v1 = SearchCompiler.this.caseSensitive ? value : value.toLowerCase();
                String v2 = SearchCompiler.this.caseSensitive ? this.value : this.value.toLowerCase();
                return v1.indexOf(v2) != -1;
            }
            return false;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private static class Id
    extends Match {
        private long id;

        public Id(long id) {
            this.id = id;
        }

        public boolean match(OsmPrimitive osm) {
            return osm.getId() == this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    private static class Or
    extends Match {
        private Match lhs;
        private Match rhs;

        public Or(Match lhs, Match rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            return this.lhs.match(osm) || this.rhs.match(osm);
        }

        public String toString() {
            return this.lhs + " || " + this.rhs;
        }
    }

    private static class And
    extends Match {
        private Match lhs;
        private Match rhs;

        public And(Match lhs, Match rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            return this.lhs.match(osm) && this.rhs.match(osm);
        }

        public String toString() {
            return this.lhs + " && " + this.rhs;
        }
    }

    private static class Not
    extends Match {
        private final Match match;

        public Not(Match match) {
            this.match = match;
        }

        public boolean match(OsmPrimitive osm) throws ParseError {
            return !this.match.match(osm);
        }

        public String toString() {
            return "!" + this.match;
        }
    }

    private static class Always
    extends Match {
        private Always() {
        }

        public boolean match(OsmPrimitive osm) {
            return true;
        }
    }

    public static abstract class Match {
        public abstract boolean match(OsmPrimitive var1) throws ParseError;
    }
}

