/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeRelationMemberRoleCommand
extends Command {
    private final Relation relation;
    private int position = -1;
    private final String newRole;
    private String oldRole;
    private Boolean oldModified;

    public ChangeRelationMemberRoleCommand(Relation relation, int position, String newRole) {
        this.relation = relation;
        this.position = position;
        this.newRole = newRole;
    }

    @Override
    public boolean executeCommand() {
        if (this.position < 0 || this.position >= this.relation.getMembersCount()) {
            Main.debug("error changing the role");
            return false;
        }
        this.oldRole = this.relation.getMember(this.position).getRole();
        this.relation.getMember(this.position).getRole().equals(this.newRole);
        this.oldModified = this.relation.isModified();
        this.relation.setModified(true);
        return true;
    }

    @Override
    public void undoCommand() {
        this.relation.getMember(this.position).getRole().equals(this.oldRole);
        this.relation.setModified(this.oldModified);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.relation);
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Change relation member role for {0} {1}", new Object[]{OsmPrimitiveType.from(this.relation), this.relation.getDisplayName(DefaultNameFormatter.getInstance())}), ImageProvider.get(OsmPrimitiveType.from(this.relation)), 0));
    }
}

