/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.CollectBackReferencesVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.actionsupport.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteCommand
extends Command {
    private final Collection<? extends OsmPrimitive> toDelete;

    public DeleteCommand(Collection<? extends OsmPrimitive> data) {
        if (data == null) {
            data = Collections.emptyList();
        }
        this.toDelete = data;
    }

    public DeleteCommand(OsmPrimitive data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "data"));
        }
        this.toDelete = Collections.singleton(data);
    }

    public DeleteCommand(OsmDataLayer layer, OsmPrimitive data) throws IllegalArgumentException {
        super(layer);
        if (data == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "data"));
        }
        this.toDelete = Collections.singleton(data);
    }

    public DeleteCommand(OsmDataLayer layer, Collection<? extends OsmPrimitive> data) throws IllegalArgumentException {
        super(layer);
        if (data == null) {
            data = Collections.emptyList();
        }
        this.toDelete = data;
    }

    protected void removeNewNodesFromDeletedWay(Way w) {
        if (w.isNew()) {
            return;
        }
        ArrayList<Node> nodesToKeep = new ArrayList<Node>();
        Iterator it = nodesToKeep.iterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!n.isNew()) continue;
            it.remove();
        }
        w.setNodes(nodesToKeep);
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            osmPrimitive.setDeleted(true);
            if (!(osmPrimitive instanceof Way)) continue;
            this.removeNewNodesFromDeletedWay((Way)osmPrimitive);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        deleted.addAll(this.toDelete);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableTreeNode description() {
        void var3_8;
        if (this.toDelete.size() == 1) {
            OsmPrimitive primitive = this.toDelete.iterator().next();
            String msg = "";
            switch (OsmPrimitiveType.from(primitive)) {
                case NODE: {
                    msg = "Delete node {0}";
                    break;
                }
                case WAY: {
                    msg = "Delete way {0}";
                    break;
                }
                case RELATION: {
                    msg = "Delete relation {0}";
                }
            }
            return new DefaultMutableTreeNode(new JLabel(I18n.tr(msg, primitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(primitive)), 0));
        }
        HashSet<OsmPrimitiveType> typesToDelete = new HashSet<OsmPrimitiveType>();
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            typesToDelete.add(OsmPrimitiveType.from(osmPrimitive));
        }
        String msg = "";
        String string = "object";
        if (typesToDelete.size() > 1) {
            msg = I18n.trn("Delete {0} object", "Delete {0} objects", this.toDelete.size(), this.toDelete.size());
        } else {
            OsmPrimitiveType t = (OsmPrimitiveType)((Object)typesToDelete.iterator().next());
            String string2 = t.getAPIName();
            switch (t) {
                case NODE: {
                    msg = I18n.trn("Delete {0} node", "Delete {0} nodes", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case WAY: {
                    msg = I18n.trn("Delete {0} way", "Delete {0} ways", this.toDelete.size(), this.toDelete.size());
                    break;
                }
                case RELATION: {
                    msg = I18n.trn("Delete {0} relation", "Delete {0} relations", this.toDelete.size(), this.toDelete.size());
                }
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new JLabel(msg, ImageProvider.get("data", (String)var3_8), 0));
        for (OsmPrimitive osmPrimitive : this.toDelete) {
            root.add(new DefaultMutableTreeNode(new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0)));
        }
        return root;
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean silent) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null", "layer"));
        }
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        CollectBackReferencesVisitor v = new CollectBackReferencesVisitor(layer.data);
        v.initialize();
        for (OsmPrimitive osmPrimitive : selection) {
            osmPrimitive.visit(v);
        }
        v.getData().addAll(selection);
        if (v.getData().isEmpty()) {
            return null;
        }
        if (!DeleteCommand.checkAndConfirmOutlyingDeletes(layer, v.getData()) && !silent) {
            return null;
        }
        return new DeleteCommand(layer, v.getData());
    }

    public static Command deleteWithReferences(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.deleteWithReferences(layer, selection, false);
    }

    private static int testRelation(Relation ref, OsmPrimitive osm, boolean simulate) {
        if (simulate) {
            return 1;
        }
        String role = "";
        for (RelationMember m : ref.getMembers()) {
            if (m.getMember() != osm) continue;
            role = m.getRole();
            break;
        }
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Conflicting relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
        dialog.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
        if (role.length() > 0) {
            dialog.setContent(I18n.tr("<html>Selection \"{0}\" is used by relation \"{1}\" with role {2}.<br>Delete from relation?</html>", osm.getDisplayName(DefaultNameFormatter.getInstance()), ref.getDisplayName(DefaultNameFormatter.getInstance()), role));
            dialog.showDialog();
            return dialog.getValue();
        }
        dialog.setContent(I18n.tr("<html>Selection \"{0}\" is used by relation \"{1}\".<br>Delete from relation?</html>", osm.getDisplayName(DefaultNameFormatter.getInstance()), ref.getDisplayName(DefaultNameFormatter.getInstance())));
        dialog.showDialog();
        return dialog.getValue();
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection) {
        return DeleteCommand.delete(layer, selection, true, false);
    }

    protected static Collection<Node> computeNodesToDelete(BackreferencedDataSet backreferences, OsmDataLayer layer, Collection<OsmPrimitive> primitivesToDelete) {
        HashSet<Node> nodesToDelete = new HashSet<Node>();
        for (Way way : OsmPrimitive.getFilteredList(primitivesToDelete, Way.class)) {
            for (Node n : way.getNodes()) {
                if (n.isTagged()) continue;
                Set<OsmPrimitive> referringPrimitives = backreferences.getParents(n);
                referringPrimitives.removeAll(primitivesToDelete);
                int count = 0;
                for (OsmPrimitive p : referringPrimitives) {
                    if (p.isDeleted()) continue;
                    ++count;
                }
                if (count != 0) continue;
                nodesToDelete.add(n);
            }
        }
        return nodesToDelete;
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay) {
        return DeleteCommand.delete(layer, selection, alsoDeleteNodesInWay, false);
    }

    public static Command delete(OsmDataLayer layer, Collection<? extends OsmPrimitive> selection, boolean alsoDeleteNodesInWay, boolean silent) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        BackreferencedDataSet backreferences = new BackreferencedDataSet(layer.data);
        backreferences.build();
        HashSet<OsmPrimitive> primitivesToDelete = new HashSet<OsmPrimitive>(selection);
        HashSet<Way> waysToBeChanged = new HashSet<Way>();
        if (alsoDeleteNodesInWay) {
            Collection<Node> nodesToDelete = DeleteCommand.computeNodesToDelete(backreferences, layer, primitivesToDelete);
            primitivesToDelete.addAll(nodesToDelete);
        }
        if (!silent && !DeleteCommand.checkAndConfirmOutlyingDeletes(layer, primitivesToDelete)) {
            return null;
        }
        waysToBeChanged.addAll(OsmPrimitive.getFilteredSet(backreferences.getParents(primitivesToDelete), Way.class));
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (Way w : waysToBeChanged) {
            Way wnew = new Way(w);
            wnew.removeNodes(primitivesToDelete);
            if (wnew.getNodesCount() < 2) {
                primitivesToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeCommand(w, wnew));
        }
        if (!silent) {
            Set<BackreferencedDataSet.RelationToChildReference> references = backreferences.getRelationToChildReferences(primitivesToDelete);
            Iterator<BackreferencedDataSet.RelationToChildReference> it = references.iterator();
            while (it.hasNext()) {
                BackreferencedDataSet.RelationToChildReference ref = it.next();
                if (!ref.getParent().isDeleted()) continue;
                it.remove();
            }
            if (!references.isEmpty()) {
                DeleteFromRelationConfirmationDialog dialog = DeleteFromRelationConfirmationDialog.getInstance();
                dialog.getModel().populate(references);
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return null;
                }
            }
        }
        for (Relation cur : OsmPrimitive.getFilteredSet(backreferences.getParents(primitivesToDelete), Relation.class)) {
            Relation rel = new Relation(cur);
            rel.removeMembersFor(primitivesToDelete);
            cmds.add(new ChangeCommand(cur, rel));
        }
        if (!primitivesToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(layer, primitivesToDelete));
        }
        return new SequenceCommand(I18n.tr("Delete"), cmds);
    }

    public static Command deleteWaySegment(OsmDataLayer layer, WaySegment ws) {
        if (ws.way.getNodesCount() < 3) {
            return new DeleteCommand(layer, Collections.singleton(ws.way));
        }
        if (ws.way.firstNode() == ws.way.lastNode()) {
            ArrayList<Node> n = new ArrayList<Node>();
            n.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount() - 1));
            n.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
            Way wnew = new Way(ws.way);
            wnew.setNodes(n);
            return new ChangeCommand(ws.way, wnew);
        }
        ArrayList<Node> n1 = new ArrayList<Node>();
        ArrayList<Node> n2 = new ArrayList<Node>();
        n1.addAll(ws.way.getNodes().subList(0, ws.lowerIndex + 1));
        n2.addAll(ws.way.getNodes().subList(ws.lowerIndex + 1, ws.way.getNodesCount()));
        Way wnew = new Way(ws.way);
        if (n1.size() < 2) {
            wnew.setNodes(n2);
            return new ChangeCommand(ws.way, wnew);
        }
        if (n2.size() < 2) {
            wnew.setNodes(n1);
            return new ChangeCommand(ws.way, wnew);
        }
        LinkedList<Command> cmds = new LinkedList<Command>();
        wnew.setNodes(n1);
        cmds.add(new ChangeCommand(ws.way, wnew));
        Way wnew2 = new Way();
        wnew2.setKeys(wnew.getKeys());
        wnew2.setNodes(n2);
        cmds.add(new AddCommand(wnew2));
        return new SequenceCommand(I18n.tr("Split way segment"), cmds);
    }

    private static boolean checkAndConfirmOutlyingDeletes(OsmDataLayer layer, Collection<OsmPrimitive> primitivesToDelete) {
        Area a = layer.data.getDataSourceArea();
        if (a != null) {
            for (OsmPrimitive osm : primitivesToDelete) {
                Node n;
                if (!(osm instanceof Node) || osm.isNew() || a.contains((n = (Node)osm).getCoor())) continue;
                JPanel msg = new JPanel(new GridBagLayout());
                msg.add(new JLabel("<html>" + I18n.tr("You are about to delete nodes outside of the area you have downloaded.<br>This can cause problems because other objects (that you don't see) might use them.<br>Do you really want to delete?") + "</html>"));
                return ConditionalOptionPaneUtil.showConfirmationDialog("delete_outside_nodes", Main.parent, msg, I18n.tr("Delete confirmation"), 0, 3, 0);
            }
        }
        return true;
    }
}

