/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(PurgePrimitivesCommand.class.getName());
    private Collection<OsmPrimitive> toPurge;
    private Set<OsmPrimitive> purgedPrimitives;
    private Set<OsmPrimitive> origVersionsOfTouchedPrimitives;
    private BackreferencedDataSet backreferenceDataSet;

    protected void init(Collection<OsmPrimitive> toPurge) {
        this.toPurge = toPurge;
        this.purgedPrimitives = new HashSet<OsmPrimitive>();
        this.origVersionsOfTouchedPrimitives = new HashSet<OsmPrimitive>();
    }

    public PurgePrimitivesCommand(OsmPrimitive primitive) {
        this.init(Collections.singleton(primitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer layer, OsmPrimitive primitive) {
        super(layer);
        this.init(Collections.singleton(primitive));
    }

    public PurgePrimitivesCommand(OsmDataLayer layer, Collection<OsmPrimitive> primitives) {
        super(layer);
        this.init(primitives);
    }

    public Collection<OsmPrimitive> getPurgedPrimitives() {
        return this.purgedPrimitives;
    }

    protected MutableTreeNode getDescription(OsmPrimitive primitive) {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Purged object ''{0}''", primitive.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get("data", "object"), 0));
    }

    protected MutableTreeNode getDescription(Collection<OsmPrimitive> primitives) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(I18n.tr("Purged {0} objects", primitives.size()));
        for (OsmPrimitive p : primitives) {
            root.add(this.getDescription(p));
        }
        return root;
    }

    @Override
    public MutableTreeNode description() {
        if (this.purgedPrimitives.size() == 1) {
            return this.getDescription(this.purgedPrimitives.iterator().next());
        }
        return this.getDescription(this.purgedPrimitives);
    }

    protected void removeReferecesToPrimitive(OsmPrimitive child, Set<OsmPrimitive> hive) {
        hive.remove(child);
        for (OsmPrimitive parent : this.backreferenceDataSet.getParents(child)) {
            if (this.toPurge.contains(parent)) {
                return;
            }
            if (parent instanceof Way) {
                Way w = (Way)parent;
                if (!this.origVersionsOfTouchedPrimitives.contains(w)) {
                    this.origVersionsOfTouchedPrimitives.add(w);
                }
                List<Node> wayNodes = w.getNodes();
                wayNodes.remove(child);
                w.setNodes(wayNodes);
                if (w.getNodesCount() >= 2) continue;
                System.out.println(I18n.tr("Warning: Purging way {0} because number of nodes dropped below 2. Current is {1}", w.getId(), w.getNodesCount()));
                hive.add(w);
                continue;
            }
            if (!(parent instanceof Relation)) continue;
            Relation r = (Relation)parent;
            if (!this.origVersionsOfTouchedPrimitives.contains(r)) {
                this.origVersionsOfTouchedPrimitives.add(r);
            }
            System.out.println(I18n.tr("Removing reference from relation {0}", r.getId()));
            r.removeMembersFor(child);
        }
    }

    @Override
    public boolean executeCommand() {
        if (this.backreferenceDataSet == null) {
            this.backreferenceDataSet = new BackreferencedDataSet(this.getLayer().data);
            this.backreferenceDataSet.build();
        }
        HashSet<OsmPrimitive> hive = new HashSet<OsmPrimitive>();
        hive.addAll(this.toPurge);
        while (!hive.isEmpty()) {
            OsmPrimitive p = (OsmPrimitive)hive.iterator().next();
            this.removeReferecesToPrimitive(p, hive);
            this.getLayer().data.removePrimitive(p);
            this.purgedPrimitives.add(p);
            ConflictCollection conflicts = this.getLayer().getConflicts();
            if (!conflicts.hasConflictForMy(p)) continue;
            this.rememberConflict(conflicts.getConflictForMy(p));
            conflicts.remove(p);
        }
        this.backreferenceDataSet = null;
        return super.executeCommand();
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.origVersionsOfTouchedPrimitives);
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.getLayer())) {
            logger.warning(I18n.tr("Can''t undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.getLayer().toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.getLayer());
        for (OsmPrimitive purged : this.purgedPrimitives) {
            this.getLayer().data.addPrimitive(purged);
        }
        this.reconstituteConflicts();
        super.undoCommand();
    }

    public void setBackreferenceDataSet(BackreferencedDataSet ds) {
        this.backreferenceDataSet = ds;
    }
}

