/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndeletePrimitivesCommand
extends ConflictResolveCommand {
    private static final Logger logger = Logger.getLogger(UndeletePrimitivesCommand.class.getName());
    private ArrayList<OsmPrimitive> toUndelete = new ArrayList();

    protected UndeletePrimitivesCommand() {
    }

    public UndeletePrimitivesCommand(OsmPrimitive node) {
        this();
        this.toUndelete.add(node);
    }

    public UndeletePrimitivesCommand(OsmPrimitive ... toUndelete) {
        this();
        for (int i = 0; i < toUndelete.length; ++i) {
            this.toUndelete.add(toUndelete[i]);
        }
    }

    public UndeletePrimitivesCommand(Collection<OsmPrimitive> toUndelete) {
        this();
        this.toUndelete.addAll(toUndelete);
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Undelete {0} primitives", this.toUndelete.size()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        for (OsmPrimitive primitive : this.toUndelete) {
            if (this.getLayer().getConflicts().hasConflictForMy(primitive)) {
                this.rememberConflict(this.getLayer().getConflicts().getConflictForMy(primitive));
                this.getLayer().getConflicts().remove(primitive);
            }
            primitive.clearOsmId();
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.addAll(this.toUndelete);
    }
}

