/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<OsmPrimitive> conflict;

    public VersionConflictResolveCommand(OsmPrimitive my, OsmPrimitive their) {
        this.conflict = new Conflict<OsmPrimitive>(my, their);
    }

    @Override
    public MutableTreeNode description() {
        String msg = "";
        switch (OsmPrimitiveType.from(this.conflict.getMy())) {
            case NODE: {
                msg = I18n.marktr("Resolve version conflicts for node {0}");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Resolve version conflicts for way {0}");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Resolve version conflicts for relation {0}");
            }
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr(msg, this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        if (!this.conflict.getMy().isNew()) {
            this.conflict.getMy().setOsmId(this.conflict.getMy().getId(), (int)Math.max(this.conflict.getMy().getVersion(), this.conflict.getTheir().getVersion()));
        }
        this.getLayer().getConflicts().remove(this.conflict);
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }
}

