/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class GpxData
extends WithAttributes {
    public static final String META_PREFIX = "meta.";
    public static final String META_AUTHOR_NAME = "meta.author.name";
    public static final String META_AUTHOR_EMAIL = "meta.author.email";
    public static final String META_AUTHOR_LINK = "meta.author.link";
    public static final String META_COPYRIGHT_AUTHOR = "meta.copyright.author";
    public static final String META_COPYRIGHT_LICENSE = "meta.copyright.license";
    public static final String META_COPYRIGHT_YEAR = "meta.copyright.year";
    public static final String META_DESC = "meta.desc";
    public static final String META_KEYWORDS = "meta.keywords";
    public static final String META_LINKS = "meta.links";
    public static final String META_NAME = "meta.name";
    public static final String META_TIME = "meta.time";
    public File storageFile;
    public boolean fromServer;
    public Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public Collection<WayPoint> waypoints = new LinkedList<WayPoint>();

    public void mergeFrom(GpxData other) {
        if (this.storageFile == null && other.storageFile != null) {
            this.storageFile = other.storageFile;
        }
        this.fromServer = this.fromServer && other.fromServer;
        for (Map.Entry ent : other.attr.entrySet()) {
            String k = (String)ent.getKey();
            if (k.equals(META_LINKS) && this.attr.containsKey(META_LINKS)) {
                ((Collection)this.attr.get(META_LINKS)).addAll((Collection)ent.getValue());
                continue;
            }
            this.attr.put(k, ent.getValue());
        }
        this.tracks.addAll(other.tracks);
        this.routes.addAll(other.routes);
        this.waypoints.addAll(other.waypoints);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack trk : this.tracks) {
            for (Collection<WayPoint> trkseg : trk.trackSegs) {
                if (trkseg.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute rte : this.routes) {
            if (rte.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint wpt : this.waypoints) {
            if (bounds == null) {
                bounds = new Bounds(wpt.getCoor());
                continue;
            }
            bounds.extend(wpt.getCoor());
        }
        for (GpxRoute rte : this.routes) {
            for (WayPoint wayPoint : rte.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wayPoint.getCoor());
                    continue;
                }
                bounds.extend(wayPoint.getCoor());
            }
        }
        for (GpxTrack trk : this.tracks) {
            for (Collection collection : trk.trackSegs) {
                for (WayPoint wpt : collection) {
                    if (bounds == null) {
                        bounds = new Bounds(wpt.getCoor());
                        continue;
                    }
                    bounds.extend(wpt.getCoor());
                }
            }
        }
        return bounds;
    }

    public double length() {
        double result = 0.0;
        for (GpxTrack trk : this.tracks) {
            result += trk.length();
        }
        return result;
    }
}

