/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Relation
extends OsmPrimitive {
    private final List<RelationMember> members = new ArrayList<RelationMember>();

    public List<RelationMember> getMembers() {
        return new CopyList<RelationMember>(this.members.toArray(new RelationMember[this.members.size()]));
    }

    public void setMembers(List<RelationMember> members) {
        this.members.clear();
        if (members != null) {
            this.members.addAll(members);
        }
    }

    public int getMembersCount() {
        return this.members.size();
    }

    public RelationMember getMember(int index) {
        return this.members.get(index);
    }

    public void addMember(RelationMember member) {
        this.members.add(member);
    }

    public void addMember(int index, RelationMember member) {
        this.members.add(index, member);
    }

    public RelationMember setMember(int index, RelationMember member) {
        return this.members.set(index, member);
    }

    public RelationMember removeMember(int index) {
        return this.members.remove(index);
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    protected Relation(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Relation() {
        super(0L, false);
    }

    public Relation(Relation clone) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
    }

    public Relation(long id) throws IllegalArgumentException {
        super(id, false);
    }

    public Relation(RelationData data, DataSet dataSet) {
        super(data);
        this.load(data, dataSet);
    }

    @Override
    public void cloneFrom(OsmPrimitive osm) {
        super.cloneFrom(osm);
        this.members.clear();
        for (RelationMember em : ((Relation)osm).getMembers()) {
            this.members.add(new RelationMember(em));
        }
    }

    @Override
    public void load(PrimitiveData data, DataSet dataSet) {
        super.load(data, dataSet);
        RelationData relationData = (RelationData)data;
        Node nodeMarker = new Node();
        Way wayMarker = new Way();
        Relation relationMarker = new Relation();
        HashMap<Long, Node> nodes = new HashMap<Long, Node>();
        HashMap<Long, Way> ways = new HashMap<Long, Way>();
        HashMap<Long, Relation> relations = new HashMap<Long, Relation>();
        for (RelationMemberData member : relationData.getMembers()) {
            switch (member.getMemberType()) {
                case NODE: {
                    nodes.put(member.getMemberId(), nodeMarker);
                    break;
                }
                case WAY: {
                    ways.put(member.getMemberId(), wayMarker);
                    break;
                }
                case RELATION: {
                    relations.put(member.getMemberId(), relationMarker);
                }
            }
        }
        for (Node node : dataSet.nodes) {
            if (nodes.get(node.getUniqueId()) != nodeMarker) continue;
            nodes.put(node.getUniqueId(), node);
        }
        for (Way way : dataSet.ways) {
            if (ways.get(way.getUniqueId()) != wayMarker) continue;
            ways.put(way.getUniqueId(), way);
        }
        for (Relation relation : dataSet.relations) {
            if (relations.get(relation.getUniqueId()) != relationMarker) continue;
            relations.put(relation.getUniqueId(), relation);
        }
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        for (RelationMemberData member : relationData.getMembers()) {
            OsmPrimitive foundMember = null;
            switch (member.getMemberType()) {
                case NODE: {
                    foundMember = (OsmPrimitive)nodes.get(member.getMemberId());
                    if (foundMember == nodeMarker) {
                        throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
                    }
                    break;
                }
                case WAY: {
                    foundMember = (OsmPrimitive)ways.get(member.getMemberId());
                    if (foundMember == wayMarker) {
                        throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
                    }
                    break;
                }
                case RELATION: {
                    foundMember = (OsmPrimitive)relations.get(member.getMemberId());
                    if (foundMember == relationMarker) {
                        throw new AssertionError((Object)"Data consistency problem - relation with missing member detected");
                    }
                    break;
                }
            }
            newMembers.add(new RelationMember(member.getRole(), foundMember));
        }
        this.setMembers(newMembers);
    }

    @Override
    public RelationData save() {
        RelationData data = new RelationData();
        this.saveCommonAttributes(data);
        for (RelationMember member : this.getMembers()) {
            data.getMembers().add(new RelationMemberData(member.getRole(), member.getMember()));
        }
        return data;
    }

    public String toString() {
        return "{Relation id=" + this.getId() + " version=" + this.getVersion() + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Relation)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Relation r = (Relation)other;
        return this.members.equals(r.members);
    }

    @Override
    public int compareTo(OsmPrimitive o) {
        return o instanceof Relation ? Long.valueOf(this.getId()).compareTo(o.getId()) : -1;
    }

    public boolean isIncomplete() {
        for (RelationMember m : this.members) {
            if (m.getMember() != null) continue;
            return true;
        }
        return false;
    }

    public RelationMember firstMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(0);
    }

    public RelationMember lastMember() {
        if (this.incomplete) {
            return null;
        }
        return this.members.size() == 0 ? null : this.members.get(this.members.size() - 1);
    }

    public void removeMembersFor(OsmPrimitive primitive) {
        if (primitive == null) {
            return;
        }
        ArrayList<RelationMember> todelete = new ArrayList<RelationMember>();
        for (RelationMember member : this.members) {
            if (member.getMember() != primitive) continue;
            todelete.add(member);
        }
        this.members.removeAll(todelete);
    }

    public void removeMembersFor(Collection<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return;
        }
        ArrayList<RelationMember> todelete = new ArrayList<RelationMember>();
        for (RelationMember member : this.members) {
            if (!primitives.contains(member.getMember())) continue;
            todelete.add(member);
        }
        this.members.removeAll(todelete);
    }

    @Override
    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }

    public Set<OsmPrimitive> getMemberPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember m : this.members) {
            if (m.getMember() == null) continue;
            ret.add(m.getMember());
        }
        return ret;
    }
}

