/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static long uidCounter = 0L;
    private static HashMap<Long, User> userMap = new HashMap();
    private final String name;
    private final long uid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextLocalUid() {
        Class<User> clazz = User.class;
        synchronized (User.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return --uidCounter;
        }
    }

    public static User createLocalUser(String name) {
        User user = new User(User.getNextLocalUid(), name);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long uid, String name) {
        User user = new User(uid, name);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User getById(long uid) {
        return userMap.get(uid);
    }

    public static List<User> getByName(String name) {
        if (name == null) {
            name = "";
        }
        ArrayList<User> ret = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.getName().equals(name)) continue;
            ret.add(user);
        }
        return ret;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.uid;
    }

    private User(long uid, String name) {
        this.uid = uid;
        this.name = name == null ? "" : name;
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (int)(this.uid ^ this.uid >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User other = (User)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.uid == other.uid;
        }
        return false;
    }
}

