/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistoryOsmPrimitive
implements Comparable<HistoryOsmPrimitive> {
    private long id;
    private boolean visible;
    private String user;
    private long uid;
    private long changesetId;
    private Date timestamp;
    private long version;
    private HashMap<String, String> tags;

    protected void ensurePositiveLong(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' > 0 expected. Got ''{1}''.", name, value));
        }
    }

    protected void ensureNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", name));
        }
    }

    public HistoryOsmPrimitive(long id, long version, boolean visible, String user, long uid, long changesetId, Date timestamp) throws IllegalArgumentException {
        this.ensurePositiveLong(id, "id");
        this.ensurePositiveLong(version, "version");
        if (uid != -1L) {
            this.ensurePositiveLong(uid, "uid");
        }
        this.ensurePositiveLong(changesetId, "changesetId");
        this.ensureNotNull(user, "user");
        this.ensureNotNull(timestamp, "timestamp");
        this.id = id;
        this.version = version;
        this.visible = visible;
        this.user = user;
        this.uid = uid;
        this.changesetId = changesetId;
        this.timestamp = timestamp;
        this.tags = new HashMap();
    }

    public long getId() {
        return this.id;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String getUser() {
        return this.user;
    }

    public long getUid() {
        return this.uid;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean matches(long id, long version) {
        return this.id == id && this.version == version;
    }

    public boolean matches(long id) {
        return this.id == id;
    }

    public abstract OsmPrimitiveType getType();

    @Override
    public int compareTo(HistoryOsmPrimitive o) {
        if (this.id != o.id) {
            throw new ClassCastException(I18n.tr("Can't compare primitive with ID ''{0}'' to primitive with ID ''{1}''.", o.id, this.id));
        }
        return new Long(this.version).compareTo(o.version);
    }

    public void put(String key, String value) {
        this.tags.put(key, value);
    }

    public String get(String key) {
        return this.tags.get(key);
    }

    public boolean hasTag(String key) {
        return this.tags.get(key) != null;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        HistoryOsmPrimitive other = (HistoryOsmPrimitive)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.version == other.version;
    }
}

