/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeVisitor
extends AbstractVisitor {
    private static Logger logger = Logger.getLogger(MergeVisitor.class.getName());
    private ConflictCollection conflicts;
    private final DataSet myDataSet;
    private final DataSet theirDataSet;
    private final HashMap<Long, Node> nodeshash = new HashMap();
    private final HashMap<Long, Way> wayshash = new HashMap();
    private final HashMap<Long, Relation> relshash = new HashMap();
    private Map<OsmPrimitive, OsmPrimitive> merged;

    public MergeVisitor(DataSet myDataSet, DataSet theirDataSet) {
        this.myDataSet = myDataSet;
        this.theirDataSet = theirDataSet;
        for (Node n : myDataSet.nodes) {
            if (n.isNew()) continue;
            this.nodeshash.put(n.getId(), n);
        }
        for (Way w : myDataSet.ways) {
            if (w.isNew()) continue;
            this.wayshash.put(w.getId(), w);
        }
        for (Relation r : myDataSet.relations) {
            if (r.isNew()) continue;
            this.relshash.put(r.getId(), r);
        }
        this.conflicts = new ConflictCollection();
        this.merged = new HashMap<OsmPrimitive, OsmPrimitive>();
    }

    protected <P extends OsmPrimitive> void mergePrimitive(P other, Collection<P> myPrimitives, Collection<P> otherPrimitives, HashMap<Long, P> primitivesWithDefinedIds) {
        if (!other.isNew()) {
            if (this.mergeById(myPrimitives, primitivesWithDefinedIds, other)) {
                return;
            }
        } else {
            for (OsmPrimitive my : myPrimitives) {
                if (!my.isNew() || !my.hasEqualSemanticAttributes(other)) continue;
                if (my.isDeleted() != other.isDeleted()) {
                    this.conflicts.add(my, other);
                } else {
                    my.setVisible(other.isVisible());
                    my.setUser(other.getUser());
                    my.setTimestamp(other.getTimestamp());
                    my.setModified(other.isModified());
                    this.merged.put(other, my);
                }
                return;
            }
        }
        myPrimitives.add(other);
    }

    @Override
    public void visit(Node other) {
        this.mergePrimitive(other, this.myDataSet.nodes, this.theirDataSet.nodes, this.nodeshash);
    }

    @Override
    public void visit(Way other) {
        this.fixWay(other);
        this.mergePrimitive(other, this.myDataSet.ways, this.theirDataSet.ways, this.wayshash);
    }

    @Override
    public void visit(Relation other) {
        this.fixRelation(other);
        this.mergePrimitive(other, this.myDataSet.relations, this.theirDataSet.relations, this.relshash);
    }

    protected void fixIncomplete(Way w) {
        if (!w.incomplete) {
            return;
        }
        if (w.incomplete && w.getNodesCount() == 0) {
            return;
        }
        for (Node n : w.getNodes()) {
            if (!n.incomplete) continue;
            return;
        }
        w.incomplete = false;
    }

    public void fixReferences() {
        for (Way w : this.myDataSet.ways) {
            this.fixWay(w);
            this.fixIncomplete(w);
        }
        for (Relation r : this.myDataSet.relations) {
            this.fixRelation(r);
        }
        for (OsmPrimitive osm : this.conflicts.getMyConflictParties()) {
            if (osm instanceof Way) {
                this.fixWay((Way)osm);
                continue;
            }
            if (!(osm instanceof Relation)) continue;
            this.fixRelation((Relation)osm);
        }
    }

    private void fixWay(Way w) {
        boolean replacedSomething = false;
        LinkedList<Node> newNodes = new LinkedList<Node>();
        for (Node myNode : w.getNodes()) {
            Node mergedNode = (Node)this.merged.get(myNode);
            if (mergedNode != null) {
                if (!mergedNode.isDeleted()) {
                    newNodes.add(mergedNode);
                } else {
                    w.setModified(true);
                }
                replacedSomething = true;
                continue;
            }
            newNodes.add(myNode);
        }
        if (replacedSomething) {
            w.setNodes(newNodes);
        }
    }

    private void fixRelation(Relation r) {
        boolean replacedSomething = false;
        LinkedList<RelationMember> newMembers = new LinkedList<RelationMember>();
        for (RelationMember myMember : r.getMembers()) {
            OsmPrimitive mergedMember = this.merged.get(myMember.getMember());
            if (mergedMember == null) {
                newMembers.add(myMember);
                continue;
            }
            if (!mergedMember.isDeleted()) {
                RelationMember newMember = new RelationMember(myMember.getRole(), mergedMember);
                newMembers.add(newMember);
            }
            replacedSomething = true;
        }
        if (replacedSomething) {
            r.setMembers(newMembers);
        }
    }

    private <P extends OsmPrimitive> boolean mergeById(Collection<P> myPrimitives, HashMap<Long, P> myPrimitivesWithDefinedIds, P other) {
        if (myPrimitivesWithDefinedIds.containsKey(other.getId())) {
            OsmPrimitive my = (OsmPrimitive)myPrimitivesWithDefinedIds.get(other.getId());
            if (my.getVersion() <= other.getVersion()) {
                if (!my.isVisible() && other.isVisible()) {
                    logger.warning(I18n.tr("My primitive with id {0} and version {1} is visible although their primitive with lower version {2} is not visible. Can't deal with this inconsistency. Keeping my primitive. ", Long.toString(my.getId()), Long.toString(my.getVersion()), Long.toString(other.getVersion())));
                    this.merged.put(other, my);
                } else if (my.isVisible() && !other.isVisible()) {
                    this.conflicts.add(my, other);
                } else if (my.incomplete && !other.incomplete) {
                    my.incomplete = false;
                    my.cloneFrom(other);
                    this.merged.put(other, my);
                } else if (!my.incomplete && other.incomplete) {
                    this.merged.put(other, my);
                } else if (my.incomplete && other.incomplete) {
                    this.merged.put(other, my);
                } else if (my.isDeleted() && !other.isDeleted() && my.getVersion() == other.getVersion()) {
                    this.merged.put(other, my);
                } else if (my.isDeleted() != other.isDeleted()) {
                    this.conflicts.add(my, other);
                } else if (!my.isModified() && other.isModified()) {
                    if (other.isDeleted()) {
                        this.myDataSet.unlinkReferencesToPrimitive(my);
                    }
                    my.cloneFrom(other);
                    this.merged.put(other, my);
                } else if (!my.isModified() && !other.isModified() && my.getVersion() == other.getVersion()) {
                    this.merged.put(other, my);
                } else if (!my.isModified() && !other.isModified() && my.getVersion() < other.getVersion()) {
                    my.cloneFrom(other);
                    this.merged.put(other, my);
                } else if (my.isModified() && !other.isModified() && my.getVersion() == other.getVersion()) {
                    this.merged.put(other, my);
                } else if (!my.hasEqualSemanticAttributes(other)) {
                    this.conflicts.add(my, other);
                } else {
                    my.cloneFrom(other);
                    my.setModified(true);
                    this.merged.put(other, my);
                }
            } else {
                this.merged.put(other, my);
            }
            return true;
        }
        return false;
    }

    public void merge() {
        for (OsmPrimitive primitive : this.theirDataSet.allPrimitives()) {
            primitive.visit(this);
        }
        this.fixReferences();
    }

    public DataSet getMyDataSet() {
        return this.myDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

