/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmChangesetCloseException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainOsmApiInitializationException(e), I18n.tr("Error"), 0);
    }

    public static void explainOsmChangesetCloseException(OsmChangesetCloseException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainOsmChangesetCloseException(e), I18n.tr("Error"), 0);
    }

    public static void explainPreconditionFailed(OsmApiException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainPreconditionFailed(e), I18n.tr("Precondition violation"), 0);
    }

    public static void explainGeneric(Exception e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainGeneric(e), I18n.tr("Error"), 0);
    }

    public static void explainSecurityException(OsmTransferException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainSecurityException(e), I18n.tr("Security exception"), 0);
    }

    public static void explainNestedSocketException(OsmTransferException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedSocketException(e), I18n.tr("Network exception"), 0);
    }

    public static void explainNestedIOException(OsmTransferException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedIOException(e), I18n.tr("IO Exception"), 0);
    }

    public static void explainInternalServerError(OsmTransferException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainInternalServerError(e), I18n.tr("Internal Server Error"), 0);
    }

    public static void explainBadRequest(OsmApiException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainBadRequest(e), I18n.tr("Bad Request"), 0);
    }

    public static void explainNotFound(OsmApiException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNotFound(e), I18n.tr("Not Found"), 0);
    }

    public static void explainConflict(OsmApiException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainConflict(e), I18n.tr("Conflict"), 0);
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainNestedUnkonwnHostException(e), I18n.tr("Unknown host"), 0);
    }

    protected static <T> T getNestedException(Exception e, Class<T> nestedClass) {
        Throwable t;
        for (t = e; t != null && !nestedClass.isInstance(t); t = t.getCause()) {
        }
        if (t == null) {
            return null;
        }
        if (nestedClass.isInstance(t)) {
            return nestedClass.cast(t);
        }
        return null;
    }

    public static void explainOsmTransferException(OsmTransferException e) {
        if (ExceptionDialogUtil.getNestedException(e, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(e);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(e, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(e);
            return;
        }
        if (e instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
            return;
        }
        if (e instanceof OsmChangesetCloseException) {
            ExceptionDialogUtil.explainOsmChangesetCloseException((OsmChangesetCloseException)e);
            return;
        }
        if (e instanceof OsmApiException) {
            OsmApiException oae = (OsmApiException)e;
            if (oae.getResponseCode() == 412) {
                ExceptionDialogUtil.explainPreconditionFailed(oae);
                return;
            }
            if (oae.getResponseCode() == 410) {
                ExceptionDialogUtil.explainGoneForUnknownPrimitive(oae);
                return;
            }
            if (oae.getResponseCode() == 500) {
                ExceptionDialogUtil.explainInternalServerError(oae);
                return;
            }
            if (oae.getResponseCode() == 400) {
                ExceptionDialogUtil.explainBadRequest(oae);
                return;
            }
            if (oae.getResponseCode() == 404) {
                ExceptionDialogUtil.explainNotFound(oae);
                return;
            }
            if (oae.getResponseCode() == 409) {
                ExceptionDialogUtil.explainConflict(oae);
                return;
            }
        }
        ExceptionDialogUtil.explainGeneric(e);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException e) {
        JOptionPane.showMessageDialog(Main.parent, ExceptionUtil.explainGoneForUnknownPrimitive(e), I18n.tr("Object deleted"), 0);
    }

    public static void explainException(Exception e) {
        if (e instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)e);
            return;
        }
        ExceptionDialogUtil.explainGeneric(e);
    }
}

