/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AboutAction;
import org.openstreetmap.josm.gui.FileDrop;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.WikiReader;

public class GettingStarted
extends JPanel {
    private String content = "";
    private static String styles = "<style type=\"text/css\">\nbody { font-family: sans-serif; font-weight: bold; }\nh1 {text-align: center;}\n</style>\n";

    public GettingStarted() {
        super(new BorderLayout());
        final LinkGeneral lg = new LinkGeneral("<html>" + styles + "<h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1><h2 align=\"center\">" + I18n.tr("Downloading \"Message of the day\"") + "</h2>");
        JScrollPane scroller = new JScrollPane(lg);
        scroller.setViewportBorder(new EmptyBorder(10, 100, 10, 100));
        this.add((Component)scroller, "Center");
        Thread t = new Thread(new Runnable(){

            public void run() {
                if (GettingStarted.this.content.length() == 0 && Main.pref.getBoolean("help.displaymotd", true)) {
                    GettingStarted.this.content = new MotdContent().updateIfRequiredString();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        lg.setText(GettingStarted.this.content);
                    }
                });
            }
        }, "MOTD-Loader");
        t.setDaemon(true);
        t.start();
        new FileDrop(scroller);
    }

    private class MotdContent
    extends CacheCustomContent {
        private final int myVersion;
        private final String myLang;

        public MotdContent() {
            super("motd.html", 86400);
            this.myVersion = AboutAction.getVersionNumber();
            this.myLang = LanguageInfo.getWikiLanguagePrefix();
        }

        protected byte[] updateData() {
            String motd = new WikiReader().readLang("StartupPage");
            if (motd.length() == 0) {
                motd = "<html>" + styles + "<body><h1>" + "JOSM - " + I18n.tr("Java OpenStreetMap Editor") + "</h1>\n<h2 align=\"center\">(" + I18n.tr("Message of the day not available") + ")</h2></html>";
            }
            Main.pref.putInteger("cache.motd.html.version", this.myVersion);
            Main.pref.put("cache.motd.html.lang", this.myLang);
            return motd.getBytes();
        }

        protected boolean isCacheValid() {
            return Main.pref.getInteger("cache.motd.html.version", -999) == this.myVersion && Main.pref.get("cache.motd.html.lang").equals(this.myLang);
        }
    }

    public class LinkGeneral
    extends JEditorPane
    implements HyperlinkListener {
        public LinkGeneral(String text) {
            this.setContentType("text/html");
            this.setText(text);
            this.setEditable(false);
            this.setOpaque(false);
            this.addHyperlinkListener(this);
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.displayUrl(e.getDescription());
            }
        }
    }
}

