/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.help.HelpBrowserProxy;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpAwareOptionPane {
    private static List<JButton> createOptionButtons(ButtonSpec[] options, String helpTopic) {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        if (options == null) {
            buttons.add(new JButton(I18n.tr("OK")));
        } else {
            for (ButtonSpec spec : options) {
                JButton b = new JButton(spec.text);
                b.setIcon(spec.icon);
                b.setToolTipText(spec.tooltipText == null ? "" : spec.tooltipText);
                if (helpTopic != null) {
                    HelpUtil.setHelpContext(b, helpTopic);
                }
                b.setFocusable(true);
                buttons.add(b);
            }
        }
        return buttons;
    }

    private static JButton createHelpButton(final String helpTopic) {
        JButton b = new JButton(I18n.tr("Help"));
        b.setIcon(ImageProvider.get("help"));
        b.setToolTipText(I18n.tr("Show help information"));
        HelpUtil.setHelpContext(b, helpTopic);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowserProxy.getInstance().setUrlForHelpTopic(HelpAwareOptionPane.completeHelpTopic(helpTopic));
            }
        });
        return b;
    }

    private static String completeHelpTopic(String helpTopic) {
        if (helpTopic == null) {
            return null;
        }
        if (!helpTopic.startsWith("/")) {
            helpTopic = "/" + helpTopic;
        }
        return "Help" + helpTopic;
    }

    public static int showOptionDialog(Component parentComponent, Object msg, String title, int messageType, Icon icon, final ButtonSpec[] options, final ButtonSpec defaultOption, String helpTopic) {
        final List<JButton> buttons = HelpAwareOptionPane.createOptionButtons(options, helpTopic);
        if (helpTopic != null) {
            buttons.add(HelpAwareOptionPane.createHelpButton(helpTopic));
        }
        JButton defaultButton = null;
        if (options != null && defaultOption != null) {
            for (int i = 0; i < options.length; ++i) {
                if (options[i] != defaultOption) continue;
                defaultButton = buttons.get(i);
                break;
            }
        }
        if (msg instanceof String) {
            msg = new JLabel((String)msg);
        }
        final JOptionPane pane = new JOptionPane(msg, messageType, -1, icon, buttons.toArray(), defaultButton);
        pane.getValue();
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(parentComponent), title, true);
        dialog.setContentPane(pane);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                pane.setValue(-1);
                super.windowClosed(e);
            }

            public void windowOpened(WindowEvent e) {
                if (defaultOption != null && options != null && options.length > 0) {
                    int i;
                    for (i = 0; i < options.length && options[i] != defaultOption; ++i) {
                    }
                    if (i >= options.length) {
                        return;
                    }
                    ((JButton)buttons.get(i)).requestFocusInWindow();
                }
            }
        });
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                buttons.get(i).addActionListener(new DefaultAction(dialog, pane, i));
            }
        }
        dialog.pack();
        WindowGeometry.centerOnScreen(dialog.getSize()).applySafe(dialog);
        if (helpTopic != null) {
            HelpUtil.setHelpContext(dialog.getRootPane(), helpTopic);
        }
        dialog.setVisible(true);
        return (Integer)pane.getValue();
    }

    private static class DefaultAction
    implements ActionListener {
        private JDialog dialog;
        private JOptionPane pane;
        private int value;

        public DefaultAction(JDialog dialog, JOptionPane pane, int value) {
            this.dialog = dialog;
            this.pane = pane;
            this.value = value;
        }

        public void actionPerformed(ActionEvent e) {
            this.pane.setValue(this.value);
            this.dialog.setVisible(false);
        }
    }

    public static class ButtonSpec {
        public String text;
        public Icon icon;
        public String tooltipText;
        public String helpTopic;

        public ButtonSpec(String text, Icon icon, String tooltipText, String helpTopic) {
            this.text = text;
            this.icon = icon;
            this.tooltipText = tooltipText;
            this.helpTopic = helpTopic;
        }
    }
}

