/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.ServerSidePreferences;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplet
extends JApplet {
    private static final String[][] paramInfo = new String[][]{{"username", I18n.tr("string"), I18n.tr("Name of the user.")}, {"password", I18n.tr("string"), I18n.tr("OSM Password.")}, {"geometry", I18n.tr("string"), I18n.tr("Resize the applet to the given geometry (format: WIDTHxHEIGHT)")}, {"download", I18n.tr("string;string;..."), I18n.tr("Download each. Can be x1,y1,x2,y2 an URL containing lat=y&lon=x&zoom=z or a filename")}, {"downloadgps", I18n.tr("string;string;..."), I18n.tr("Download each as raw gps. Can be x1,y1,x2,y2 an URL containing lat=y&lon=x&zoom=z or a filename")}, {"selection", I18n.tr("string;string;..."), I18n.tr("Add each to the initial selection. Can be a google-like search string or an URL which returns osm-xml")}, {"reset-preferences", I18n.tr("any"), I18n.tr("If specified, reset the configuration instead of reading it.")}};
    private Map<String, Collection<String>> args = new HashMap<String, Collection<String>>();

    @Override
    public String[][] getParameterInfo() {
        return paramInfo;
    }

    @Override
    public void init() {
        for (String[] s : paramInfo) {
            Collection<String> p = this.readParameter(s[0], this.args.get(s[0]));
            if (p == null) continue;
            this.args.put(s[0], p);
        }
        if (!this.args.containsKey("geometry") && this.getParameter("width") != null && this.getParameter("height") != null) {
            this.args.put("geometry", Arrays.asList(this.getParameter("width") + "x" + this.getParameter("height")));
        }
    }

    @Override
    public void start() {
        String password;
        String username = this.args.containsKey("username") ? this.args.get("username").iterator().next() : null;
        String string = password = this.args.containsKey("password") ? this.args.get("password").iterator().next() : null;
        if (username == null || password == null) {
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)new JLabel(I18n.tr("Username")), GBC.std().insets(0, 0, 20, 0));
            JTextField user = new JTextField(username == null ? "" : username);
            p.add((Component)user, GBC.eol().fill(2));
            p.add((Component)new JLabel(I18n.tr("Password")), GBC.std().insets(0, 0, 20, 0));
            JPasswordField pass = new JPasswordField(password == null ? "" : password);
            p.add((Component)pass, GBC.eol().fill(2));
            JOptionPane.showMessageDialog(null, p);
            username = user.getText();
            password = new String(pass.getPassword());
            this.args.put("password", Arrays.asList(password));
        }
        Main.applet = true;
        Main.pref = new ServerSidePreferences(this.getCodeBase());
        ((ServerSidePreferences)Main.pref).download(username, password);
        Main.preConstructorInit(this.args);
        Main.parent = this;
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        new MainCaller().postConstructorProcessCmdLine(this.args);
        MainMenu m = Main.main.menu;
        m.remove(m.fileMenu);
        m.editMenu.add(new UploadPreferencesAction());
        m.openFile.setEnabled(false);
        m.exit.setEnabled(false);
        m.save.setEnabled(false);
        m.saveAs.setEnabled(false);
        m.gpxExport.setEnabled(false);
    }

    private Collection<String> readParameter(String s, Collection<String> v) {
        String param = this.getParameter(s);
        if (param != null) {
            if (v == null) {
                v = new LinkedList<String>();
            }
            v.addAll(Arrays.asList(param.split(";")));
        }
        return v;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Java OpenStreetMap Editor");
        MainApplet applet = new MainApplet();
        applet.setStub(new AppletStub(){

            public void appletResize(int w, int h) {
                frame.setSize(w, h);
            }

            public AppletContext getAppletContext() {
                return null;
            }

            public URL getCodeBase() {
                try {
                    return new File(".").toURI().toURL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public URL getDocumentBase() {
                return this.getCodeBase();
            }

            public String getParameter(String k) {
                return null;
            }

            public boolean isActive() {
                return true;
            }
        });
        applet.init();
        applet.start();
        frame.setContentPane(applet);
        frame.setVisible(true);
    }

    private final class MainCaller
    extends Main {
        private MainCaller() {
            MainApplet.this.setContentPane(contentPane);
            MainApplet.this.setJMenuBar(this.menu);
            MainApplet.this.setBounds(bounds);
        }
    }

    public static final class UploadPreferencesAction
    extends JosmAction {
        public UploadPreferencesAction() {
            super(I18n.tr("Upload Preferences"), "upload-preferences", I18n.tr("Upload the current preferences to the server"), Shortcut.registerShortcut("applet:uploadprefs", I18n.tr("Upload Preferences"), 85, 1), true);
        }

        public void actionPerformed(ActionEvent e) {
            ((ServerSidePreferences)Main.pref).upload();
        }
    }
}

