/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame mainFrame, SplashScreen splash) {
        super(splash);
        mainFrame.setContentPane(contentPane);
        mainFrame.setJMenuBar(this.menu);
        mainFrame.setBounds(bounds);
        mainFrame.setIconImage(ImageProvider.get("logo.png").getImage());
        mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                if (!Main.saveUnsavedModifications()) {
                    return;
                }
                Main.saveGuiGeometry();
                Main.cleanupBeforeExit();
                System.exit(0);
            }
        });
        mainFrame.setDefaultCloseOperation(0);
    }

    public static void main(String[] argArray) {
        I18n.init();
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        List<String> argList = Arrays.asList(argArray);
        final HashMap<String, Collection<String>> args = new HashMap<String, Collection<String>>();
        for (String arg : argArray) {
            int i;
            if (!arg.startsWith("--")) {
                arg = "--download=" + arg;
            }
            String key = (i = arg.indexOf(61)) == -1 ? arg.substring(2) : arg.substring(2, i);
            String value = i == -1 ? "" : arg.substring(i + 1);
            LinkedList<String> v = (LinkedList<String>)args.get(key);
            if (v == null) {
                v = new LinkedList<String>();
            }
            v.add(value);
            args.put(key, v);
        }
        Main.pref.init(args.containsKey("reset-preferences"));
        if (args.containsKey("language")) {
            I18n.set((String)((Collection)args.get("language")).toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        if (argList.contains("--help") || argList.contains("-?") || argList.contains("-h")) {
            System.out.println(I18n.tr("Java OpenStreetMap Editor") + "\n\n" + I18n.tr("usage") + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options") + ":\n" + "\t--help|-?|-h                              " + I18n.tr("Show this help") + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument") + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box") + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)") + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open file (as raw gps, if .gpx)") + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps") + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search") + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode") + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default") + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language.") + "\n\n" + I18n.tr("options provided as Java system properties") + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ") + I18n.tr("Change the folder for all user settings") + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to increase the maximum size of allocated memory") + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples") + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters are read in the order they are specified, so make sure you load\nsome data before --selection") + "\n\n" + I18n.tr("Instead of --download=<bbox> you may specify osm://<bbox>\n"));
            System.exit(0);
        }
        SplashScreen splash = new SplashScreen(Main.pref.getBoolean("draw.splashscreen", true));
        splash.setStatus(I18n.tr("Activating updated plugins"));
        PluginHandler.earlyCleanup();
        splash.setStatus(I18n.tr("Loading early plugins"));
        PluginHandler.loadPlugins(true);
        splash.setStatus(I18n.tr("Setting defaults"));
        MainApplication.preConstructorInit(args);
        MainApplication.removeObsoletePreferences();
        splash.setStatus(I18n.tr("Creating main GUI"));
        JFrame mainFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor"));
        Main.parent = mainFrame;
        final MainApplication main = new MainApplication(mainFrame, splash);
        splash.setStatus(I18n.tr("Loading plugins"));
        PluginHandler.loadPlugins(false);
        toolbar.refreshToolbarControl();
        mainFrame.setVisible(true);
        splash.closeSplash();
        if ((!args.containsKey("no-maximize") && !args.containsKey("geometry") && Main.pref.get("gui.geometry").length() == 0 || args.containsKey("maximize")) && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mainFrame.setExtendedState(6);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                main.postConstructorProcessCmdLine(args);
            }
        });
    }

    public static void removeObsoletePreferences() {
        String[] obsolete;
        for (String i : obsolete = new String[]{"sample.preference.that.does.not.exist", "osm-server.version", "osm-server.additional-versions", null}) {
            if (i == null || !Main.pref.hasKey(i)) continue;
            Main.pref.removeFromCollection(i, Main.pref.get(i));
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", i));
        }
    }
}

