/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.MoveAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent
implements PropertyChangeListener {
    private ArrayList<Layer> layers = new ArrayList();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    public MouseEvent lastMEvent;
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage offscreenBuffer;
    private boolean virtualNodesEnabled = false;

    public MapView() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MapView.this.removeComponentListener(this);
                MapSlider zoomSlider = new MapSlider(MapView.this);
                MapView.this.add(zoomSlider);
                zoomSlider.setBounds(3, 0, 114, 30);
                MapScaler scaler = new MapScaler(MapView.this);
                MapView.this.add(scaler);
                scaler.setLocation(10, 30);
                if (!MapView.this.zoomToEditLayerBoundingBox()) {
                    new AutoScaleAction("data").actionPerformed(null);
                }
                new MapMover(MapView.this, Main.contentPane);
                MoveAction mv = new MoveAction(MoveAction.Direction.UP);
                if (mv.getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(mv.getShortcut().getKeyStroke(), "UP");
                    Main.contentPane.getActionMap().put("UP", mv);
                }
                if ((mv = new MoveAction(MoveAction.Direction.DOWN)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(mv.getShortcut().getKeyStroke(), "DOWN");
                    Main.contentPane.getActionMap().put("DOWN", mv);
                }
                if ((mv = new MoveAction(MoveAction.Direction.LEFT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(mv.getShortcut().getKeyStroke(), "LEFT");
                    Main.contentPane.getActionMap().put("LEFT", mv);
                }
                if ((mv = new MoveAction(MoveAction.Direction.RIGHT)).getShortcut() != null) {
                    Main.contentPane.getInputMap(2).put(mv.getShortcut().getKeyStroke(), "RIGHT");
                    Main.contentPane.getActionMap().put("RIGHT", mv);
                }
            }
        });
        DataSet.selListeners.add(new SelectionChangedListener(){

            @Override
            public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
                MapView.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                this.mouseMoved(e);
            }

            public void mouseMoved(MouseEvent e) {
                MapView.this.lastMEvent = e;
            }
        });
    }

    public void addLayer(Layer layer) {
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        if (layer.isBackgroundLayer() || this.layers.isEmpty()) {
            this.layers.add(layer);
        } else {
            this.layers.add(0, layer);
        }
        for (Layer.LayerChangeListener l : Layer.listeners) {
            l.layerAdded(layer);
        }
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            Layer old = this.activeLayer;
            this.setActiveLayer(layer);
            for (Layer.LayerChangeListener l : Layer.listeners) {
                l.activeLayerChange(old, layer);
            }
        }
        layer.addPropertyChangeListener(this);
        AudioPlayer.reset();
        this.repaint();
    }

    @Override
    protected DataSet getCurrentDataSet() {
        if (this.activeLayer != null && this.activeLayer instanceof OsmDataLayer) {
            return ((OsmDataLayer)this.activeLayer).data;
        }
        return null;
    }

    public boolean isActiveLayerDrawable() {
        return this.activeLayer != null && this.activeLayer instanceof OsmDataLayer;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.activeLayer.isVisible();
    }

    protected void fireActiveLayerChanged(Layer oldLayer, Layer newLayer) {
        for (Layer.LayerChangeListener l : Layer.listeners) {
            l.activeLayerChange(oldLayer, newLayer);
        }
    }

    protected Layer determineNextActiveLayer() {
        if (this.layers.isEmpty()) {
            return null;
        }
        List<OsmDataLayer> dataLayers = this.getLayersOfType(OsmDataLayer.class);
        if (!dataLayers.isEmpty()) {
            return dataLayers.get(0);
        }
        return this.layers.get(0);
    }

    public void removeLayer(Layer layer) {
        Layer l;
        boolean deletedLayerWasActiveLayer = false;
        if (layer == this.activeLayer) {
            this.activeLayer = null;
            deletedLayerWasActiveLayer = true;
            this.fireActiveLayerChanged(layer, null);
        }
        if (this.layers.remove(layer)) {
            for (Layer.LayerChangeListener l2 : Layer.listeners) {
                l2.layerRemoved(layer);
            }
        }
        layer.removePropertyChangeListener(this);
        layer.destroy();
        AudioPlayer.reset();
        if (deletedLayerWasActiveLayer && (l = this.determineNextActiveLayer()) != null) {
            this.activeLayer = l;
            this.fireActiveLayerChanged(null, l);
        }
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean enabled) {
        if (this.virtualNodesEnabled != enabled) {
            this.virtualNodesEnabled = enabled;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int pos) {
        int curLayerPos = this.layers.indexOf(layer);
        if (curLayerPos == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        if (pos == curLayerPos) {
            return;
        }
        this.layers.remove(curLayerPos);
        if (pos >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(pos, layer);
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public int getLayerPos(Layer layer) {
        int curLayerPos = this.layers.indexOf(layer);
        if (curLayerPos == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list."));
        }
        return curLayerPos;
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (Layer l : this.layers) {
            if (!l.isVisible()) continue;
            ret.add(l);
        }
        Collections.sort(ret, new Comparator<Layer>(){

            @Override
            public int compare(Layer l1, Layer l2) {
                if (l1 instanceof OsmDataLayer && l2 instanceof OsmDataLayer) {
                    if (l1 == MapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (l2 == MapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return new Integer(MapView.this.layers.indexOf(l1)).compareTo(MapView.this.layers.indexOf(l2));
                }
                return new Integer(MapView.this.layers.indexOf(l1)).compareTo(MapView.this.layers.indexOf(l2));
            }
        });
        Collections.reverse(ret);
        return ret;
    }

    @Override
    public void paint(Graphics g) {
        double lat;
        if (this.center == null) {
            return;
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        Graphics2D tempG = this.offscreenBuffer.createGraphics();
        tempG.setColor(Main.pref.getColor("background", Color.BLACK));
        tempG.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (Layer l : this.getVisibleLayersInZOrder()) {
            l.paint(tempG, this);
        }
        for (MapViewPaintable mvp : this.temporaryLayers) {
            mvp.paint(tempG, this);
        }
        tempG.setColor(Color.WHITE);
        Bounds b = this.getProjection().getWorldBoundsLatLon();
        double lon = b.min.lon();
        Point p = this.getPoint(b.min);
        GeneralPath path = new GeneralPath();
        path.moveTo(p.x, p.y);
        double max = b.max.lat();
        for (lat = b.min.lat(); lat <= max; lat += 1.0) {
            p = this.getPoint(new LatLon(lat >= max ? max : lat, lon));
            path.lineTo(p.x, p.y);
        }
        lat = max;
        max = b.max.lon();
        while (lon <= max) {
            p = this.getPoint(new LatLon(lat, lon >= max ? max : lon));
            path.lineTo(p.x, p.y);
            lon += 1.0;
        }
        lon = max;
        max = b.min.lat();
        while (lat >= max) {
            p = this.getPoint(new LatLon(lat <= max ? max : lat, lon));
            path.lineTo(p.x, p.y);
            lat -= 1.0;
        }
        lat = max;
        max = b.min.lon();
        while (lon >= max) {
            p = this.getPoint(new LatLon(lat, lon <= max ? max : lon));
            path.lineTo(p.x, p.y);
            lon -= 1.0;
        }
        int w = this.offscreenBuffer.getWidth();
        int h = this.offscreenBuffer.getHeight();
        Area border = new Area(path);
        Area viewport = new Area(new Rectangle(-1, -1, w + 2, h + 2));
        border.intersect(viewport);
        tempG.draw(border);
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(tempG, this);
        }
        g.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(g);
    }

    public void recalculateCenterScale(BoundingXYVisitor box) {
        if (box == null) {
            box = new BoundingXYVisitor();
        }
        if (box.getBounds() == null) {
            box.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!box.hasExtend()) {
            box.enlargeBoundingBox();
        }
        this.zoomTo(box.getBounds());
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public List<Layer> getAllLayersAsList() {
        return Collections.unmodifiableList(this.layers);
    }

    public <T> List<T> getLayersOfType(Class<T> ofType) {
        ArrayList<T> ret = new ArrayList<T>();
        for (Layer layer : this.getAllLayersAsList()) {
            if (!ofType.isInstance(layer)) continue;
            ret.add(ofType.cast(layer));
        }
        return ret;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    public void setActiveLayer(Layer layer) {
        if (!this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (!(layer instanceof OsmDataLayer) && this.getCurrentDataSet() != null) {
            this.getCurrentDataSet().setSelected(new OsmPrimitive[0]);
            DataSet.fireSelectionChanged(this.getCurrentDataSet().getSelected());
        }
        Layer old = this.activeLayer;
        this.activeLayer = layer;
        if (old != layer) {
            for (Layer.LayerChangeListener l : Layer.listeners) {
                l.activeLayerChange(old, layer);
            }
        }
        if (layer instanceof OsmDataLayer) {
            this.refreshTitle((OsmDataLayer)layer);
        }
        Enumeration<AbstractButton> e = Main.map.toolGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton x = e.nextElement();
            x.setEnabled(((MapMode)x.getAction()).layerIsSupported(layer));
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        if (this.activeLayer instanceof OsmDataLayer) {
            return (OsmDataLayer)this.activeLayer;
        }
        for (Layer layer : this.layers) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return (OsmDataLayer)layer;
        }
        return null;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean zoomToEditLayerBoundingBox() {
        OsmDataLayer layer = this.getEditLayer();
        if (layer == null) {
            return false;
        }
        Collection<DataSource> dataSources = layer.data.dataSources;
        BoundingXYVisitor bbox = new BoundingXYVisitor();
        for (DataSource ds : dataSources) {
            bbox.visit(ds.bounds);
            if (!bbox.hasExtend()) continue;
            this.recalculateCenterScale(bbox);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mvp) {
        if (this.temporaryLayers.contains(mvp)) {
            return false;
        }
        return this.temporaryLayers.add(mvp);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mvp) {
        return this.temporaryLayers.remove(mvp);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        OsmDataLayer layer;
        if (evt.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if ((evt.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || evt.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (layer = (OsmDataLayer)evt.getSource()) == this.getEditLayer()) {
            this.refreshTitle(layer);
        }
    }

    protected void refreshTitle(OsmDataLayer layer) {
        boolean dirty;
        boolean bl = dirty = layer.requiresSaveToFile() || layer.requiresUploadToServer();
        if (dirty) {
            JOptionPane.getFrameForComponent(Main.parent).setTitle("* " + I18n.tr("Java OpenStreetMap Editor"));
        } else {
            JOptionPane.getFrameForComponent(Main.parent).setTitle(I18n.tr("Java OpenStreetMap Editor"));
        }
    }
}

