/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PleaseWaitDialog
extends JDialog {
    private final JProgressBar progressBar = new JProgressBar();
    public final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    public final BoundedRangeModel progress = this.progressBar.getModel();
    public final JButton cancel = new JButton(I18n.tr("Cancel"));

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)this.currentAction, GBC.eol().fill(2));
        pane.add((Component)this.customText, GBC.eol().fill(2));
        pane.add((Component)this.progressBar, GBC.eop().fill(2));
        pane.add((Component)this.cancel, GBC.eol().anchor(10));
        this.setContentPane(pane);
        this.setCustomText("");
        this.setLocationRelativeTo(Main.parent);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent ev) {
                int w = PleaseWaitDialog.this.getWidth();
                if (w > 200) {
                    Main.pref.putInteger("progressdialog.size", w);
                }
            }
        });
    }

    public PleaseWaitDialog(Frame parent) {
        super(parent, true);
        this.initDialog();
    }

    public PleaseWaitDialog(Dialog parent) {
        super(parent, true);
        this.initDialog();
    }

    public void setIndeterminate(boolean newValue) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(newValue);
    }

    public void setCustomText(String text) {
        if (text.length() == 0) {
            this.customText.setVisible(false);
            this.setSize(Main.pref.getInteger("progressdialog.size", 600), 100);
            return;
        }
        this.customText.setVisible(true);
        this.customText.setText(text);
        this.setSize(Main.pref.getInteger("progressdialog.size", 600), 120);
    }
}

