/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000");
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SAME_POSITION_IN_OPPOSITE = new Color(217, 255, 217);
    public static final Color BGCOLOR_PARTICIPAING_IN_COMPARISON = Color.BLACK;
    public static final Color FGCOLOR_PARTICIPAING_IN_COMPARISON = Color.WHITE;
    public static final Color BGCOLOR_FROZEN = new Color(234, 234, 234);
    private ImageIcon nodeIcon;
    private ImageIcon wayIcon;
    private ImageIcon relationIcon;
    private Border rowNumberBorder = null;

    protected void loadIcons() {
        this.nodeIcon = ImageProvider.get("data", "node");
        this.wayIcon = ImageProvider.get("data", "way");
        this.relationIcon = ImageProvider.get("data", "relation");
    }

    public RelationMemberTableCellRenderer() {
        this.setIcon(null);
        this.setOpaque(true);
        this.loadIcons();
        this.rowNumberBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
    }

    public String buildToolTipText(OsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void reset() {
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.setBorder(null);
        this.setIcon(null);
        this.setToolTipText(null);
    }

    protected void renderBackground(ListMergeModel.EntriesTableModel model, RelationMember member, int row, int col, boolean isSelected) {
        Color bgc = Color.WHITE;
        if (col == 0) {
            if (model.getListMergeModel().isFrozen()) {
                bgc = BGCOLOR_FROZEN;
            } else if (model.isParticipatingInCurrentComparePair()) {
                bgc = BGCOLOR_PARTICIPAING_IN_COMPARISON;
            } else if (isSelected) {
                bgc = BGCOLOR_SELECTED;
            }
        } else if (model.getListMergeModel().isFrozen()) {
            bgc = BGCOLOR_FROZEN;
        } else if (member == null) {
            bgc = BGCOLOR_EMPTY_ROW;
        } else if (isSelected) {
            bgc = BGCOLOR_SELECTED;
        } else if (model.isParticipatingInCurrentComparePair()) {
            bgc = model.isSamePositionInOppositeList(row) ? BGCOLOR_SAME_POSITION_IN_OPPOSITE : (model.isIncludedInOppositeList(row) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        this.setBackground(bgc);
    }

    protected void renderForeground(ListMergeModel.EntriesTableModel model, RelationMember member, int row, int col, boolean isSelected) {
        Color fgc = Color.BLACK;
        if (col == 0 && model.isParticipatingInCurrentComparePair() && !model.getListMergeModel().isFrozen()) {
            fgc = Color.WHITE;
        }
        this.setForeground(fgc);
    }

    protected void renderRole(RelationMember member) {
        this.setText(member.getRole());
        this.setToolTipText(member.getRole());
    }

    protected void renderPrimitive(RelationMember member) {
        String displayName = member.getMember().getDisplayName(DefaultNameFormatter.getInstance());
        this.setText(displayName);
        this.setToolTipText(this.buildToolTipText(member.getMember()));
        if (member.isNode()) {
            this.setIcon(this.nodeIcon);
        } else if (member.isWay()) {
            this.setIcon(this.wayIcon);
        } else if (member.isRelation()) {
            this.setIcon(this.relationIcon);
        } else {
            this.setIcon(null);
        }
    }

    protected void renderRowId(int row) {
        this.setBorder(this.rowNumberBorder);
        this.setText(Integer.toString(row + 1));
    }

    protected void renderEmptyRow() {
        this.setIcon(null);
        this.setBackground(BGCOLOR_EMPTY_ROW);
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        RelationMember member = (RelationMember)value;
        this.reset();
        this.renderBackground(this.getModel(table), member, row, column, isSelected);
        this.renderForeground(this.getModel(table), member, row, column, isSelected);
        switch (column) {
            case 0: {
                this.renderRowId(row);
                break;
            }
            case 1: {
                if (member == null) {
                    this.renderEmptyRow();
                    break;
                }
                this.renderRole(member);
                break;
            }
            case 2: {
                if (member == null) {
                    this.renderEmptyRow();
                    break;
                }
                this.renderPrimitive(member);
                break;
            }
        }
        return this;
    }

    protected ListMergeModel.EntriesTableModel getModel(JTable table) {
        return (ListMergeModel.EntriesTableModel)table.getModel();
    }
}

