/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Filters;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class FilterDialog
extends ToggleDialog
implements DataChangeListener,
Layer.LayerChangeListener,
TableModelListener {
    private JTable userTable;
    private Filters filters = new Filters();
    private SideButton addButton;
    private SideButton editButton;
    private SideButton deleteButton;
    private SideButton upButton;
    private SideButton downButton;
    private JPopupMenu popupMenu;
    protected String[] columnToolTips = new String[]{I18n.tr("Enable filter"), I18n.tr("Hide elements"), null, I18n.tr("Apply also for children"), I18n.tr("Inverse filter"), I18n.tr("Filter mode")};

    public FilterDialog() {
        super(I18n.tr("Filter"), "filter", I18n.tr("Filter objects and hide/disable them."), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter")), 70, 4, 1), 162);
        Layer.listeners.add(this);
        this.build();
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new GridLayout(1, 4));
        this.addButton = new SideButton(I18n.marktr("Add"), "add", "SelectionList", I18n.tr("Add filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filters.addFilter(filter);
                    FilterDialog.this.filters.filter();
                }
            }
        });
        pnl.add(this.addButton);
        this.editButton = new SideButton(I18n.marktr("Edit"), "edit", "SelectionList", I18n.tr("Edit filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                Filter f = FilterDialog.this.filters.getFilter(index);
                Filter filter = (Filter)SearchAction.showSearchDialog(f);
                if (filter != null) {
                    FilterDialog.this.filters.setFilter(index, filter);
                    FilterDialog.this.filters.filter();
                }
            }
        });
        pnl.add(this.editButton);
        this.deleteButton = new SideButton(I18n.marktr("Delete"), "delete", "SelectionList", I18n.tr("Delete filter."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filters.removeFilter(index);
            }
        });
        pnl.add(this.deleteButton);
        this.upButton = new SideButton(I18n.marktr("Up"), "up", "SelectionList", I18n.tr("Move filter up."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filters.moveUpFilter(index);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
            }
        });
        pnl.add(this.upButton);
        this.downButton = new SideButton(I18n.marktr("Down"), "down", "SelectionList", I18n.tr("Move filter down."), new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int index = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (index < 0) {
                    return;
                }
                FilterDialog.this.filters.moveDownFilter(index);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
            }
        });
        pnl.add(this.downButton);
        return pnl;
    }

    protected void build() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        this.userTable = new JTable(this.filters){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent e) {
                        Object tip = null;
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return FilterDialog.this.columnToolTips[realIndex];
                    }
                };
            }
        };
        this.filters.addTableModelListener(this);
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(5).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.getColumnModel().getColumn(5).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        this.tableChanged(null);
        pnl.add((Component)new JScrollPane(this.userTable), "Center");
        pnl.add((Component)this.buildButtonRow(), "South");
        this.add((Component)pnl, "Center");
    }

    public void layerRemoved(Layer a) {
        if (a instanceof OsmDataLayer) {
            ((OsmDataLayer)a).listenerDataChanged.remove(this);
        }
    }

    public void layerAdded(Layer a) {
        if (a instanceof OsmDataLayer) {
            ((OsmDataLayer)a).listenerDataChanged.add(this);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.filters.filter();
    }

    public void dataChanged(OsmDataLayer l) {
        this.filters.filter();
    }

    public void tableChanged(TableModelEvent e) {
        this.setTitle("Filter Hidden:" + this.filters.hiddenCount + " Disabled:" + this.filters.disabledCount);
    }

    class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Filters model = (Filters)table.getModel();
            this.setSelected((Boolean)value);
            this.setEnabled(model.isCellEnabled(row, column));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Filters model = (Filters)table.getModel();
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setEnabled(model.isCellEnabled(row, column));
            return cell;
        }
    }
}

