/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTree;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildRelationBrowser
extends JPanel {
    private static final Logger logger = Logger.getLogger(ChildRelationBrowser.class.getName());
    private RelationTree childTree;
    private RelationTreeModel model;
    private OsmDataLayer layer;

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.childTree = new RelationTree(this.model);
        JScrollPane pane = new JScrollPane(this.childTree);
        this.add((Component)pane, "Center");
        this.add((Component)this.buildButtonPanel(), "South");
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        DownloadAllChildRelationsAction downloadAction = new DownloadAllChildRelationsAction();
        pnl.add(new JButton(downloadAction));
        DownloadSelectedAction downloadSelectedAction = new DownloadSelectedAction();
        this.childTree.addTreeSelectionListener(downloadSelectedAction);
        pnl.add(new JButton(downloadSelectedAction));
        EditAction editAction = new EditAction();
        this.childTree.addTreeSelectionListener(editAction);
        pnl.add(new JButton(editAction));
        return pnl;
    }

    public ChildRelationBrowser(OsmDataLayer layer) throws IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        this.layer = layer;
        this.model = new RelationTreeModel();
        this.build();
    }

    public ChildRelationBrowser(OsmDataLayer layer, Relation root) throws IllegalArgumentException {
        this(layer);
        this.populate(root);
    }

    public void populate(Relation r) {
        this.model.populate(r);
    }

    public void populate(List<RelationMember> members) {
        this.model.populate(members);
    }

    protected Dialog getParentDialog() {
        Container c;
        for (c = this; c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        return (Dialog)c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DownloadRelationSetTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private int conflictsCount;
        private Exception lastException;
        private Set<Relation> relations;

        public DownloadRelationSetTask(Dialog parent, Set<Relation> relations) {
            super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(parent), false);
            this.relations = relations;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void refreshView(Relation relation) {
            for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                Relation reference = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                if (reference != relation) continue;
                ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
            }
        }

        @Override
        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", this.conflictsCount), I18n.tr("Conflicts in data"), 2);
            }
        }

        protected void mergeDataSet(DataSet dataSet) {
            if (dataSet != null) {
                MergeVisitor visitor = new MergeVisitor(ChildRelationBrowser.this.getLayer().data, dataSet);
                visitor.merge();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChildRelationBrowser.this.getLayer().fireDataChange();
                    }
                });
                if (!visitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(visitor.getConflicts());
                    this.conflictsCount += visitor.getConflicts().size();
                }
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                Iterator<Relation> it = this.relations.iterator();
                while (it.hasNext() && !this.cancelled) {
                    Relation r = it.next();
                    if (r.isNew()) continue;
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", r.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader reader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    this.mergeDataSet(dataSet);
                    this.refreshView(r);
                }
            }
            catch (Exception e) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class DownloadAllChildrenTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private int conflictsCount;
        private Exception lastException;
        private Relation relation;
        private Stack<Relation> relationsToDownload;
        private Set<Long> downloadedRelationIds;

        public DownloadAllChildrenTask(Dialog parent, Relation r) {
            super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(parent), false);
            this.relation = r;
            this.relationsToDownload = new Stack();
            this.downloadedRelationIds = new HashSet<Long>();
            this.relationsToDownload.push(this.relation);
        }

        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void refreshView(Relation relation) {
            for (int i = 0; i < ChildRelationBrowser.this.childTree.getRowCount(); ++i) {
                Relation reference = (Relation)ChildRelationBrowser.this.childTree.getPathForRow(i).getLastPathComponent();
                if (reference != relation) continue;
                ChildRelationBrowser.this.model.refreshNode(ChildRelationBrowser.this.childTree.getPathForRow(i));
            }
        }

        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", this.conflictsCount), I18n.tr("Conflicts in data"), 2);
            }
        }

        protected void warnBecauseOfDeletedRelation(Relation r) {
            String message = I18n.tr("<html>The child relation<br>{0}<br>is deleted on the server. It can't be loaded", r.getDisplayName(DefaultNameFormatter.getInstance()));
            JOptionPane.showMessageDialog(Main.parent, message, I18n.tr("Relation is deleted"), 2);
        }

        protected void rememberChildRelationsToDownload(Relation parent) {
            this.downloadedRelationIds.add(parent.getId());
            for (RelationMember member : parent.getMembers()) {
                Relation child;
                if (!member.isRelation() || this.downloadedRelationIds.contains((child = member.getRelation()).getId())) continue;
                this.relationsToDownload.push(child);
            }
        }

        protected void mergeDataSet(DataSet ds) {
            if (ds != null) {
                MergeVisitor visitor = new MergeVisitor(ChildRelationBrowser.this.getLayer().data, ds);
                visitor.merge();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ChildRelationBrowser.this.getLayer().fireDataChange();
                    }
                });
                if (!visitor.getConflicts().isEmpty()) {
                    ChildRelationBrowser.this.getLayer().getConflicts().add(visitor.getConflicts());
                    this.conflictsCount += visitor.getConflicts().size();
                }
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                while (!this.relationsToDownload.isEmpty() && !this.cancelled) {
                    Relation r = this.relationsToDownload.pop();
                    if (r.isNew()) continue;
                    this.rememberChildRelationsToDownload(r);
                    this.progressMonitor.setCustomText(I18n.tr("Downloading relation {0}", r.getDisplayName(DefaultNameFormatter.getInstance())));
                    OsmServerObjectReader reader = new OsmServerObjectReader(r.getId(), OsmPrimitiveType.RELATION, true);
                    DataSet dataSet = null;
                    try {
                        dataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                    }
                    catch (OsmApiException e) {
                        if (e.getResponseCode() == 410) {
                            this.warnBecauseOfDeletedRelation(r);
                            continue;
                        }
                        throw e;
                    }
                    this.mergeDataSet(dataSet);
                    this.refreshView(r);
                }
            }
            catch (Exception e) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class DownloadSelectedAction
    extends AbstractAction
    implements TreeSelectionListener {
        public DownloadSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Download selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("Name", I18n.tr("Download Selected Children"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            HashSet<Relation> relations = new HashSet<Relation>();
            for (int i = 0; i < selection.length; ++i) {
                relations.add((Relation)selection[i].getLastPathComponent());
            }
            Main.worker.submit(new DownloadRelationSetTask(ChildRelationBrowser.this.getParentDialog(), relations));
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class DownloadAllChildRelationsAction
    extends AbstractAction {
        public DownloadAllChildRelationsAction() {
            this.putValue("ShortDescription", I18n.tr("Download all child relations (recursively)"));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.putValue("Name", I18n.tr("Download All Children"));
        }

        public void run() {
            Main.worker.submit(new DownloadAllChildrenTask(ChildRelationBrowser.this.getParentDialog(), (Relation)ChildRelationBrowser.this.model.getRoot()));
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }
    }

    class EditAction
    extends AbstractAction
    implements TreeSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.putValue("Name", I18n.tr("Edit"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            this.setEnabled(selection != null && selection.length > 0);
        }

        public void run() {
            TreePath[] selection = ChildRelationBrowser.this.childTree.getSelectionPaths();
            if (selection == null || selection.length == 0) {
                return;
            }
            for (int i = 0; i < Math.min(selection.length, 10); ++i) {
                Relation r = (Relation)selection[i].getLastPathComponent();
                if (r.incomplete) continue;
                RelationEditor editor = RelationEditor.getEditor(ChildRelationBrowser.this.getLayer(), r, null);
                editor.setVisible(true);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.refreshEnabled();
        }
    }
}

