/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTableModel
extends AbstractTableModel {
    private ArrayList<RelationMember> members = new ArrayList();
    private DefaultListSelectionModel listSelectionModel;
    private CopyOnWriteArrayList<IMemberModelListener> listeners = new CopyOnWriteArrayList();
    private OsmDataLayer layer;

    public MemberTableModel(OsmDataLayer layer) {
        this.layer = layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberModelListener(IMemberModelListener listener) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (listener != null && !this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberModelListener(IMemberModelListener listener) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (listener != null && this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMakeMemberVisible(int index) {
        CopyOnWriteArrayList<IMemberModelListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            for (IMemberModelListener listener : this.listeners) {
                listener.makeMemberVisible(index);
            }
        }
    }

    public void populate(Relation relation) {
        this.members.clear();
        if (relation != null) {
            this.members.addAll(new Relation(relation).getMembers());
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.members.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.members.get(rowIndex).getRole();
            }
            case 1: {
                return this.members.get(rowIndex).getMember();
            }
            case 2: {
                return this.wayConnection(rowIndex);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        RelationMember member = this.members.get(rowIndex);
        RelationMember newMember = new RelationMember(value.toString(), member.getMember());
        this.members.remove(rowIndex);
        this.members.add(rowIndex, newMember);
    }

    public OsmPrimitive getReferredPrimitive(int idx) {
        return this.members.get(idx).getMember();
    }

    public void moveUp(int[] selectedRows) {
        if (!this.canMoveUp(selectedRows)) {
            return;
        }
        for (int row : selectedRows) {
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row - 1);
            this.members.set(row, member2);
            this.members.set(row - 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(--row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] - 1);
    }

    public void moveDown(int[] selectedRows) {
        if (!this.canMoveDown(selectedRows)) {
            return;
        }
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int row = selectedRows[i];
            RelationMember member1 = this.members.get(row);
            RelationMember member2 = this.members.get(row + 1);
            this.members.set(row, member2);
            this.members.set(row + 1, member1);
        }
        this.fireTableDataChanged();
        this.getSelectionModel();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int row : selectedRows) {
            this.getSelectionModel().addSelectionInterval(++row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(selectedRows[0] + 1);
    }

    public void remove(int[] selectedRows) {
        if (!this.canRemove(selectedRows)) {
            return;
        }
        int offset = 0;
        for (int row : selectedRows) {
            this.members.remove(row -= offset);
            ++offset;
        }
        this.fireTableDataChanged();
    }

    public boolean canMoveUp(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return rows[0] > 0 && this.members.size() > 0;
    }

    public boolean canMoveDown(int[] rows) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        Arrays.sort(rows);
        return this.members.size() > 0 && rows[rows.length - 1] < this.members.size() - 1;
    }

    public boolean canRemove(int[] rows) {
        return rows != null && rows.length != 0;
    }

    public DefaultListSelectionModel getSelectionModel() {
        if (this.listSelectionModel == null) {
            this.listSelectionModel = new DefaultListSelectionModel();
            this.listSelectionModel.setSelectionMode(2);
        }
        return this.listSelectionModel;
    }

    public void updateMemberReferences(DataSet ds) {
        for (int i = 0; i < this.members.size(); ++i) {
            OsmPrimitive primitive;
            RelationMember member = this.members.get(i);
            if (member.getMember().isNew() || (primitive = ds.getPrimitiveById(member.getMember().getId(), OsmPrimitiveType.from(member.getMember()))) == null) continue;
            RelationMember newMember = new RelationMember(member.getRole(), primitive);
            this.members.remove(i);
            this.members.add(i, newMember);
        }
        this.fireTableDataChanged();
    }

    public void removeMembersReferringTo(List<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        Iterator<RelationMember> it = this.members.iterator();
        while (it.hasNext()) {
            RelationMember member = it.next();
            if (!primitives.contains(member.getMember())) continue;
            it.remove();
        }
        this.fireTableDataChanged();
    }

    public void applyToRelation(Relation relation) {
        relation.setMembers(this.members);
    }

    public boolean hasSameMembersAs(Relation relation) {
        if (relation == null) {
            return false;
        }
        if (relation.getMembersCount() != this.members.size()) {
            return false;
        }
        for (int i = 0; i < relation.getMembersCount(); ++i) {
            if (relation.getMember(i).equals(this.members.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean hasIncompleteMembers() {
        for (RelationMember member : this.members) {
            if (!member.getMember().incomplete) continue;
            return true;
        }
        return false;
    }

    protected List<Integer> getSelectedIndices() {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            selectedIndices.add(i);
        }
        return selectedIndices;
    }

    public void addMembersAtBeginning(List<OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive primitive : primitives) {
            RelationMember member = new RelationMember("", primitive);
            this.members.add(0, member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.fireMakeMemberVisible(0);
    }

    public void addMembersAtEnd(List<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(this.members.size() - 1 - i, this.members.size() - 1 - i);
        }
        this.fireMakeMemberVisible(this.members.size() - 1);
    }

    public void addMembersBeforeIdx(List<? extends OsmPrimitive> primitives, int idx) {
        if (primitives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(idx, member);
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(idx + i, idx + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(idx);
    }

    public void addMembersAfterIdx(List<? extends OsmPrimitive> primitives, int idx) {
        if (primitives == null) {
            return;
        }
        int j = 1;
        for (OsmPrimitive osmPrimitive : primitives) {
            RelationMember member = new RelationMember("", osmPrimitive);
            this.members.add(idx + j, member);
            ++j;
        }
        this.fireTableDataChanged();
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < primitives.size(); ++i) {
            this.getSelectionModel().addSelectionInterval(idx + 1 + i, idx + 1 + i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        this.fireMakeMemberVisible(idx + 1);
    }

    public int getNumMembersWithPrimitive(OsmPrimitive primitive) {
        int count = 0;
        for (RelationMember member : this.members) {
            if (!member.getMember().equals(primitive)) continue;
            ++count;
        }
        return count;
    }

    public void updateRole(int[] idx, String role) {
        if (idx == null || idx.length == 0) {
            return;
        }
        for (int row : idx) {
            RelationMember oldMember = this.members.get(row);
            RelationMember newMember = new RelationMember(role, oldMember.getMember());
            this.members.remove(row);
            this.members.add(row, newMember);
        }
        this.fireTableDataChanged();
        for (int row : idx) {
            this.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public Collection<RelationMember> getSelectedMembers() {
        ArrayList<RelationMember> selectedMembers = new ArrayList<RelationMember>();
        for (int i : this.getSelectedIndices()) {
            selectedMembers.add(this.members.get(i));
        }
        return selectedMembers;
    }

    public Set<OsmPrimitive> getSelectedChildPrimitives() {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        for (RelationMember m : this.getSelectedMembers()) {
            ret.add(m.getMember());
        }
        return ret;
    }

    public Set<OsmPrimitive> getChildPrimitives(Collection<? extends OsmPrimitive> referenceSet) {
        HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
        if (referenceSet == null) {
            return null;
        }
        for (RelationMember m : this.members) {
            if (!referenceSet.contains(m.getMember())) continue;
            ret.add(m.getMember());
        }
        return ret;
    }

    public boolean selectionsAreInSync() {
        HashSet<OsmPrimitive> s1 = new HashSet<OsmPrimitive>(this.getSelectedChildPrimitives());
        if (s1.size() != this.layer.data.getSelected().size()) {
            return false;
        }
        s1.removeAll(this.layer.data.getSelected());
        return s1.isEmpty();
    }

    public void setSelectedMembers(Collection<RelationMember> selectedMembers) {
        if (selectedMembers == null || selectedMembers.isEmpty()) {
            return;
        }
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        for (RelationMember member : selectedMembers) {
            for (int idx = 0; idx < this.members.size(); ++idx) {
                if (!this.members.get(idx).equals(member) || selectedIndices.contains(idx)) continue;
                selectedIndices.add(idx);
            }
        }
        Collections.sort(selectedIndices);
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        Iterator<RelationMember> i$ = selectedIndices.iterator();
        while (i$.hasNext()) {
            int row = (Integer)((Object)i$.next());
            this.getSelectionModel().addSelectionInterval(row, row);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (selectedIndices.size() > 0) {
            this.fireMakeMemberVisible((Integer)selectedIndices.get(0));
        }
    }

    public boolean isEditableRelation(int index) {
        if (index < 0 || index >= this.members.size()) {
            return false;
        }
        RelationMember member = this.members.get(index);
        if (!member.isRelation()) {
            return false;
        }
        Relation r = member.getRelation();
        return !r.incomplete;
    }

    public boolean hasMembersReferringTo(Collection<OsmPrimitive> primitives) {
        if (primitives == null || primitives.isEmpty()) {
            return false;
        }
        HashSet<OsmPrimitive> referrers = new HashSet<OsmPrimitive>();
        for (RelationMember member : this.members) {
            referrers.add(member.getMember());
        }
        for (OsmPrimitive referred : primitives) {
            if (!referrers.contains(referred)) continue;
            return true;
        }
        return false;
    }

    public void selectMembersReferringTo(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            return;
        }
        this.getSelectionModel().setValueIsAdjusting(true);
        this.getSelectionModel().clearSelection();
        for (int i = 0; i < this.members.size(); ++i) {
            RelationMember m = this.members.get(i);
            if (!primitives.contains(m.getMember())) continue;
            this.getSelectionModel().addSelectionInterval(i, i);
        }
        this.getSelectionModel().setValueIsAdjusting(false);
        if (this.getSelectedIndices().size() > 0) {
            this.fireMakeMemberVisible(this.getSelectedIndices().get(0));
        }
    }

    protected boolean isActiveLayer() {
        if (Main.map == null || Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getActiveLayer() == this.layer;
    }

    private static Node getUnusedNode(RelationMember element, RelationMember linked_element) {
        Node result = null;
        if (element.isWay()) {
            Way w = element.getWay();
            if (linked_element.isWay()) {
                Way x = linked_element.getWay();
                result = w.firstNode() == x.firstNode() || w.firstNode() == x.lastNode() ? w.lastNode() : w.firstNode();
            } else if (linked_element.isNode()) {
                Node m = linked_element.getNode();
                result = w.firstNode() == m ? w.lastNode() : w.firstNode();
            }
        } else if (element.isNode()) {
            Node n;
            result = n = element.getNode();
        }
        return result;
    }

    void sort() {
        LinkedList<Integer> segment;
        RelationNodeMap map = new RelationNodeMap(this.members);
        if (map.isEmpty()) {
            return;
        }
        Vector segments = new Vector();
        while (!map.isEmpty()) {
            boolean something_done;
            Integer next;
            if (segments.size() == 0 && map.remove(0, this.members.get(0))) {
                next = 0;
            } else {
                next = map.pop();
                if (next == null) break;
            }
            segment = new LinkedList();
            segment.add(next);
            segments.add(segment);
            do {
                Integer m2;
                something_done = false;
                Node startSearchNode = null;
                Node endSearchNode = null;
                if (segment.size() == 1) {
                    RelationMember m = this.members.get((Integer)segment.getFirst());
                    if (m.isWay()) {
                        Way way = m.getWay();
                        endSearchNode = way.lastNode();
                        if (way.lastNode() != way.firstNode()) {
                            startSearchNode = way.firstNode();
                        }
                    } else if (m.isNode()) {
                        Node node;
                        endSearchNode = node = m.getNode();
                    }
                } else {
                    startSearchNode = MemberTableModel.getUnusedNode(this.members.get((Integer)segment.getFirst()), this.members.get((Integer)segment.get(1)));
                    endSearchNode = MemberTableModel.getUnusedNode(this.members.get((Integer)segment.getLast()), this.members.get((Integer)segment.get(segment.size() - 2)));
                }
                if (startSearchNode != null && (m2 = map.find(startSearchNode, (Integer)segment.getFirst())) != null) {
                    segment.add(0, m2);
                    map.remove(m2, this.members.get(m2));
                    something_done = true;
                }
                if (endSearchNode == null || (m2 = map.find(endSearchNode, (Integer)segment.getLast())) == null) continue;
                segment.add(segment.size(), m2);
                map.remove(m2, this.members.get(m2));
                something_done = true;
            } while (something_done);
        }
        if (segments.size() > 0) {
            segment = new LinkedList<Integer>();
            segment.addAll(map.getRemaining());
            segments.add(segment);
            ArrayList<RelationMember> newmembers = new ArrayList<RelationMember>();
            for (LinkedList linkedList : segments) {
                for (Integer p : linkedList) {
                    newmembers.add(this.members.get(p));
                }
            }
            this.members.clear();
            this.members.addAll(newmembers);
            this.fireTableDataChanged();
        }
    }

    private Integer linked(int i) {
        Integer link = null;
        RelationMember m1 = this.members.get(i);
        RelationMember m2 = this.members.get((i + 1) % this.members.size());
        Way way1 = null;
        Way way2 = null;
        if (m1.isWay()) {
            way1 = m1.getWay();
        }
        if (m2.isWay()) {
            way2 = m2.getWay();
        }
        if (way1 != null && way2 != null) {
            Node way1first = way1.firstNode();
            Node way1last = way1.lastNode();
            Node way2first = way2.firstNode();
            Node way2last = way2.lastNode();
            if (way1first != null && way2first != null && way1first == way2first) {
                link = -1;
            } else if (way1first != null && way2last != null && way1first == way2last) {
                link = 1;
            } else if (way1last != null && way2first != null && way1last == way2first) {
                link = 1;
            } else if (way1last != null && way2last != null && way1last == way2last) {
                link = -1;
            }
        }
        return link;
    }

    private WayConnectionType wayConnection(int i) {
        Integer link;
        RelationMember m = this.members.get(i);
        if (!m.isWay()) {
            return new WayConnectionType();
        }
        Way w = m.getWay();
        if (w == null || w.incomplete) {
            return new WayConnectionType();
        }
        int ip = (i - 1 + this.members.size()) % this.members.size();
        Integer link_p = this.linked(ip);
        Integer link_n = this.linked(i);
        Integer dir = 1;
        for (int k = i - 1; k >= 0 && (link = this.linked(k)) != null; --k) {
            dir = dir * link;
        }
        return new WayConnectionType(link_p != null, link_n != null, dir);
    }
}

