/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dialog;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.RelationTreeModel;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class RelationTree
extends JTree {
    private static final Logger logger = Logger.getLogger(RelationTree.class.getName());

    protected void build() {
        this.setRootVisible(false);
        this.setCellRenderer(new RelationTreeCellRenderer());
        this.addTreeWillExpandListener(new LazyRelationLoader());
    }

    public RelationTree() {
        this.build();
    }

    public RelationTree(RelationTreeModel model) {
        super(model);
        this.build();
    }

    protected Dialog getParentDialog() {
        Container c;
        for (c = this; c != null && !(c instanceof Dialog); c = c.getParent()) {
        }
        return (Dialog)c;
    }

    class RelationLoader
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private Exception lastException;
        private Relation relation;
        private DataSet ds;
        private TreePath path;

        public RelationLoader(Dialog dialog, Relation relation, TreePath path) {
            super(I18n.tr("Load relation"), new PleaseWaitProgressMonitor(dialog), false);
            this.relation = relation;
            this.path = path;
        }

        protected void cancel() {
            OsmApi.getOsmApi().cancel();
            this.cancelled = true;
        }

        protected void finish() {
            if (this.cancelled) {
                return;
            }
            if (this.lastException != null) {
                this.lastException.printStackTrace();
                return;
            }
            MergeVisitor visitor = new MergeVisitor(Main.main.getEditLayer().data, this.ds);
            visitor.merge();
            if (!visitor.getConflicts().isEmpty()) {
                Main.main.getEditLayer().getConflicts().add(visitor.getConflicts());
            }
            final RelationTreeModel model = (RelationTreeModel)RelationTree.this.getModel();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    model.refreshNode(RelationLoader.this.path);
                }
            });
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                OsmServerObjectReader reader = new OsmServerObjectReader(this.relation.getId(), OsmPrimitiveType.from(this.relation), true);
                this.ds = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception e) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task was cancelled. Exception was: " + e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class LazyRelationLoader
    implements TreeWillExpandListener {
        LazyRelationLoader() {
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }

        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            Relation parent = (Relation)event.getPath().getLastPathComponent();
            if (!parent.incomplete || parent.isNew()) {
                return;
            }
            Main.worker.submit(new RelationLoader(RelationTree.this.getParentDialog(), parent, path));
        }
    }
}

